/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

public final class RespawnLocation
implements DataSerializable {
    private final UUID worldId;
    private final Vector3d position;
    private final boolean forced;

    public static Builder builder() {
        return new Builder();
    }

    RespawnLocation(Builder builder) {
        this.worldId = (UUID)Preconditions.checkNotNull((Object)builder.world, (Object)"World UUID");
        this.position = (Vector3d)Preconditions.checkNotNull((Object)builder.position, (Object)"Position");
        this.forced = builder.forced;
    }

    public UUID getWorldUniqueId() {
        return this.worldId;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public boolean isForced() {
        return this.forced;
    }

    public Optional<Location<World>> asLocation() {
        Optional<World> world = Sponge.getServer().getWorld(this.getWorldUniqueId());
        if (!world.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new Location<Extent>((Extent)world.get(), this.getPosition()));
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(Queries.POSITION_X, (Object)this.getPosition().getX()).set(Queries.POSITION_Y, (Object)this.getPosition().getY()).set(Queries.POSITION_Z, (Object)this.getPosition().getZ()).set(Queries.FORCED_SPAWN, (Object)this.isForced()).set(Queries.WORLD_ID, (Object)this.getWorldUniqueId().toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RespawnLocation that = (RespawnLocation)o;
        return this.forced == that.forced && Objects.equals(this.worldId, that.worldId) && Objects.equals(this.position, that.position);
    }

    public int hashCode() {
        return Objects.hash(this.worldId, this.position, this.forced);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("worldId", (Object)this.worldId).add("position", (Object)this.position).add("forced", this.forced).toString();
    }

    public static final class Builder
    extends AbstractDataBuilder<RespawnLocation> {
        @Nullable
        UUID world;
        @Nullable
        Vector3d position;
        boolean forced = false;

        public Builder() {
            super(RespawnLocation.class, 1);
        }

        public Builder world(World world) {
            return this.world(((World)Preconditions.checkNotNull((Object)world, (Object)"World cannot be null!")).getUniqueId());
        }

        public Builder world(UUID worldId) {
            this.world = (UUID)Preconditions.checkNotNull((Object)worldId, (Object)"World UUID cannot be null!");
            return this;
        }

        public Builder location(Location<World> location) {
            Preconditions.checkNotNull(location, (Object)"Location cannot be null!");
            World world = location.getExtent();
            this.position(location.getPosition());
            this.world(world.getUniqueId());
            return this;
        }

        public Builder position(Vector3d position) {
            this.position = (Vector3d)Preconditions.checkNotNull((Object)position, (Object)"Position cannot be null!");
            return this;
        }

        public Builder forceSpawn(boolean isForced) {
            this.forced = isForced;
            return this;
        }

        @Override
        protected Optional<RespawnLocation> buildContent(DataView container) throws InvalidDataException {
            String worldString = container.getString(Queries.WORLD_ID).get();
            UUID worldId = UUID.fromString(worldString);
            double xPos = container.getDouble(Queries.POSITION_X).get();
            double yPos = container.getDouble(Queries.POSITION_Y).get();
            double zPos = container.getDouble(Queries.POSITION_Z).get();
            Vector3d position = new Vector3d(xPos, yPos, zPos);
            boolean forcedSpawn = container.getBoolean(Queries.FORCED_SPAWN).orElse(false);
            Builder builder = new Builder();
            builder.world = worldId;
            builder.position = position;
            builder.forced = forcedSpawn;
            return Optional.of(new RespawnLocation(builder));
        }

        @Override
        public Builder reset() {
            this.world = null;
            this.position = null;
            this.forced = false;
            return this;
        }

        @Override
        public Builder from(RespawnLocation value) {
            Preconditions.checkNotNull((Object)value, (Object)"RespawnLocation cannot be null!");
            this.world = value.getWorldUniqueId();
            this.position = value.getPosition();
            this.forced = value.isForced();
            return this;
        }

        public RespawnLocation build() {
            Preconditions.checkNotNull((Object)this.world, (Object)"World id cannot be null!");
            Preconditions.checkNotNull((Object)this.position, (Object)"Position cannot be null!");
            return new RespawnLocation(this);
        }
    }
}

