/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.meta;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.meta.PatternLayer;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.type.BannerPatternShape;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.common.data.meta.SpongePatternLayer;
import org.spongepowered.common.util.Constants;

public class SpongePatternLayerBuilder
extends AbstractDataBuilder<PatternLayer>
implements PatternLayer.Builder,
DataBuilder<PatternLayer> {
    private DyeColor color;
    private BannerPatternShape shape;

    public SpongePatternLayerBuilder() {
        super(PatternLayer.class, 1);
    }

    @Override
    protected Optional<PatternLayer> buildContent(DataView container) throws InvalidDataException {
        Preconditions.checkNotNull((Object)container);
        if (!container.contains(Constants.TileEntity.Banner.SHAPE) || !container.contains(Constants.TileEntity.Banner.COLOR)) {
            return Optional.empty();
        }
        String id = container.getString(Constants.TileEntity.Banner.SHAPE).get();
        Optional<BannerPatternShape> shapeOptional = Sponge.getRegistry().getType(BannerPatternShape.class, id);
        if (!shapeOptional.isPresent()) {
            throw new InvalidDataException("The provided container has an invalid banner pattern shape entry!");
        }
        String dyeColorId = container.getString(Constants.TileEntity.Banner.COLOR).get();
        Optional<DyeColor> colorOptional = Sponge.getRegistry().getType(DyeColor.class, dyeColorId);
        if (!colorOptional.isPresent()) {
            throw new InvalidDataException("The provided container has an invalid dye color entry!");
        }
        return Optional.of(new SpongePatternLayer(shapeOptional.get(), colorOptional.get()));
    }

    @Override
    public SpongePatternLayerBuilder reset() {
        this.shape = null;
        this.color = null;
        return this;
    }

    @Override
    public PatternLayer.Builder pattern(BannerPatternShape shape) {
        this.shape = (BannerPatternShape)Preconditions.checkNotNull((Object)shape);
        return this;
    }

    @Override
    public PatternLayer.Builder color(DyeColor color) {
        this.color = (DyeColor)Preconditions.checkNotNull((Object)color);
        return this;
    }

    @Override
    public PatternLayer build() {
        Preconditions.checkState((this.shape != null ? 1 : 0) != 0);
        Preconditions.checkState((this.color != null ? 1 : 0) != 0);
        return new SpongePatternLayer(this.shape, this.color);
    }
}

