/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.item;

import java.util.Optional;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionUtils;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutablePotionColorData;
import org.spongepowered.api.data.manipulator.mutable.PotionColorData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.util.Color;
import org.spongepowered.common.data.manipulator.mutable.SpongePotionColorData;
import org.spongepowered.common.data.processor.common.AbstractItemSingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class ItemPotionColorDataProcessor
extends AbstractItemSingleDataProcessor<Color, Value<Color>, PotionColorData, ImmutablePotionColorData> {
    public ItemPotionColorDataProcessor() {
        super((ItemStack itemStack) -> itemStack.func_77973_b() == Items.field_151068_bn || itemStack.func_77973_b() == Items.field_185155_bH || itemStack.func_77973_b() == Items.field_185156_bI, Keys.POTION_COLOR);
    }

    @Override
    protected boolean set(ItemStack dataHolder, Color value) {
        if (!dataHolder.func_77942_o()) {
            dataHolder.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound mainCompound = dataHolder.func_77978_p();
        mainCompound.func_74768_a("CustomPotionColor", value.getRgb());
        return true;
    }

    @Override
    protected Optional<Color> getVal(ItemStack dataHolder) {
        return Optional.of(Color.ofRgb(PotionUtils.func_190932_c((ItemStack)dataHolder)));
    }

    @Override
    protected ImmutableValue<Color> constructImmutableValue(Color value) {
        return new ImmutableSpongeValue<Color>(Keys.POTION_COLOR, value);
    }

    @Override
    protected Value<Color> constructValue(Color actualValue) {
        return new SpongeValue<Color>(Keys.POTION_COLOR, actualValue);
    }

    @Override
    protected PotionColorData createManipulator() {
        return new SpongePotionColorData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (!this.supports(container)) {
            return DataTransactionResult.failNoData();
        }
        ItemStack itemStack = (ItemStack)container;
        if (!itemStack.func_77942_o()) {
            return DataTransactionResult.successNoData();
        }
        NBTTagCompound mainCompound = itemStack.func_77978_p();
        if (!mainCompound.func_150297_b("CustomPotionColor", 3)) {
            return DataTransactionResult.successNoData();
        }
        Color removedColor = Color.ofRgb(mainCompound.func_74762_e("CustomPotionColor"));
        mainCompound.func_82580_o("CustomPotionColor");
        return DataTransactionResult.successRemove(this.constructImmutableValue(removedColor));
    }
}

