/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.util.Optional;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.bridge.entity.LivingEntityBaseBridge;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class MaxAirValueProcessor
extends AbstractSpongeValueProcessor<LivingEntityBaseBridge, Integer, MutableBoundedValue<Integer>> {
    public MaxAirValueProcessor() {
        super(LivingEntityBaseBridge.class, Keys.MAX_AIR);
    }

    @Override
    public MutableBoundedValue<Integer> constructValue(Integer defaultValue) {
        return SpongeValueFactory.boundedBuilder(Keys.MAX_AIR).defaultValue(300).minimum(0).maximum(Integer.MAX_VALUE).actualValue(defaultValue).build();
    }

    @Override
    protected boolean set(LivingEntityBaseBridge container, Integer value) {
        if (value < 0) {
            return false;
        }
        container.bridge$setMaxAir(value);
        return true;
    }

    @Override
    protected Optional<Integer> getVal(LivingEntityBaseBridge container) {
        return Optional.of(container.bridge$getMaxAir());
    }

    @Override
    protected ImmutableValue<Integer> constructImmutableValue(Integer value) {
        return this.constructValue(value).asImmutable();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

