/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.status;

import java.net.InetSocketAddress;
import javax.annotation.Nullable;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.server.ClientPingServerEvent;
import org.spongepowered.api.network.status.StatusClient;
import org.spongepowered.api.network.status.StatusResponse;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.network.status.SpongeLegacyStatusClient;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.text.serializer.LegacyTexts;
import org.spongepowered.common.util.NetworkUtil;

public final class SpongeStatusResponse {
    private SpongeStatusResponse() {
    }

    @Nullable
    public static ServerStatusResponse post(MinecraftServer server, StatusClient client) {
        return SpongeStatusResponse.call(SpongeStatusResponse.create(server), client);
    }

    @Nullable
    public static ServerStatusResponse postLegacy(MinecraftServer server, InetSocketAddress address, MinecraftVersion version, InetSocketAddress virtualHost) {
        ServerStatusResponse response = SpongeStatusResponse.create(server);
        response.func_151321_a(new ServerStatusResponse.Version(response.func_151322_c().func_151303_a(), 127));
        response = SpongeStatusResponse.call(response, new SpongeLegacyStatusClient(address, version, virtualHost));
        if (response != null && response.func_151318_b() == null) {
            response.func_151319_a(new ServerStatusResponse.Players(-1, 0));
        }
        return response;
    }

    @Nullable
    private static ServerStatusResponse call(ServerStatusResponse response, StatusClient client) {
        if (!SpongeImpl.postEvent(SpongeEventFactory.createClientPingServerEvent(Cause.of(EventContext.empty(), Sponge.getServer()), client, (ClientPingServerEvent.Response)response))) {
            return response;
        }
        return null;
    }

    public static ServerStatusResponse create(MinecraftServer server) {
        return SpongeStatusResponse.clone(server.func_147134_at());
    }

    private static ServerStatusResponse clone(ServerStatusResponse original) {
        ServerStatusResponse clone = new ServerStatusResponse();
        clone.func_151315_a(original.func_151317_a());
        if (original.func_151316_d() != null) {
            ((ClientPingServerEvent.Response)clone).setFavicon(((StatusResponse)original).getFavicon().get());
        }
        clone.func_151319_a(SpongeStatusResponse.clone(original.func_151318_b()));
        clone.func_151321_a(SpongeStatusResponse.clone(original.func_151322_c()));
        return clone;
    }

    @Nullable
    private static ServerStatusResponse.Players clone(@Nullable ServerStatusResponse.Players original) {
        if (original != null) {
            ServerStatusResponse.Players clone = new ServerStatusResponse.Players(original.func_151332_a(), original.func_151333_b());
            clone.func_151330_a(original.func_151331_c());
            return clone;
        }
        return null;
    }

    @Nullable
    private static ServerStatusResponse.Version clone(@Nullable ServerStatusResponse.Version original) {
        return original != null ? new ServerStatusResponse.Version(original.func_151303_a(), original.func_151304_b()) : null;
    }

    public static String getMotd(ServerStatusResponse response) {
        return SpongeStatusResponse.getFirstLine(SpongeTexts.toLegacy(response.func_151317_a()));
    }

    public static String getUnformattedMotd(ServerStatusResponse response) {
        return SpongeStatusResponse.getFirstLine(LegacyTexts.stripAll(response.func_151317_a().func_150260_c(), '\u00a7'));
    }

    private static String getFirstLine(String s) {
        return NetworkUtil.substringBefore(s, '\n');
    }
}

