/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.plugin;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ILanguageAdapter;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.ProxyInjector;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionParser;
import net.minecraftforge.fml.common.versioning.VersionRange;
import net.minecraftforge.fml.relauncher.Side;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.inject.plugin.PluginModule;
import org.spongepowered.common.plugin.PluginContainerExtension;
import org.spongepowered.mod.plugin.InvalidPluginException;

public class SpongeModPluginContainer
implements ModContainer,
PluginContainerExtension {
    @Inject
    private static Injector spongeInjector;
    private final String id;
    private final String className;
    private final ModCandidate candidate;
    private final Map<String, Object> descriptor;
    private ModMetadata metadata;
    private boolean invalid;
    private boolean enabled = true;
    private Object instance;
    private DefaultArtifactVersion processedVersion;
    private LoadController controller;
    private Injector injector;
    private PluginContainer pluginContainer = (PluginContainer)((Object)this);
    private static final String ID_WARNING = "Plugin IDs should be lowercase, and only contain characters from a-z, dashes or underscores, start with a lowercase letter, and not exceed 64 characters.";

    public SpongeModPluginContainer(String className, ModCandidate candidate, Map<String, Object> descriptor) {
        this.id = (String)Preconditions.checkNotNull((Object)((String)descriptor.get("id")), (Object)"id");
        this.className = className;
        this.candidate = candidate;
        this.descriptor = descriptor;
        if (!Plugin.ID_PATTERN.matcher(this.id).matches()) {
            SpongeImpl.getLogger().error("Skipping plugin with invalid plugin ID '{}'. Plugin IDs should be lowercase, and only contain characters from a-z, dashes or underscores, start with a lowercase letter, and not exceed 64 characters.", (Object)this.id);
            this.invalid = true;
        }
    }

    public String getModId() {
        return this.id;
    }

    public String getName() {
        return this.metadata.name;
    }

    public String getVersion() {
        return this.metadata.version;
    }

    public File getSource() {
        return this.candidate.getModContainer();
    }

    public ModMetadata getMetadata() {
        return this.metadata;
    }

    public void bindMetadata(MetadataCollection mc) {
        this.metadata = mc.getMetadataForId(this.id, this.descriptor);
        if (Strings.isNullOrEmpty((String)this.metadata.name)) {
            this.metadata.name = this.id;
        }
        if (this.metadata.version == null) {
            this.metadata.version = "";
        }
        if (this.metadata.autogenerated) {
            Iterable depDescriptors;
            Object deps;
            if (!this.invalid) {
                SpongeImpl.getLogger().warn("Plugin '{}' seems to be missing a valid mcmod.info metadata file. This is not a problem when testing plugins, however it is recommended to include one in public plugins.\nPlease see https://docs.spongepowered.org/master/en/plugin/plugin-meta.html for details.", (Object)this.id);
            }
            this.metadata.description = this.getDescriptorValue("description");
            this.metadata.url = this.getDescriptorValue("url");
            Collection authors = (Collection)this.descriptor.get("authors");
            if (authors != null) {
                this.metadata.authorList = new ArrayList(authors);
            }
            if ((deps = this.descriptor.get("dependencies")) != null && (depDescriptors = (Iterable)this.descriptor.get("dependencies")) != null) {
                Set requirements = this.metadata.requiredMods;
                List dependencies = this.metadata.dependencies;
                for (Map depDescriptor : depDescriptors) {
                    String dep = (String)Preconditions.checkNotNull((Object)((String)depDescriptor.get("id")), (Object)"dependency id");
                    if (this.id.equals(dep)) {
                        this.invalid = true;
                        SpongeImpl.getLogger().error("Plugin '{}' cannot have a dependency on itself. This is redundant and should be removed.", (Object)this.id);
                        continue;
                    }
                    String depVersion = (String)depDescriptor.get("version");
                    DefaultArtifactVersion dependency = Strings.isNullOrEmpty((String)depVersion) ? new DefaultArtifactVersion(dep, true) : new DefaultArtifactVersion(dep, VersionParser.parseRange((String)depVersion));
                    Boolean optional = (Boolean)depDescriptor.get("optional");
                    if (optional == null || !optional.booleanValue()) {
                        requirements.add(dependency);
                    }
                    dependencies.add(dependency);
                }
            }
        } else {
            Iterator itr = this.metadata.requiredMods.iterator();
            while (itr.hasNext()) {
                if (!this.id.equals(((ArtifactVersion)itr.next()).getLabel())) continue;
                SpongeImpl.getLogger().warn("Plugin '{}' requires itself to be loaded. This is redundant and can be removed from the dependencies.", (Object)this.id);
                itr.remove();
            }
            if (!this.metadata.dependants.isEmpty()) {
                SpongeImpl.getLogger().error("Invalid dependency with load order AFTER on plugin '{}'. This is currently not supported for Sponge plugins. Requested dependencies: {}", (Object)this.id, (Object)this.metadata.dependants);
                this.invalid = true;
            }
            this.metadata.dependants = ImmutableList.of();
        }
    }

    private String getDescriptorValue(String key) {
        return (String)this.descriptor.getOrDefault(key, "");
    }

    public void setEnabledState(boolean isEnabled) {
        this.enabled = isEnabled;
    }

    public Set<ArtifactVersion> getRequirements() {
        return this.metadata.requiredMods;
    }

    public List<ArtifactVersion> getDependencies() {
        return this.metadata.dependencies;
    }

    public List<ArtifactVersion> getDependants() {
        return this.metadata.dependants;
    }

    public String getSortingRules() {
        return this.metadata.printableSortingRules();
    }

    public boolean matches(Object mod) {
        return this.instance == mod;
    }

    public Object getMod() {
        return this.instance;
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        if (this.enabled) {
            this.controller = controller;
            bus.register((Object)this);
            return true;
        }
        return false;
    }

    @Subscribe
    public void constructMod(FMLConstructionEvent event) {
        try {
            Injector injector;
            if (this.invalid) {
                throw new InvalidPluginException();
            }
            ModClassLoader modClassLoader = event.getModClassLoader();
            modClassLoader.addFile(this.getSource());
            modClassLoader.clearNegativeCacheFor(this.candidate.getClassList());
            Class<?> pluginClazz = Class.forName(this.className, true, (ClassLoader)modClassLoader);
            this.injector = injector = spongeInjector.getParent().createChildInjector(new PluginModule((PluginContainer)((Object)this), pluginClazz));
            this.instance = injector.getInstance(pluginClazz);
            ProxyInjector.inject((ModContainer)this, (ASMDataTable)event.getASMHarvestedData(), (Side)FMLCommonHandler.instance().getSide(), (ILanguageAdapter)new ILanguageAdapter.JavaAdapter());
            Sponge.getEventManager().registerListeners(this, this.instance);
        }
        catch (Throwable t) {
            this.controller.errorOccurred((ModContainer)this, t);
        }
    }

    public ArtifactVersion getProcessedVersion() {
        if (this.processedVersion == null) {
            String version = this.getVersion();
            this.processedVersion = Strings.isNullOrEmpty((String)version) ? new DefaultArtifactVersion(this.id, true) : new DefaultArtifactVersion(this.id, version);
        }
        return this.processedVersion;
    }

    public boolean isImmutable() {
        return false;
    }

    public String getDisplayVersion() {
        return this.getVersion();
    }

    public VersionRange acceptableMinecraftVersionRange() {
        return Loader.instance().getMinecraftModContainer().getStaticVersionRange();
    }

    public Certificate getSigningCertificate() {
        return null;
    }

    public Map<String, String> getCustomModProperties() {
        return EMPTY_PROPERTIES;
    }

    public Class<?> getCustomResourcePackClass() {
        try {
            return Class.forName(this.getSource().isDirectory() ? "net.minecraftforge.fml.client.FMLFolderResourcePack" : "net.minecraftforge.fml.client.FMLFileResourcePack", true, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public Map<String, String> getSharedModDescriptor() {
        HashMap<String, String> descriptor = new HashMap<String, String>();
        descriptor.put("modsystem", "Sponge");
        descriptor.put("id", this.id);
        descriptor.put("version", this.getDisplayVersion());
        descriptor.put("name", this.getName());
        descriptor.put("url", this.metadata.url);
        descriptor.put("authors", this.metadata.getAuthorList());
        descriptor.put("description", this.metadata.description);
        return descriptor;
    }

    public ModContainer.Disableable canBeDisabled() {
        return ModContainer.Disableable.RESTART;
    }

    public String getGuiClassName() {
        return null;
    }

    public List<String> getOwnedPackages() {
        return this.candidate.getContainedPackages();
    }

    public boolean shouldLoadInEnvironment() {
        return true;
    }

    public URL getUpdateUrl() {
        return null;
    }

    public void setClassVersion(int classVersion) {
    }

    public int getClassVersion() {
        return 0;
    }

    @Override
    public Injector getInjector() {
        return this.injector;
    }

    public final String toString() {
        return MoreObjects.toStringHelper((String)"Plugin").omitNullValues().add("id", (Object)this.pluginContainer.getId()).add("name", (Object)this.pluginContainer.getName()).add("version", this.pluginContainer.getVersion().orElse(null)).add("description", this.pluginContainer.getDescription().orElse(null)).add("url", this.pluginContainer.getUrl().orElse(null)).add("authors", this.pluginContainer.getAuthors().isEmpty() ? null : this.pluginContainer.getAuthors()).add("source", this.pluginContainer.getSource().orElse(null)).toString();
    }
}

