/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.configurate.settingprocessor;

import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.nucleus.modules.core.services.UUIDChangeService;
import io.github.nucleuspowered.relocate.nucleus.neutrino.settingprocessor.SettingProcessor;
import java.util.UUID;
import javax.inject.Inject;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;

public class WorldMigrationSettingProcessor
implements SettingProcessor {
    private final UUIDChangeService service;
    private static final TypeToken<UUID> uuidTypeToken = TypeToken.of(UUID.class);

    @Inject
    public WorldMigrationSettingProcessor(UUIDChangeService service) {
        this.service = service;
    }

    @Override
    public void process(ConfigurationNode cn) {
        try {
            UUID uuid = (UUID)cn.getValue(uuidTypeToken);
            this.service.getMappedUUID(uuid).ifPresent(x -> {
                try {
                    cn.setValue(uuidTypeToken, x);
                }
                catch (ObjectMappingException objectMappingException) {
                    // empty catch block
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

