/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.datatypes;

import com.flowpowered.math.vector.Vector3d;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

public class UUIDTransform {
    private final UUID world;
    private final Vector3d position;
    private final Vector3d rotation;

    public UUIDTransform(Transform<World> worldTransform) {
        this(((World)worldTransform.getExtent()).getUniqueId(), worldTransform.getPosition(), worldTransform.getRotation());
    }

    public UUIDTransform(UUID world, Vector3d position, Vector3d rotation) {
        this.world = world;
        this.position = position;
        this.rotation = rotation;
    }

    public Optional<World> getWorld() {
        return Sponge.getServer().getWorld(this.world);
    }

    public Optional<World> loadWorld() {
        return Sponge.getServer().loadWorld(this.world);
    }

    public UUID getWorldUUID() {
        return this.world;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public Vector3d getRotation() {
        return this.rotation;
    }

    public Optional<Transform<World>> getTransform() {
        return this.getWorld().map(x -> new Transform((Extent)x, this.position, this.rotation));
    }

    public Optional<Transform<World>> loadTransform() {
        return this.loadWorld().map(x -> new Transform((Extent)x, this.position, this.rotation));
    }
}

