/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.connectionmessages.listeners;

import com.google.common.collect.ImmutableMap;
import io.github.nucleuspowered.nucleus.api.core.event.NucleusFirstJoinEvent;
import io.github.nucleuspowered.nucleus.modules.connectionmessages.config.ConnectionMessagesConfig;
import io.github.nucleuspowered.nucleus.modules.core.CoreKeys;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.services.interfaces.IStorageManager;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.channel.MessageChannel;

public class ConnectionMessagesListener
implements IReloadableService.Reloadable,
ListenerBase {
    private final IStorageManager storageManager;
    private final IPermissionService permissionService;
    private final PluginContainer pluginContainer;
    private ConnectionMessagesConfig cmc = new ConnectionMessagesConfig();

    @Inject
    public ConnectionMessagesListener(INucleusServiceCollection serviceCollection) {
        this.permissionService = serviceCollection.permissionService();
        this.storageManager = serviceCollection.storageManager();
        this.pluginContainer = serviceCollection.pluginContainer();
    }

    @Listener
    public void onPlayerLogin(ClientConnectionEvent.Join joinEvent, @Getter(value="getTargetEntity") Player pl) {
        if (joinEvent.isMessageCancelled() || this.cmc.isDisableWithPermission() && this.permissionService.hasPermission((Subject)pl, "nucleus.connectionmessages.disable")) {
            joinEvent.setMessageCancelled(true);
            return;
        }
        try {
            Optional lastKnown = this.storageManager.getUserOnThread(pl.getUniqueId()).flatMap(x -> x.get(CoreKeys.LAST_KNOWN_NAME));
            if (this.cmc.isDisplayPriorName() && !this.cmc.getPriorNameMessage().isEmpty()) {
                if (!lastKnown.orElseGet(() -> ((Player)pl).getName()).equalsIgnoreCase(pl.getName())) {
                    joinEvent.getChannel().orElse(MessageChannel.TO_ALL).send((Object)this.pluginContainer, this.cmc.getPriorNameMessage().getForCommandSource((CommandSource)pl, (Map<String, Function<CommandSource, Optional<Text>>>)ImmutableMap.of((Object)"previousname", cs -> Optional.of(Text.of((String)((String)lastKnown.get()))))));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.cmc.isModifyLoginMessage()) {
            if (this.cmc.getLoginMessage().isEmpty()) {
                joinEvent.setMessageCancelled(true);
            } else {
                joinEvent.setMessage((TextRepresentable)this.cmc.getLoginMessage().getForCommandSource((CommandSource)pl));
            }
        }
    }

    @Listener
    public void onPlayerFirstJoin(NucleusFirstJoinEvent event, @Getter(value="getTargetEntity") Player pl) {
        if (this.cmc.isShowFirstTimeMessage() && !this.cmc.getFirstTimeMessage().isEmpty()) {
            MessageChannel.TO_ALL.send((Object)this.pluginContainer, this.cmc.getFirstTimeMessage().getForCommandSource((CommandSource)pl));
        }
    }

    @Listener
    public void onPlayerQuit(ClientConnectionEvent.Disconnect leaveEvent, @Getter(value="getTargetEntity") Player pl) {
        if (leaveEvent.isMessageCancelled() || this.cmc.isDisableWithPermission() && this.permissionService.hasPermission((Subject)pl, "nucleus.connectionmessages.disable")) {
            leaveEvent.setMessageCancelled(true);
            return;
        }
        if (this.cmc.isModifyLogoutMessage()) {
            if (this.cmc.getLogoutMessage().isEmpty()) {
                leaveEvent.setMessageCancelled(true);
            } else {
                leaveEvent.setMessage((TextRepresentable)this.cmc.getLogoutMessage().getForCommandSource((CommandSource)pl));
            }
        }
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.cmc = serviceCollection.moduleDataProvider().getModuleConfig(ConnectionMessagesConfig.class);
    }
}

