/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.commands.nucleus;

import io.github.nucleuspowered.nucleus.modules.core.CoreKeys;
import io.github.nucleuspowered.nucleus.modules.core.commands.NucleusCommand;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.permission.Subject;

@Command(aliases={"resetfirstjoin"}, basePermission={"nucleus.nucleus.resetfirstjoin.base"}, commandDescriptionKey="nucleus.resetfirstjoin", parentCommand=NucleusCommand.class)
public final class ResetFirstJoinCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private boolean useSponge;

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.ONE_USER.get(serviceCollection)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        User targetUser = context.requireOne("user", User.class);
        context.getServiceCollection().storageManager().getUserService().setAndSave(targetUser.getUniqueId(), CoreKeys.FIRST_JOIN_PROCESSED, false).handle((result, exception) -> {
            if (exception == null) {
                context.sendMessage("command.nucleus.firstjoin.success", targetUser.getName());
                if (context.testPermissionFor((Subject)targetUser, "nucleus.nucleus.firstjoin.exempt")) {
                    context.sendMessage("command.nucleus.firstjoin.perm", targetUser.getName(), "nucleus.nucleus.firstjoin.exempt");
                }
                if (this.useSponge && targetUser.get(Keys.FIRST_DATE_PLAYED).isPresent()) {
                    context.sendMessage("command.nucleus.firstjoin.date", targetUser.getName());
                }
            } else {
                context.sendMessage("command.nucleus.firstjoin.error", targetUser.getName(), exception.getMessage());
                exception.printStackTrace();
            }
            return null;
        });
        return context.successResult();
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.useSponge = serviceCollection.moduleDataProvider().getModuleConfig(CoreConfig.class).isCheckFirstDatePlayed();
    }
}

