/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.data;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.module.warning.data.Warning;
import io.github.nucleuspowered.nucleus.datatypes.EndTimestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;

@ConfigSerializable
public class WarnData
extends EndTimestamp
implements Warning {
    @Setting
    private UUID warner;
    @Setting
    private String reason;
    @Setting
    private long date;
    @Setting
    private boolean expired = false;

    public WarnData() {
    }

    public WarnData(Instant date, UUID warner, String reason) {
        this(date, warner, reason, false);
    }

    public WarnData(Instant date, UUID warner, String reason, boolean expired) {
        this.warner = warner;
        this.reason = reason;
        this.expired = expired;
        this.date = date.toEpochMilli();
    }

    public WarnData(Instant date, UUID warner, String reason, Instant endtimestamp) {
        this(date, warner, reason);
        this.endtimestamp = endtimestamp.getEpochSecond();
        this.date = date.toEpochMilli();
    }

    public WarnData(Instant date, UUID warner, String reason, @Nullable Duration timeFromNextLogin) {
        this(date, warner, reason);
        this.timeFromNextLogin = timeFromNextLogin == null ? null : Long.valueOf(timeFromNextLogin.getSeconds());
        this.date = date.toEpochMilli();
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public Optional<UUID> getWarner() {
        return this.warner.equals(Util.CONSOLE_FAKE_UUID) ? Optional.empty() : Optional.of(this.warner);
    }

    @Override
    public Instant getDate() {
        return Instant.ofEpochMilli(this.date);
    }

    @Override
    public boolean isExpired() {
        return this.expired;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WarnData warnData = (WarnData)o;
        if (this.date != warnData.date) {
            return false;
        }
        if (this.expired != warnData.expired) {
            return false;
        }
        if (!this.warner.equals(warnData.warner)) {
            return false;
        }
        return this.reason.equals(warnData.reason);
    }

    public int hashCode() {
        int result = this.warner.hashCode();
        result = 31 * result + this.reason.hashCode();
        result = 31 * result + (int)(this.date ^ this.date >>> 32);
        result = 31 * result + (this.expired ? 1 : 0);
        return result;
    }
}

