/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.listeners;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.text.NucleusTextTemplate;
import io.github.nucleuspowered.nucleus.modules.core.CoreKeys;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfig;
import io.github.nucleuspowered.nucleus.modules.core.events.NucleusOnLoginEvent;
import io.github.nucleuspowered.nucleus.modules.core.events.OnFirstLoginEvent;
import io.github.nucleuspowered.nucleus.modules.core.events.UserDataLoadedEvent;
import io.github.nucleuspowered.nucleus.modules.core.services.UniqueUserService;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IUserDataObject;
import io.github.nucleuspowered.nucleus.services.impl.storage.queryobjects.IUserQueryObject;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.storage.services.IStorageService;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameStoppingServerEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.World;

public class CoreListener
implements IReloadableService.Reloadable,
ListenerBase {
    private final INucleusServiceCollection serviceCollection;
    @Nullable
    private NucleusTextTemplate getKickOnStopMessage = null;
    @Nullable
    private final URL url;
    private boolean warnOnWildcard = true;
    private boolean checkSponge = false;

    @Inject
    public CoreListener(INucleusServiceCollection serviceCollection) {
        this.serviceCollection = serviceCollection;
        URL u = null;
        try {
            u = new URL("https://ore.spongepowered.org/Nucleus/Nucleus/pages/The-Permissions-Wildcard-(And-Why-You-Shouldn't-Use-It)");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.url = u;
    }

    @Listener(order=Order.POST)
    public void onPlayerAuth(ClientConnectionEvent.Auth event) {
        UUID userId = event.getProfile().getUniqueId();
        if (userId == null) {
            return;
        }
        IUserDataObject dataObject = (IUserDataObject)this.serviceCollection.storageManager().getUserService().getOrNewOnThread(userId);
        UserDataLoadedEvent eventToFire = new UserDataLoadedEvent(event.getCause().with((Object)this.serviceCollection.pluginContainer()), dataObject, event.getProfile());
        Sponge.getEventManager().post((Event)eventToFire);
        if (eventToFire.shouldSave()) {
            this.serviceCollection.storageManager().getUserService().save(userId, dataObject);
        }
        this.serviceCollection.messageProvider().invalidateLocaleCacheFor(userId);
    }

    @Listener(order=Order.LATE)
    public void onPlayerLoginLast(ClientConnectionEvent.Login event, @Getter(value="getProfile") GameProfile profile, @Getter(value="getTargetUser") User user) {
        IUserDataObject udo = (IUserDataObject)this.serviceCollection.storageManager().getUserService().getOrNewOnThread(user.getUniqueId());
        if (event.getFromTransform().equals((Object)event.getToTransform())) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.pushCause((Object)profile);
                NucleusOnLoginEvent onLoginEvent = new NucleusOnLoginEvent(frame.getCurrentCause(), user, udo, (Transform<World>)event.getFromTransform());
                Sponge.getEventManager().post((Event)onLoginEvent);
                if (onLoginEvent.getTo().isPresent()) {
                    event.setToTransform(onLoginEvent.getTo().get());
                }
            }
        }
        this.serviceCollection.userCacheService().updateCacheForPlayer(user.getUniqueId(), udo);
    }

    @Listener(order=Order.FIRST)
    public void onPlayerJoinFirst(ClientConnectionEvent.Join event, @Getter(value="getTargetEntity") Player player) {
        try {
            IUserDataObject qsu = (IUserDataObject)this.serviceCollection.storageManager().getUserService().getOrNewOnThread(player.getUniqueId());
            qsu.set(CoreKeys.LAST_LOGIN, Instant.now());
            if (this.serviceCollection.platformService().isServer()) {
                qsu.set(CoreKeys.IP_ADDRESS, player.getConnection().getAddress().getAddress().toString());
            }
            String name = player.getName();
            Task.builder().execute(() -> qsu.set(CoreKeys.LAST_KNOWN_NAME, name)).delayTicks(20L).submit((Object)this.serviceCollection.pluginContainer());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Listener
    public void onPlayerJoinLast(ClientConnectionEvent.Join event, @Getter(value="getTargetEntity") Player player) {
        UUID uuid = player.getUniqueId();
        IStorageService.Keyed.KeyedData<UUID, IUserQueryObject, IUserDataObject> userService = this.serviceCollection.storageManager().getUserService();
        if (!userService.getOnThread(uuid).flatMap(x -> x.get(CoreKeys.FIRST_JOIN_PROCESSED)).orElse(false).booleanValue()) {
            if (!this.checkSponge || !Util.hasPlayedBeforeSponge((User)player)) {
                this.serviceCollection.getServiceUnchecked(UniqueUserService.class).resetUniqueUserCount();
                OnFirstLoginEvent firstJoinEvent = new OnFirstLoginEvent(event.getCause(), player, event.getOriginalChannel(), event.getChannel().orElse(null), event.getOriginalMessage(), event.isMessageCancelled(), event.getFormatter());
                Sponge.getEventManager().post((Event)firstJoinEvent);
                event.setChannel((MessageChannel)firstJoinEvent.getChannel().get());
                event.setMessageCancelled(firstJoinEvent.isMessageCancelled());
            }
            userService.getOrNew(player.getUniqueId()).thenAccept(x -> {
                x.set(CoreKeys.FIRST_JOIN, x.get(CoreKeys.LAST_LOGIN).orElseGet(Instant::now));
                x.set(CoreKeys.FIRST_JOIN_PROCESSED, true);
            });
        }
        if (!this.serviceCollection.permissionService().isOpOnly() && player.hasPermission("nucleus")) {
            IMessageProviderService provider = this.serviceCollection.messageProvider();
            this.serviceCollection.logger().warn("The player " + player.getName() + " has got either the nucleus wildcard or the * wildcard permission. This may cause unintended side effects.");
            if (this.warnOnWildcard) {
                ArrayList text = Lists.newArrayList();
                text.add(provider.getMessageFor((CommandSource)player, "core.permission.wildcard2"));
                text.add(provider.getMessageFor((CommandSource)player, "core.permission.wildcard3"));
                if (this.url != null) {
                    text.add(provider.getMessageFor((CommandSource)player, "core.permission.wildcard4").toBuilder().onClick((ClickAction)TextActions.openUrl((URL)this.url)).build());
                }
                text.add(provider.getMessageFor((CommandSource)player, "core.permission.wildcard5"));
                ((PaginationService)Sponge.getServiceManager().provideUnchecked(PaginationService.class)).builder().title(provider.getMessageFor((CommandSource)player, "core.permission.wildcard")).contents((Iterable)text).padding(Text.of((Object[])new Object[]{TextColors.GOLD, "-"})).sendTo((MessageReceiver)player);
            }
        }
    }

    @Listener(order=Order.LAST)
    public void onPlayerQuit(ClientConnectionEvent.Disconnect event, @Getter(value="getTargetEntity") Player player) {
        if (player.getConnection() == null || player.getConnection().getAddress() == null) {
            return;
        }
        this.serviceCollection.storageManager().getUser(player.getUniqueId()).thenAccept(x -> x.ifPresent(y -> this.onPlayerQuit(player, (IUserDataObject)y)));
    }

    private void onPlayerQuit(Player player, IUserDataObject udo) {
        InetAddress address = player.getConnection().getAddress().getAddress();
        try {
            udo.set(CoreKeys.IP_ADDRESS, address.toString());
            this.serviceCollection.userCacheService().updateCacheForPlayer(player.getUniqueId(), udo);
            this.serviceCollection.storageManager().getUserService().save(player.getUniqueId(), udo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        CoreConfig c = this.serviceCollection.moduleDataProvider().getModuleConfig(CoreConfig.class);
        this.getKickOnStopMessage = c.isKickOnStop() ? c.getKickOnStopMessage() : null;
        this.warnOnWildcard = c.isCheckForWildcard();
        this.checkSponge = c.isCheckFirstDatePlayed();
    }

    @Listener
    public void onServerAboutToStop(GameStoppingServerEvent event) {
        for (Player player : Sponge.getServer().getOnlinePlayers()) {
            this.serviceCollection.storageManager().getUserOnThread(player.getUniqueId()).ifPresent(x -> this.onPlayerQuit(player, (IUserDataObject)x));
        }
        if (this.getKickOnStopMessage != null) {
            for (Player p : Sponge.getServer().getOnlinePlayers()) {
                Text msg = this.getKickOnStopMessage.getForCommandSource((CommandSource)p);
                if (msg.isEmpty()) {
                    p.kick();
                    continue;
                }
                p.kick(msg);
            }
        }
    }

    @Listener
    public void onGameReload(GameReloadEvent event) {
        CommandSource requester = (CommandSource)event.getCause().first(CommandSource.class).orElse(Sponge.getServer().getConsole());
        IMessageProviderService messageProviderService = this.serviceCollection.messageProvider();
        try {
            this.serviceCollection.reloadableService().fireReloadables(this.serviceCollection);
            requester.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, "[Nucleus] ", messageProviderService.getMessageFor(requester, "command.reload.one")}));
            requester.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, "[Nucleus] ", messageProviderService.getMessageFor(requester, "command.reload.two")}));
        }
        catch (Exception e) {
            e.printStackTrace();
            requester.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "[Nucleus] ", messageProviderService.getMessageFor(requester, "command.reload.errorone")}));
        }
    }
}

