/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.environment.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.storage.WorldProperties;

@NonnullByDefault
@EssentialsEquivalent(value={"time"}, isExact=false, notes="This just displays the time. Use '/time set' to set the time.")
@Command(aliases={"time"}, basePermission={"nucleus.time.base"}, commandDescriptionKey="time", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.time.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.time.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.time.exempt.cost")})
public class TimeCommand
implements ICommandExecutor<CommandSource> {
    private final String world = "world";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.optionalWeak((CommandElement)GenericArguments.onlyOne((CommandElement)GenericArguments.world((Text)Text.of((String)this.world))))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) {
        WorldProperties pr = context.getWorldPropertiesOrFromSelf(this.world).orElseGet(() -> (WorldProperties)Sponge.getServer().getDefaultWorld().get());
        context.sendMessage("command.time", pr.getWorldName(), Util.getTimeFromTicks(context.getServiceCollection().messageProvider(), pr.getWorldTime()));
        return context.successResult();
    }
}

