/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.ignore.commands;

import io.github.nucleuspowered.nucleus.modules.ignore.services.IgnoreService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@EssentialsEquivalent(value={"ignore"})
@NonnullByDefault
@Command(aliases={"ignore"}, basePermission={"nucleus.ignore.base"}, commandDescriptionKey="ignore", async=true, associatedPermissions={"nucleus.ignore.exempt.chat"})
public class IgnoreCommand
implements ICommandExecutor<Player> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.ONE_USER.get(serviceCollection), NucleusParameters.OPTIONAL_ONE_TRUE_FALSE};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        User target = context.requireOne("user", User.class);
        Player player = context.getIfPlayer();
        if (context.is(target)) {
            return context.errorResult("command.ignore.self", new Object[0]);
        }
        IgnoreService ignoreService = context.getServiceCollection().getServiceUnchecked(IgnoreService.class);
        if (context.testPermissionFor((Subject)target, "exempt.chat")) {
            ignoreService.unignore(player.getUniqueId(), target.getUniqueId());
            return context.errorResult("command.ignore.exempt", target.getName());
        }
        boolean ignore = context.getOne("true|false", Boolean.class).orElseGet(() -> !ignoreService.isIgnored(player.getUniqueId(), target.getUniqueId()));
        if (ignore) {
            ignoreService.ignore(player.getUniqueId(), target.getUniqueId());
            context.sendMessage("command.ignore.added", target.getName());
        } else {
            ignoreService.unignore(player.getUniqueId(), target.getUniqueId());
            context.sendMessage("command.ignore.remove", target.getName());
        }
        return context.successResult();
    }
}

