/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.invulnerability.listeners;

import io.github.nucleuspowered.nucleus.modules.invulnerability.config.InvulnerabilityConfig;
import io.github.nucleuspowered.nucleus.modules.invulnerability.services.InvulnerabilityService;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import javax.inject.Inject;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.cause.entity.damage.source.EntityDamageSource;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.service.permission.Subject;

public class InvulnerabilityPvpListener
implements ListenerBase.Conditional {
    private final InvulnerabilityService service;
    private final IPermissionService permissionService;

    @Inject
    public InvulnerabilityPvpListener(INucleusServiceCollection serviceCollection) {
        this.service = serviceCollection.getServiceUnchecked(InvulnerabilityService.class);
        this.permissionService = serviceCollection.permissionService();
    }

    @Listener
    public void onAttack(AttackEntityEvent event, @Root EntityDamageSource source, @Getter(value="getTargetEntity") Entity entity) {
        Player player;
        if (source.getSource() instanceof Player && this.service.isInvulnerable((User)(player = (Player)source.getSource())) && !this.permissionService.hasPermission((Subject)player, "nucleus.god.pvp.override") && entity instanceof Player) {
            event.setCancelled(true);
        }
    }

    @Override
    public boolean shouldEnable(INucleusServiceCollection serviceCollection) {
        return serviceCollection.moduleDataProvider().getModuleConfig(InvulnerabilityConfig.class).isDisablePvpOnGod();
    }
}

