/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.spawn.commands;

import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportResult;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportScanners;
import io.github.nucleuspowered.nucleus.configurate.datatypes.LocationNode;
import io.github.nucleuspowered.nucleus.modules.spawn.SpawnKeys;
import io.github.nucleuspowered.nucleus.modules.spawn.config.SpawnConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IGeneralDataObject;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.World;

@NonnullByDefault
@Command(aliases={"firstspawn"}, basePermission={"nucleus.firstspawn.base"}, commandDescriptionKey="firstspawn", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.firstspawn.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.firstspawn.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.firstspawn.exempt.cost")})
public class FirstSpawnCommand
implements ICommandExecutor<Player>,
IReloadableService.Reloadable {
    private boolean isSafeTeleport = true;

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        Optional olwr = ((IGeneralDataObject)context.getServiceCollection().storageManager().getGeneralService().getOrNewOnThread()).get(SpawnKeys.FIRST_SPAWN_LOCATION).flatMap(LocationNode::getTransformIfExists);
        if (!olwr.isPresent()) {
            return context.errorResult("command.firstspawn.notset", new Object[0]);
        }
        TeleportResult result = context.getServiceCollection().teleportService().teleportPlayerSmart(context.getIfPlayer(), (Transform<World>)((Transform)olwr.get()), true, this.isSafeTeleport, TeleportScanners.NO_SCAN.get());
        if (result.isSuccessful()) {
            context.sendMessage("command.firstspawn.success", new Object[0]);
            return context.successResult();
        }
        return context.errorResult("command.firstspawn.fail", new Object[0]);
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.isSafeTeleport = serviceCollection.moduleDataProvider().getModuleConfig(SpawnConfig.class).isSafeTeleport();
    }
}

