/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.spawn.commands;

import com.flowpowered.math.vector.Vector3d;
import io.github.nucleuspowered.nucleus.modules.spawn.SpawnKeys;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@EssentialsEquivalent(value={"setspawn"})
@Command(aliases={"setspawn"}, basePermission={"nucleus.setspawn.base"}, commandDescriptionKey="setspawn")
public class SetSpawnCommand
implements ICommandExecutor<Player> {
    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        Player src = context.getIfPlayer();
        Vector3d rotation = src.getRotation();
        context.getServiceCollection().storageManager().getWorldService().getOrNew(src.getWorld().getUniqueId()).thenAccept(x -> x.set(SpawnKeys.WORLD_SPAWN_ROTATION, rotation));
        src.getWorld().getProperties().setSpawnPosition(src.getLocation().getBlockPosition());
        context.sendMessage("command.setspawn.success", src.getWorld().getName());
        return context.successResult();
    }
}

