/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.standard;

import com.google.common.collect.ImmutableMap;
import io.github.nucleuspowered.nucleus.api.module.kit.data.Kit;
import io.github.nucleuspowered.nucleus.modules.kit.serialiser.SingleKitTypeSerilaiser;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.configurate.AbstractConfigurateBackedDataObject;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.standard.IKitDataObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;

public class KitDataObject
extends AbstractConfigurateBackedDataObject
implements IKitDataObject {
    private Map<String, Kit> cached;

    @Override
    public Map<String, Kit> getKitMap() {
        if (this.cached == null) {
            try {
                Map<String, Kit> map = SingleKitTypeSerilaiser.INSTANCE.deserialize(this.backingNode);
                this.cached = map == null ? Collections.emptyMap() : Collections.unmodifiableMap(map);
            }
            catch (Exception e) {
                e.printStackTrace();
                return Collections.emptyMap();
            }
        }
        return this.cached;
    }

    @Override
    public void setKitMap(Map<String, Kit> map) throws Exception {
        ConfigurationNode node = this.backingNode.getNode(new Object[]{"kits"});
        this.backingNode.setValue(null);
        SingleKitTypeSerilaiser.INSTANCE.serialize(map, this.backingNode);
        if (!node.isVirtual()) {
            this.backingNode.getNode(new Object[]{"kits"}).setValue((Object)node);
        }
        this.cached = ImmutableMap.copyOf(map);
    }

    @Override
    public boolean hasKit(String name) {
        return this.getKitMap().containsKey(name.toLowerCase());
    }

    @Override
    public Optional<Kit> getKit(String name) {
        return Optional.ofNullable(this.getKitMap().get(name.toLowerCase()));
    }

    @Override
    public void setKit(Kit kit) throws Exception {
        HashMap<String, Kit> m = new HashMap<String, Kit>(this.getKitMap());
        m.put(kit.getName().toLowerCase(), kit);
        this.setKitMap(m);
    }

    @Override
    public boolean removeKit(String name) throws Exception {
        HashMap<String, Kit> m = new HashMap<String, Kit>(this.getKitMap());
        boolean b = m.remove(name.toLowerCase()) != null;
        this.setKitMap(m);
        return b;
    }

    @Override
    public void setBackingNode(ConfigurationNode node) {
        super.setBackingNode(node);
        this.cached = null;
    }
}

