/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.interfaces;

import com.google.inject.ImplementedBy;
import io.github.nucleuspowered.nucleus.api.util.NoExceptionAutoClosable;
import io.github.nucleuspowered.nucleus.services.impl.permission.NucleusPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.annotation.PermissionMetadata;
import io.github.nucleuspowered.nucleus.services.interfaces.data.SuggestedLevel;
import io.github.nucleuspowered.nucleus.util.PermissionMessageChannel;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.UUID;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.service.ProviderRegistration;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.context.ContextCalculator;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.util.Tristate;

@ImplementedBy(value=NucleusPermissionService.class)
public interface IPermissionService {
    public void assignUserRoleToDefault();

    public void assignRoleToGroup(SuggestedLevel var1, Subject var2);

    public boolean isOpOnly();

    public void registerContextCalculator(ContextCalculator<Subject> var1);

    public void checkServiceChange(ProviderRegistration<PermissionService> var1);

    public boolean hasPermission(Subject var1, String var2);

    public Tristate hasPermissionTristate(Subject var1, String var2);

    public boolean hasPermissionWithConsoleOverride(Subject var1, String var2, boolean var3);

    public boolean isConsoleOverride(Subject var1);

    public void registerDescriptions();

    public void register(String var1, PermissionMetadata var2, String var3);

    public CommandElement createOtherUserPermissionElement(String var1);

    public OptionalDouble getDoubleOptionFromSubject(Subject var1, String ... var2);

    public OptionalLong getPositiveLongOptionFromSubject(Subject var1, String ... var2);

    public OptionalInt getPositiveIntOptionFromSubject(Subject var1, String ... var2);

    public OptionalInt getIntOptionFromSubject(Subject var1, String ... var2);

    public Optional<String> getOptionFromSubject(Subject var1, String ... var2);

    public PermissionMessageChannel permissionMessageChannel(String var1);

    public List<Metadata> getAllMetadata();

    public Optional<Metadata> getMetadataFor(String var1);

    default public OptionalInt getDeclaredLevel(Subject subject, String key) {
        return this.getIntOptionFromSubject(subject, key);
    }

    public boolean isPermissionLevelOkay(Subject var1, Subject var2, String var3, String var4, boolean var5);

    public void setContext(Subject var1, Context var2);

    public NoExceptionAutoClosable setContextTemporarily(Subject var1, Context var2);

    public void removeContext(UUID var1, String var2);

    public void removePlayerContexts(UUID var1);

    public static interface Metadata {
        public boolean isPrefix();

        public SuggestedLevel getSuggestedLevel();

        public String getDescription(IMessageProviderService var1);

        public String getPermission();

        public String getModuleId();
    }
}

