/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.command;

import com.universeguard.region.LocalRegion;
import com.universeguard.region.Region;
import com.universeguard.region.enums.RegionPermission;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.RegionUtils;
import java.util.UUID;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.format.TextColors;

public class RegionRemoveExecutor
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (args.hasAny("name")) {
            String username = (String)args.getOne("name").get();
            UUID member = RegionUtils.getPlayerUUID(username);
            if (member != null && RegionUtils.hasRegionByUUID(member)) {
                Region region = null;
                LocalRegion localRegion = null;
                if (RegionUtils.hasPendingRegion(src)) {
                    region = RegionUtils.getPendingRegion(src);
                } else if (args.hasAny("region")) {
                    region = RegionUtils.load((String)args.getOne("region").get());
                } else {
                    MessageUtils.sendErrorMessage(src, this.getCommandUsage());
                }
                if (region != null) {
                    if (region.isLocal()) {
                        localRegion = (LocalRegion)region;
                        if (RegionUtils.isMemberByUUID(localRegion, member)) {
                            if (src.hasPermission(RegionPermission.REGION.getValue()) || src instanceof Player && localRegion.getOwner().getUUID().equals(((Player)src).getUniqueId())) {
                                localRegion.removeMemberByUUID(member);
                                if (localRegion.getMembers().size() == 0) {
                                    localRegion.setSold(false);
                                }
                                if (RegionUtils.save(localRegion)) {
                                    Player onlinePlayer;
                                    MessageUtils.sendSuccessMessage(src, RegionText.PLAYER_REMOVED_FROM_REGION.getValue() + ": " + username);
                                    if (RegionUtils.isOnline(member) && (onlinePlayer = RegionUtils.getPlayer(member)) != null) {
                                        MessageUtils.sendMessage(onlinePlayer, RegionText.REMOVED_FROM_REGION.getValue() + ": " + region.getName(), TextColors.GOLD);
                                    }
                                } else {
                                    MessageUtils.sendErrorMessage(src, RegionText.REGION_REMOVE_MEMBER_EXCEPTION.getValue());
                                }
                            } else {
                                MessageUtils.sendErrorMessage(src, RegionText.NO_PERMISSION_COMMAND.getValue());
                            }
                        } else {
                            MessageUtils.sendErrorMessage(src, RegionText.PLAYER_NO_REGION.getValue());
                        }
                    } else {
                        MessageUtils.sendErrorMessage(src, RegionText.REGION_LOCAL_ONLY.getValue());
                    }
                } else {
                    MessageUtils.sendErrorMessage(src, RegionText.REGION_NOT_FOUND.getValue());
                }
            } else {
                MessageUtils.sendErrorMessage(src, RegionText.PLAYER_NO_REGION.getValue());
            }
        } else {
            MessageUtils.sendErrorMessage(src, this.getCommandUsage());
        }
        return CommandResult.empty();
    }

    private String getCommandUsage() {
        return "/rg remove <player> (region)";
    }
}

