/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.network.messages.magicavoxel;

import io.netty.buffer.ByteBuf;
import lumien.randomthings.handler.magicavoxel.ClientModelLibrary;
import lumien.randomthings.network.IRTMessage;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageModelData
implements IRTMessage {
    String modelName;
    int dataAmount;
    byte[] data;

    public MessageModelData() {
    }

    public MessageModelData(String modelName, int dataAmount, byte[] data) {
        this.modelName = modelName;
        this.dataAmount = dataAmount;
        this.data = data;
    }

    public void fromBytes(ByteBuf buf) {
        this.modelName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.dataAmount = buf.readInt();
        this.data = new byte[this.dataAmount];
        buf.readBytes(this.data);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.modelName);
        buf.writeInt(this.dataAmount);
        buf.writeBytes(this.data);
    }

    @Override
    public void onMessage(MessageContext context) {
        Minecraft.func_71410_x().func_152344_a(new Runnable(){

            @Override
            public void run() {
                ClientModelLibrary.getInstance().addModelData(MessageModelData.this.modelName, MessageModelData.this.data);
            }
        });
    }

    @Override
    public Side getHandlingSide() {
        return Side.CLIENT;
    }
}

