/*
 * Decompiled with CFR 0.152.
 */
package com.carrot.carrotshop.shop;

import com.carrot.carrotshop.CarrotShop;
import com.carrot.carrotshop.Lang;
import com.carrot.carrotshop.ShopsData;
import com.carrot.carrotshop.ShopsLogs;
import com.carrot.carrotshop.shop.Shop;
import java.util.Optional;
import java.util.Stack;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.block.tileentity.carrier.TileEntityCarrier;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.item.inventory.type.InventoryRow;
import org.spongepowered.api.item.inventory.type.TileEntityInventory;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@ConfigSerializable
public class iTrade
extends Shop {
    @Setting
    private Inventory toGive;
    @Setting
    private Inventory toTake;
    private static String type = "iTrade";

    public iTrade() {
    }

    public iTrade(Player player, Location<World> sign) throws ExceptionInInitializerError {
        super(sign);
        if (!player.hasPermission("carrotshop.admin.itrade")) {
            throw new ExceptionInInitializerError(Lang.SHOP_PERM.replace("%type%", type));
        }
        Stack<Location<World>> locations = ShopsData.getItemLocations(player);
        if (locations.size() < 2) {
            throw new ExceptionInInitializerError(Lang.SHOP_CHEST2.replace("%type%", type));
        }
        Optional chestTakeOpt = ((Location)locations.get(0)).getTileEntity();
        Optional chestGiveOpt = ((Location)locations.get(1)).getTileEntity();
        if (!(chestTakeOpt.isPresent() && chestGiveOpt.isPresent() && chestTakeOpt.get() instanceof TileEntityCarrier && chestGiveOpt.get() instanceof TileEntityCarrier)) {
            throw new ExceptionInInitializerError(Lang.SHOP_CHEST2.replace("%type%", type));
        }
        TileEntityInventory chestTake = ((TileEntityCarrier)chestTakeOpt.get()).getInventory();
        TileEntityInventory chestGive = ((TileEntityCarrier)chestGiveOpt.get()).getInventory();
        if (chestTake.totalItems() == 0 || chestGive.totalItems() == 0) {
            throw new ExceptionInInitializerError(Lang.SHOP_CHEST_EMPTY);
        }
        this.toTake = ((Inventory.Builder)Inventory.builder().from((Object)chestTake)).build((Object)CarrotShop.getInstance());
        this.toGive = ((Inventory.Builder)Inventory.builder().from((Object)chestGive)).build((Object)CarrotShop.getInstance());
        for (Inventory item : chestGive.slots()) {
            if (!item.peek().isPresent()) continue;
            this.toGive.offer((ItemStack)item.peek().get());
        }
        for (Inventory item : chestTake.slots()) {
            if (!item.peek().isPresent()) continue;
            this.toTake.offer((ItemStack)item.peek().get());
        }
        ShopsData.clearItemLocations(player);
        player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, Lang.SHOP_DONE.replace("%type%", type)}));
        this.done(player);
        this.info(player);
    }

    @Override
    public void info(Player player) {
        Text.Builder builder = Text.builder();
        builder.append(new Text[]{Text.of((String)Lang.split(Lang.SHOP_FORMAT_TRADE, "%items%", 0))});
        builder.append(new Text[]{iTrade.formatInventoryNames(this.toTake)});
        builder.append(new Text[]{Text.of((String)Lang.split(Lang.SHOP_FORMAT_TRADE, "%items%", 1))});
        builder.append(new Text[]{iTrade.formatInventoryNames(this.toGive)});
        builder.append(new Text[]{Text.of((String)Lang.split(Lang.SHOP_FORMAT_TRADE, "%items%", 2))});
        player.sendMessage(builder.build());
        this.update();
    }

    @Override
    public boolean trigger(Player player) {
        Inventory inv = player.getInventory().query(new QueryOperation[]{QueryOperationTypes.INVENTORY_TYPE.of(InventoryRow.class)});
        if (!iTrade.hasEnough(inv, this.toTake)) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, Lang.SHOP_ITEMS}));
            return false;
        }
        for (Inventory item : this.toTake.slots()) {
            Optional<ItemStack> template;
            if (!item.peek().isPresent() || !(template = iTrade.getTemplate(inv, (ItemStack)item.peek().get())).isPresent()) continue;
            inv.query(new QueryOperation[]{QueryOperationTypes.ITEM_STACK_IGNORE_QUANTITY.of((Object)template.get())}).poll(((ItemStack)item.peek().get()).getQuantity());
        }
        for (Inventory item : this.toGive.slots()) {
            if (!item.peek().isPresent()) continue;
            inv.offer(((ItemStack)item.peek().get()).copy()).getRejectedItems().forEach(action -> iTrade.putItemInWorld(action, (Location<World>)player.getLocation()));
        }
        ShopsLogs.log(this.getOwner(), player, "trade", super.getLocation(), Optional.empty(), Optional.empty(), Optional.of(this.toGive), Optional.of(this.toTake));
        player.sendMessage(Text.of((Object[])new Object[]{Lang.split(Lang.SHOP_RECAP_TRADE, "%items%", 0), iTrade.formatInventoryNames(this.toTake), Lang.split(Lang.SHOP_RECAP_TRADE, "%items%", 1), iTrade.formatInventoryNames(this.toGive), Lang.split(Lang.SHOP_RECAP_TRADE, "%items%", 2)}));
        return true;
    }

    @Override
    public boolean canLoopCurrency(Player src) {
        return false;
    }
}

