/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import wile.rsgauges.blocks.BlockSwitch;
import wile.rsgauges.detail.ModAuxiliaries;
import wile.rsgauges.detail.ModResources;

public class BlockContactSwitch
extends BlockSwitch {
    public BlockContactSwitch(String registryName, AxisAlignedBB unrotatedBBUnpowered, AxisAlignedBB unrotatedBBPowered, long config, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound, @Nullable Material material) {
        super(registryName, unrotatedBBUnpowered, unrotatedBBPowered, config | 0x40000000L, powerOnSound, powerOffSound, material);
    }

    public BlockContactSwitch(String registryName, AxisAlignedBB unrotatedBBUnpowered, AxisAlignedBB unrotatedBBPowered, long config, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        this(registryName, unrotatedBBUnpowered, unrotatedBBPowered, config | 0x40000000L, powerOnSound, powerOffSound, null);
    }

    @Override
    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return side == null || side == EnumFacing.UP && !this.isWallMount() || side == ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d();
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float distance) {
        if ((this.config & 0x400000000000L) != 0L) {
            this.onEntityCollided(world, pos, world.func_180495_p(pos), entity, new AxisAlignedBB(pos, pos.func_177982_a(1, 2, 1)));
        }
        super.func_180658_a(world, pos, entity, distance);
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        if ((this.config & 0xC00000000000L) == 0xC00000000000L && !entity.func_70093_af()) {
            this.onEntityCollided(world, pos, world.func_180495_p(pos), entity, new AxisAlignedBB(pos, pos.func_177982_a(1, 2, 1)));
        }
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (world.field_72995_K || state == null) {
            return;
        }
        if ((this.config & 0x400000000000L) != 0L && (double)entity.field_70143_R < 0.2) {
            return;
        }
        this.onEntityCollided(world, pos, state, entity, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)));
    }

    protected void onEntityCollided(World world, BlockPos pos, IBlockState state, Entity entity, AxisAlignedBB detectionVolume) {
        if (world.field_72995_K) {
            return;
        }
        TileEntityContactSwitch te = this.getTe((IBlockAccess)world, pos);
        if (te == null) {
            return;
        }
        boolean active = false;
        boolean powered = (Boolean)state.func_177229_b((IProperty)POWERED);
        if (powered && te.on_time_remaining() > 3 && (world.func_82737_E() & 3L) != 0L) {
            active = true;
        } else {
            List hits = world.func_72872_a(te.filter_class(), detectionVolume);
            if (hits.size() >= te.entity_count_threshold()) {
                if (te.high_sensitivity()) {
                    active = true;
                } else {
                    for (Entity e : hits) {
                        if (e.func_145773_az()) continue;
                        active = true;
                        break;
                    }
                }
            }
        }
        if (active) {
            int t = te.configured_on_time();
            te.on_timer_reset(t == 0 ? 20 : (t < 4 ? 4 : t));
        }
        if (active && !powered) {
            state = state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true));
            world.func_180501_a(pos, state, 3);
            this.power_on_sound.play(world, pos);
            this.notifyNeighbours(world, pos, state, te, false);
            if ((this.config & 0x100000000000000L) != 0L && !te.activate_links(1)) {
                ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(world, pos);
            }
        }
        te.reschedule_block_tick();
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityContactSwitch();
    }

    @Override
    public TileEntityContactSwitch getTe(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileEntityContactSwitch)) {
            return null;
        }
        return (TileEntityContactSwitch)te;
    }

    public static class TileEntityContactSwitch
    extends BlockSwitch.TileEntitySwitch {
        public static final Class<?>[] filter_classes = new Class[]{Entity.class, EntityLivingBase.class, EntityPlayer.class, EntityMob.class, EntityAnimal.class, EntityVillager.class, EntityItem.class};
        public static final String[] filter_class_names = new String[]{"everything", "creatures", "players", "mobs", "animals", "villagers", "objects"};
        private static final int max_entity_count = 64;
        private boolean high_sensitivity_ = false;
        private int count_threshold_ = 1;
        private int filter_ = 0;

        public int filter() {
            return this.filter_;
        }

        public void filter(int sel) {
            this.filter_ = sel < 0 ? 0 : (sel >= filter_classes.length ? filter_classes.length - 1 : sel);
        }

        public Class<?> filter_class() {
            return this.filter_ <= 0 ? filter_classes[0] : (this.filter_ >= filter_classes.length ? filter_classes[filter_classes.length - 1] : filter_classes[this.filter_]);
        }

        public boolean high_sensitivity() {
            return this.high_sensitivity_;
        }

        public void high_sensitivity(boolean sel) {
            this.high_sensitivity_ = sel;
        }

        public int entity_count_threshold() {
            return this.count_threshold_;
        }

        public void entity_count_threshold(int sel) {
            this.count_threshold_ = sel < 1 ? 1 : (sel >= 64 ? 64 : sel);
        }

        @Override
        public void writeNbt(NBTTagCompound nbt, boolean updatePacket) {
            super.writeNbt(nbt, updatePacket);
            nbt.func_74768_a("filter", this.filter());
            nbt.func_74757_a("highsensitive", this.high_sensitivity());
            nbt.func_74768_a("entitythreshold", this.entity_count_threshold());
        }

        @Override
        public void readNbt(NBTTagCompound nbt, boolean updatePacket) {
            super.readNbt(nbt, updatePacket);
            this.filter(nbt.func_74762_e("filter"));
            this.high_sensitivity(nbt.func_74767_n("highsensitive"));
            this.entity_count_threshold(nbt.func_74762_e("entitythreshold"));
        }

        @Override
        public void reset() {
            super.reset();
            this.filter_ = 0;
            this.count_threshold_ = 1;
            this.high_sensitivity_ = false;
        }

        @Override
        public boolean activation_config(IBlockState state, @Nullable EntityPlayer player, double x, double y) {
            if (state == null) {
                return false;
            }
            BlockSwitch block = (BlockSwitch)state.func_177230_c();
            int direction = 0;
            int field = 0;
            if ((block.config & 0x20000000000L) != 0L) {
                int n = y >= 13.0 && y <= 15.0 ? 1 : (direction = y >= 10.0 && y <= 12.0 ? -1 : 0);
                int n2 = x >= 9.5 && x <= 10.1 ? 1 : (x >= 10.9 && x <= 11.7 ? 2 : (x >= 12.2 && x <= 13.0 ? 3 : (field = x >= 13.5 && x <= 14.2 ? 4 : 0)));
            }
            if (direction == 0 || field == 0) {
                return false;
            }
            switch (field) {
                case 1: {
                    this.high_sensitivity(direction > 0);
                    ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchconfig.touchcontactmat.sensitivity", TextFormatting.BLUE, ModAuxiliaries.localizable("switchconfig.touchcontactmat.sensitivity." + (this.high_sensitivity() ? "high" : "normal"), null, new Object[0])));
                    break;
                }
                case 2: {
                    this.entity_count_threshold(this.entity_count_threshold() + direction);
                    ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchconfig.touchcontactmat.entity_threshold", TextFormatting.YELLOW, this.entity_count_threshold()));
                    break;
                }
                case 3: {
                    this.filter(this.filter() + direction);
                    ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchconfig.touchcontactmat.entity_filter", TextFormatting.DARK_GREEN, new TextComponentTranslation("rsgauges.switchconfig.touchcontactmat.entity_filter." + filter_class_names[this.filter_], new Object[0])));
                    break;
                }
                case 4: {
                    this.on_power(this.on_power() + direction);
                    if (this.on_power() < 1) {
                        this.on_power(1);
                    }
                    ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchconfig.touchcontactmat.output_power", TextFormatting.RED, this.on_power()));
                }
            }
            this.func_70296_d();
            return true;
        }
    }
}

