/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import wile.rsgauges.blocks.BlockContactSwitch;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.items.ItemSwitchLinkPearl;

public class BlockTrapdoorSwitch
extends BlockContactSwitch {
    public BlockTrapdoorSwitch(String registryName, AxisAlignedBB unrotatedBBUnpowered, AxisAlignedBB unrotatedBBPowered, long config, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound, @Nullable Material material) {
        super(registryName, unrotatedBBUnpowered, unrotatedBBPowered, config, powerOnSound, powerOffSound, material);
    }

    public BlockTrapdoorSwitch(String registryName, AxisAlignedBB unrotatedBBUnpowered, AxisAlignedBB unrotatedBBPowered, long config, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(registryName, unrotatedBBUnpowered, unrotatedBBPowered, config, powerOnSound, powerOffSound, null);
    }

    @Override
    public boolean onLinkRequest(ItemSwitchLinkPearl.SwitchLink link, long req, World world, BlockPos pos, @Nullable EntityPlayer player) {
        if (world.field_72995_K || (this.config & 0x200000000000000L) == 0L) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state == null || !(state.func_177230_c() instanceof BlockTrapdoorSwitch)) {
            return false;
        }
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return true;
        }
        BlockContactSwitch.TileEntityContactSwitch te = this.getTe((IBlockAccess)world, pos);
        if (te == null || !te.check_link_request(link)) {
            return false;
        }
        world.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        this.power_on_sound.play(world, pos);
        this.notifyNeighbours(world, pos, state, te, false);
        te.on_timer_reset(te.configured_on_time() == 0 ? 20 : (te.configured_on_time() < 2 ? 2 : te.configured_on_time()));
        te.reschedule_block_tick();
        return true;
    }

    @Override
    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state != null && state.func_177230_c() == this && (Boolean)state.func_177229_b((IProperty)POWERED) != false;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP && state != null && state.func_177230_c() == this && (Boolean)state.func_177229_b((IProperty)POWERED) == false ? BlockFaceShape.SOLID : super.func_193383_a(world, state, pos, face);
    }

    @Override
    public void func_180658_a(World world, BlockPos pos, Entity entity, float distance) {
        if ((this.config & 0x400000000000L) != 0L) {
            BlockPos[] neighbors;
            if (world.field_72995_K) {
                return;
            }
            this.onEntityCollided(world, pos, world.func_180495_p(pos), entity, new AxisAlignedBB(pos.func_177963_a(-1.2, 0.0, -1.2), pos.func_177963_a(1.2, 2.0, 1.2)));
            for (BlockPos p : neighbors = new BlockPos[]{pos.func_177982_a(1, 0, 0), pos.func_177982_a(-1, 0, 0), pos.func_177982_a(0, 0, 1), pos.func_177982_a(0, 0, -1), pos.func_177982_a(1, 0, 1), pos.func_177982_a(-1, 0, -1), pos.func_177982_a(-1, 0, 1), pos.func_177982_a(1, 0, -1)}) {
                IBlockState st = world.func_180495_p(p);
                if (st == null || st.func_177230_c() != this) continue;
                this.onEntityCollided(world, p, st, entity, new AxisAlignedBB(p.func_177963_a(-1.2, 0.0, -1.2), p.func_177963_a(1.2, 2.0, 1.2)));
            }
        }
        super.func_180658_a(world, pos, entity, distance);
    }

    @Override
    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        BlockPos[] neighbors;
        if ((this.config & 0x800000000000L) == 0L || world.field_72995_K || entity.func_70093_af()) {
            return;
        }
        this.onEntityCollided(world, pos, world.func_180495_p(pos), entity, new AxisAlignedBB(pos.func_177963_a(-1.2, 0.0, -1.2), pos.func_177963_a(1.2, 2.0, 1.2)));
        for (BlockPos p : neighbors = new BlockPos[]{pos.func_177982_a(1, 0, 0), pos.func_177982_a(-1, 0, 0), pos.func_177982_a(0, 0, 1), pos.func_177982_a(0, 0, -1), pos.func_177982_a(1, 0, 1), pos.func_177982_a(-1, 0, -1), pos.func_177982_a(-1, 0, 1), pos.func_177982_a(1, 0, -1)}) {
            IBlockState st = world.func_180495_p(p);
            if (st == null || st.func_177230_c() != this) continue;
            this.onEntityCollided(world, p, st, entity, new AxisAlignedBB(p.func_177963_a(-1.2, 0.0, -1.2), p.func_177963_a(1.2, 2.0, 1.2)));
        }
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if ((this.config & 0x400000000000L) != 0L && (double)entity.field_70131_O < 0.9) {
            return;
        }
        this.onEntityCollided(world, pos, state, entity, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)));
    }
}

