/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.worldstripper.common.network.packets;

import com.ewyboy.worldstripper.common.network.PacketHandler;
import com.ewyboy.worldstripper.common.util.Config;
import com.google.common.base.Stopwatch;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketStripWorld
implements IMessage {
    public void fromBytes(ByteBuf buf) {
    }

    public void toBytes(ByteBuf buf) {
    }

    public static class Handler
    implements IMessageHandler<PacketStripWorld, IMessage> {
        public IMessage onMessage(PacketStripWorld message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(ctx));
            return null;
        }

        private void handle(MessageContext ctx) {
            EntityPlayerMP player;
            Stopwatch watch;
            block10: {
                block7: {
                    watch = Stopwatch.createStarted();
                    player = ctx.getServerHandler().field_147369_b;
                    World world = player.field_70170_p;
                    int profile = Config.profile;
                    double chunkClearSizeX = 16 * Config.chuckRadiusX / 2;
                    double chunkClearSizeZ = 16 * Config.chuckRadiusZ / 2;
                    boolean hasMeta = Arrays.stream((Object[])Config.profileMap.get(profile)).anyMatch(p -> p.contains("["));
                    if (!player.func_184812_l_()) break block7;
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.BOLD + "" + TextFormatting.RED + "WARNING! " + TextFormatting.WHITE + "World Stripping Initialized! Lag May Occur.."));
                    int x = (int)((double)player.func_180425_c().func_177958_n() - chunkClearSizeX);
                    while ((double)x <= (double)player.func_180425_c().func_177958_n() + chunkClearSizeX) {
                        int y = 0;
                        while ((double)y <= (double)(player.func_180425_c().func_177956_o() + 16)) {
                            int z = (int)((double)player.func_180425_c().func_177952_p() - chunkClearSizeZ);
                            while ((double)z <= (double)player.func_180425_c().func_177952_p() + chunkClearSizeZ) {
                                block9: {
                                    Block targetBlock;
                                    IBlockState targetBlockState;
                                    BlockPos targetBlockPos;
                                    block8: {
                                        targetBlockPos = new BlockPos(x, y, z);
                                        targetBlockState = world.func_180495_p(targetBlockPos);
                                        targetBlock = targetBlockState.func_177230_c();
                                        if (!targetBlock.equals(Blocks.field_150357_h)) break block8;
                                        if (targetBlock.equals(Blocks.field_150350_a)) break block9;
                                    }
                                    Arrays.stream((Object[])Config.profileMap.get(profile)).filter(targetBlock.getRegistryName().toString()::equals).forEachOrdered(s -> {
                                        PacketHandler.hashedBlockCache.put(targetBlockPos, targetBlockState);
                                        world.func_180501_a(targetBlockPos, Objects.requireNonNull(Block.func_149684_b((String)Config.replacerBlock)).func_176223_P(), Config.blockStateFlag);
                                    });
                                    if (hasMeta) {
                                        Arrays.stream((Object[])Config.profileMap.get(profile)).filter(targetBlockState.toString()::equals).forEachOrdered(s -> {
                                            PacketHandler.hashedBlockCache.put(targetBlockPos, targetBlockState);
                                            world.func_180501_a(targetBlockPos, Blocks.field_150350_a.func_176223_P(), Config.blockStateFlag);
                                        });
                                    }
                                }
                                ++z;
                            }
                            ++y;
                        }
                        ++x;
                    }
                    player.func_145747_a((ITextComponent)new TextComponentString("World Stripping Successfully Done!"));
                    break block10;
                }
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Error: You have to be in creative mode to use this feature!"));
            }
            player.func_145747_a((ITextComponent)new TextComponentString(watch.elapsed(TimeUnit.MILLISECONDS) + "ms"));
            watch.stop();
        }
    }
}

