/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.block.JSGBlocks;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.config.parsers.BiomeParser;
import tauri.dev.jsg.config.parsers.BlockMetaParser;
import tauri.dev.jsg.config.parsers.ItemMetaParser;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.util.ItemMetaPair;
import tauri.dev.jsg.util.JSGAxisAlignedBB;

public class JSGConfigUtil {
    private static Map<IBlockState, Boolean> cachedInvincibleBlocks = null;
    private static Map<Biome, BiomeOverlayEnum> cachedBiomeMatchesReverse = null;
    private static Map<BiomeOverlayEnum, List<ItemMetaPair>> cachedBiomeOverrideBlocks = null;
    private static Map<ItemMetaPair, BiomeOverlayEnum> cachedBiomeOverrideBlocksReverse = null;

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("jsg")) {
            ConfigManager.sync((String)"jsg", (Config.Type)Config.Type.INSTANCE);
            JSG.info("Should be saved");
            JSGConfigUtil.resetCache();
        }
    }

    public static void rescaleToConfig() {
        GlStateManager.func_179109_b((float)JSGConfig.General.devConfig.x, (float)JSGConfig.General.devConfig.y, (float)JSGConfig.General.devConfig.z);
        GlStateManager.func_179152_a((float)JSGConfig.General.devConfig.s, (float)JSGConfig.General.devConfig.s, (float)JSGConfig.General.devConfig.s);
    }

    public static void rotateToConfig() {
        GlStateManager.func_179114_b((float)JSGConfig.General.devConfig.x2, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)JSGConfig.General.devConfig.y2, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)JSGConfig.General.devConfig.z2, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public static JSGAxisAlignedBB createHitbox() {
        return new JSGAxisAlignedBB(JSGConfig.General.devConfig.x, JSGConfig.General.devConfig.y, JSGConfig.General.devConfig.z, JSGConfig.General.devConfig.x2, JSGConfig.General.devConfig.y2, JSGConfig.General.devConfig.z2);
    }

    public static void resetCache() {
        cachedInvincibleBlocks = null;
        cachedBiomeMatchesReverse = null;
        cachedBiomeOverrideBlocks = null;
        cachedBiomeOverrideBlocksReverse = null;
    }

    public static boolean canKawooshDestroyBlock(IBlockState state) {
        if (state.func_177230_c() == JSGBlocks.IRIS_BLOCK) {
            return false;
        }
        if (state.func_177230_c() == JSGBlocks.INVISIBLE_BLOCK) {
            return false;
        }
        if (cachedInvincibleBlocks == null) {
            cachedInvincibleBlocks = BlockMetaParser.parseConfig(JSGConfig.Stargate.eventHorizon.kawooshInvincibleBlocks);
        }
        if (cachedInvincibleBlocks.get(state.func_177230_c().func_176223_P()) != null && cachedInvincibleBlocks.get(state.func_177230_c().func_176223_P()).booleanValue()) {
            return false;
        }
        return cachedInvincibleBlocks.get(state) == null;
    }

    public static Map<Biome, BiomeOverlayEnum> getBiomeOverrideBiomes() {
        if (cachedBiomeMatchesReverse == null) {
            cachedBiomeMatchesReverse = new HashMap<Biome, BiomeOverlayEnum>();
            for (Map.Entry<String, String[]> entry : JSGConfig.Stargate.visual.biomeMatches.entrySet()) {
                List<Biome> parsedList = BiomeParser.parseConfig(entry.getValue());
                BiomeOverlayEnum biomeOverlay = BiomeOverlayEnum.fromString(entry.getKey());
                for (Biome biome : parsedList) {
                    cachedBiomeMatchesReverse.put(biome, biomeOverlay);
                }
            }
        }
        return cachedBiomeMatchesReverse;
    }

    private static void genBiomeOverrideCache() {
        cachedBiomeOverrideBlocks = new HashMap<BiomeOverlayEnum, List<ItemMetaPair>>();
        cachedBiomeOverrideBlocksReverse = new HashMap<ItemMetaPair, BiomeOverlayEnum>();
        for (Map.Entry<String, String[]> entry : JSGConfig.Stargate.visual.biomeOverrideBlocks.entrySet()) {
            List<ItemMetaPair> parsedList = ItemMetaParser.parseConfig(entry.getValue());
            BiomeOverlayEnum biomeOverlay = BiomeOverlayEnum.fromString(entry.getKey());
            cachedBiomeOverrideBlocks.put(biomeOverlay, parsedList);
            for (ItemMetaPair stack : parsedList) {
                cachedBiomeOverrideBlocksReverse.put(stack, biomeOverlay);
            }
        }
    }

    public static Map<BiomeOverlayEnum, List<ItemMetaPair>> getBiomeOverrideBlocks() {
        if (cachedBiomeOverrideBlocks == null) {
            JSGConfigUtil.genBiomeOverrideCache();
        }
        return cachedBiomeOverrideBlocks;
    }

    public static Map<ItemMetaPair, BiomeOverlayEnum> getBiomeOverrideItemMetaPairs() {
        if (cachedBiomeOverrideBlocksReverse == null) {
            JSGConfigUtil.genBiomeOverrideCache();
        }
        return cachedBiomeOverrideBlocksReverse;
    }
}

