/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.container.beamer;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import tauri.dev.jsg.beamer.BeamerRoleEnum;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.tileentity.util.RedstoneModeEnum;

public class BeamerContainerGuiUpdate
extends State {
    public int energyStored;
    public int transferredLastTick;
    public FluidStack fluidStack;
    public BeamerRoleEnum beamerRole;
    public RedstoneModeEnum mode;
    public int start;
    public int stop;
    public int inactivity;

    public BeamerContainerGuiUpdate() {
    }

    public BeamerContainerGuiUpdate(int energyStored, int transferedLastTick, FluidStack fluidStack, BeamerRoleEnum beamerRole, RedstoneModeEnum redstoneMode, int start, int stop, int inactivity) {
        this.energyStored = energyStored;
        this.transferredLastTick = transferedLastTick;
        this.fluidStack = fluidStack;
        this.beamerRole = beamerRole;
        this.mode = redstoneMode;
        this.start = start;
        this.stop = stop;
        this.inactivity = inactivity;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.energyStored);
        buf.writeInt(this.transferredLastTick);
        buf.writeInt(this.beamerRole.id);
        buf.writeInt(this.mode.getKey().intValue());
        buf.writeInt(this.start);
        buf.writeInt(this.stop);
        buf.writeInt(this.inactivity);
        if (this.fluidStack != null) {
            buf.writeBoolean(true);
            String name = FluidRegistry.getFluidName((FluidStack)this.fluidStack);
            buf.writeInt(name.length());
            buf.writeCharSequence((CharSequence)name, StandardCharsets.UTF_8);
            buf.writeInt(this.fluidStack.amount);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.energyStored = buf.readInt();
        this.transferredLastTick = buf.readInt();
        this.beamerRole = BeamerRoleEnum.valueOf(buf.readInt());
        this.mode = RedstoneModeEnum.valueOf(buf.readInt());
        this.start = buf.readInt();
        this.stop = buf.readInt();
        this.inactivity = buf.readInt();
        if (buf.readBoolean()) {
            int size = buf.readInt();
            this.fluidStack = FluidRegistry.getFluidStack((String)buf.readCharSequence(size, StandardCharsets.UTF_8).toString(), (int)buf.readInt());
        }
    }
}

