/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.container.zpmhub;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import tauri.dev.jsg.capability.CapabilityEnergyZPM;
import tauri.dev.jsg.gui.util.ContainerHelper;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.StateUpdatePacketToClient;
import tauri.dev.jsg.power.zpm.ZPMHubEnergyStorage;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.tileentity.energy.ZPMHubTile;

public class ZPMHubContainer
extends Container {
    public ZPMHubTile hubTile;
    public ArrayList<Slot> slots;
    private final BlockPos pos;
    private long lastEnergyStored;
    private long energyTransferedLastTick;

    @Nonnull
    public ArrayList<Slot> getSlots(IItemHandler itemHandler) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        slots.add((Slot)new SlotItemHandler(itemHandler, 0, 80, 27));
        slots.add((Slot)new SlotItemHandler(itemHandler, 1, 56, 51));
        slots.add((Slot)new SlotItemHandler(itemHandler, 2, 104, 51));
        return slots;
    }

    public ZPMHubContainer(IInventory playerInventory, World world, int x, int y, int z) {
        this.pos = new BlockPos(x, y, z);
        this.hubTile = (ZPMHubTile)world.func_175625_s(this.pos);
        IItemHandler itemHandler = null;
        if (this.hubTile != null) {
            itemHandler = (IItemHandler)this.hubTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        }
        this.slots = this.getSlots(itemHandler);
        for (Slot slot : this.slots) {
            this.func_75146_a(slot);
        }
        for (Slot slot : ContainerHelper.generatePlayerSlots(playerInventory, this.getInventoryY())) {
            this.func_75146_a(slot);
        }
    }

    public int getInventoryY() {
        return 97;
    }

    public boolean func_75145_c(@Nonnull EntityPlayer player) {
        return true;
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull EntityPlayer playerIn, int slotId) {
        ItemStack returnStack = ItemStack.field_190927_a;
        Slot slot = this.func_75139_a(slotId);
        if (slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            returnStack = stack.func_77946_l();
            if (slotId < this.slots.size() ? !this.func_75135_a(stack, this.slots.size(), this.field_75151_b.size(), true) : !this.func_75135_a(stack, 0, this.slots.size(), true)) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return returnStack;
    }

    public void func_75142_b() {
        super.func_75142_b();
        ZPMHubEnergyStorage energyStorage = (ZPMHubEnergyStorage)this.hubTile.getCapability(CapabilityEnergyZPM.ENERGY, null);
        if (energyStorage != null && (this.lastEnergyStored != energyStorage.getEnergyStoredInternally() || this.energyTransferedLastTick != this.hubTile.getEnergyTransferedLastTick())) {
            for (IContainerListener listener : this.field_75149_d) {
                if (!(listener instanceof EntityPlayerMP)) continue;
                JSGPacketHandler.INSTANCE.sendTo((IMessage)new StateUpdatePacketToClient(this.pos, StateTypeEnum.GUI_UPDATE, this.hubTile.getState(StateTypeEnum.GUI_UPDATE)), (EntityPlayerMP)listener);
            }
            this.lastEnergyStored = energyStorage.getEnergyStoredInternally();
            this.energyTransferedLastTick = this.hubTile.getEnergyTransferedLastTick();
        }
    }
}

