/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.element;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class GuiHelper {
    public static void drawTexturedRectScaled(int xLeftCoord, int yBottomCoord, TextureAtlasSprite textureSprite, int maxWidth, int maxHeight, float scaleHeight) {
        maxHeight = (int)((float)maxHeight * scaleHeight);
        GuiHelper.drawTexturedRect(xLeftCoord, yBottomCoord -= maxHeight, textureSprite, maxWidth, maxHeight, scaleHeight);
    }

    public static void drawTexturedRect(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int maxWidth, int maxHeight, float scaleHeight) {
        double v = textureSprite.func_94210_h() - textureSprite.func_94206_g();
        v *= (double)(1.0f - scaleHeight);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + maxHeight), 0.0).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + maxWidth), (double)(yCoord + maxHeight), 0.0).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + maxWidth), (double)(yCoord + 0), 0.0).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g() + v).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + 0), 0.0).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g() + v).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedRect(int x, int y, int textureX, int textureY, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(x + 0), (double)(y + height), 0.0).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + 0), 0.0).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static boolean isPointInRegion(int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY) {
        return pointX >= rectX - 1 && pointX < rectX + rectWidth + 1 && pointY >= rectY - 1 && pointY < rectY + rectHeight + 1;
    }

    public static void drawTexturedRectWithShadow(int x, int y, int xOffset, int yOffset, int xSize, int ySize, float color) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)color, (float)color, (float)color, (float)1.0f);
        Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)xSize, (int)ySize, (float)xSize, (float)ySize);
        GlStateManager.func_179131_c((float)color, (float)color, (float)color, (float)0.2f);
        Gui.func_146110_a((int)(x + xOffset), (int)(y + yOffset), (float)0.0f, (float)0.0f, (int)xSize, (int)ySize, (float)xSize, (float)ySize);
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

