/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.element.tabs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import tauri.dev.jsg.config.ingame.JSGConfigOption;
import tauri.dev.jsg.config.ingame.JSGConfigOptionTypeEnum;
import tauri.dev.jsg.config.ingame.JSGTileEntityConfig;
import tauri.dev.jsg.gui.element.GuiHelper;
import tauri.dev.jsg.gui.element.ModeButton;
import tauri.dev.jsg.gui.element.tabs.Tab;
import tauri.dev.jsg.gui.element.tabs.TabScrollAble;

public class TabConfig
extends TabScrollAble {
    private final List<GuiTextField> FIELDS = new ArrayList<GuiTextField>();
    private final List<ModeButton> BUTTONS = new ArrayList<ModeButton>();
    public JSGTileEntityConfig config;
    private Runnable onTabClose = null;

    protected TabConfig(TabConfigBuilder builder) {
        super(builder);
        this.config = builder.config;
        this.updateConfig(builder.config, true);
    }

    public static TabConfigBuilder builder() {
        return new TabConfigBuilder();
    }

    @Override
    public void render(FontRenderer fontRenderer, int mouseX, int mouseY) {
        int y;
        int x;
        int id;
        if (!this.isVisible()) {
            return;
        }
        super.render(fontRenderer, mouseX, mouseY);
        this.updateConfig(null, false);
        for (GuiTextField field : this.FIELDS) {
            id = field.func_175206_d() - 100;
            x = field.field_146209_f;
            y = field.field_146210_g - 9;
            if (!this.canRenderEntry(x, y) || id < 0) continue;
            fontRenderer.func_78276_b(I18n.func_135052_a((String)this.config.getOption(id).getLabel(), (Object[])new Object[0]), x, y, 0x404040);
            field.func_146194_f();
        }
        for (ModeButton button : this.BUTTONS) {
            id = button.field_146127_k - 100;
            x = button.field_146128_h;
            y = button.field_146129_i - 9;
            if (!this.canRenderEntry(x, y) || id < 0) continue;
            fontRenderer.func_78276_b(I18n.func_135052_a((String)this.config.getOption(id).getLabel(), (Object[])new Object[0]), x, y, 0x404040);
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            button.drawButton(mouseX, mouseY);
            GlStateManager.func_179084_k();
        }
        this.renderCover(fontRenderer);
    }

    @Override
    public void renderFg(GuiScreen screen, FontRenderer fontRenderer, int mouseX, int mouseY) {
        super.renderFg(screen, fontRenderer, mouseX, mouseY);
        if (this.isVisible() && this.isOpen()) {
            int id;
            int x;
            int y;
            for (GuiTextField field : this.FIELDS) {
                y = field.field_146210_g - 9;
                x = field.field_146209_f;
                id = field.func_175206_d() - 100;
                if (!this.canRenderEntry(x, y) || !GuiHelper.isPointInRegion(x, y, field.field_146218_h, 10 + field.field_146219_i, mouseX, mouseY)) continue;
                screen.func_146283_a(this.config.getOption(id).getCommentToRender(), mouseX - this.guiLeft, mouseY - this.guiTop);
            }
            for (ModeButton button : this.BUTTONS) {
                y = button.field_146129_i - 9;
                x = button.field_146128_h;
                id = button.field_146127_k - 100;
                if (!this.canRenderEntry(x, y) || !GuiHelper.isPointInRegion(x, y, 75, 10 + button.field_146121_g, mouseX, mouseY)) continue;
                screen.func_146283_a(this.config.getOption(id).getCommentToRender(), mouseX - this.guiLeft, mouseY - this.guiTop);
            }
        }
    }

    @Override
    public boolean canContinueScrolling(int k) {
        boolean isTop;
        int top = this.guiTop + this.defaultY + 30;
        int bottom = this.guiTop + this.defaultY + this.height - 38;
        if (this.FIELDS.size() < 1 && this.BUTTONS.size() < 1) {
            return false;
        }
        boolean bl = this.FIELDS.size() > 0 && this.FIELDS.get(0).func_175206_d() < this.BUTTONS.get((int)0).field_146127_k ? this.FIELDS.get((int)0).field_146210_g > top : (isTop = this.BUTTONS.get((int)0).field_146129_i > top);
        boolean isBottom = this.FIELDS.size() > 0 && this.FIELDS.get(this.FIELDS.size() - 1).func_175206_d() >= this.BUTTONS.get((int)(this.BUTTONS.size() - 1)).field_146127_k ? this.FIELDS.get((int)(this.FIELDS.size() - 1)).field_146210_g < bottom : this.BUTTONS.get((int)(this.BUTTONS.size() - 1)).field_146129_i < bottom;
        return !isTop && k == 1 || !isBottom && k == -1;
    }

    @Override
    public boolean canRenderEntry(int x, int y) {
        int top = this.guiTop + this.defaultY + 3;
        int bottom = this.guiTop + this.defaultY + this.height;
        int height = this.FIELDS.size() > 0 ? this.FIELDS.get((int)0).field_146219_i : (this.BUTTONS.size() > 0 ? this.BUTTONS.get((int)0).field_146121_g : 16);
        return y >= top && y + height <= bottom - 12;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        for (GuiTextField field : this.FIELDS) {
            field.func_146192_a(mouseX, mouseY, mouseButton);
        }
        for (ModeButton button : this.BUTTONS) {
            if (!GuiHelper.isPointInRegion(button.field_146128_h, button.field_146129_i, button.field_146120_f, button.field_146121_g, mouseX, mouseY)) continue;
            switch (mouseButton) {
                case 0: {
                    button.nextState();
                    break;
                }
                case 1: {
                    button.previousState();
                    break;
                }
                case 2: {
                    button.setCurrentState(this.config.getOption(button.field_146127_k - 100).getIntValue(true));
                }
            }
            button.func_146113_a(Minecraft.func_71410_x().func_147118_V());
        }
        this.getConfig(true);
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) {
        boolean typed = false;
        for (GuiTextField field : this.FIELDS) {
            if (!field.func_146201_a(typedChar, keyCode)) continue;
            typed = true;
        }
        this.getConfig(true);
        return typed;
    }

    public void setOnTabClose(Runnable onTabClose) {
        this.onTabClose = onTabClose;
    }

    @Override
    public void closeTab() {
        if (this.onTabClose != null) {
            this.onTabClose.run();
        }
        super.closeTab();
    }

    public JSGTileEntityConfig getConfig(boolean saveValues) {
        if (saveValues) {
            for (GuiTextField field : this.FIELDS) {
                this.config.getOption(field.func_175206_d() - 100).setValue(field.func_146179_b());
            }
            for (ModeButton button : this.BUTTONS) {
                this.config.getOption(button.field_146127_k - 100).setValue(button.getCurrentState() + "");
            }
        }
        return this.config;
    }

    public void updateConfig(JSGTileEntityConfig config, boolean resetFields) {
        block6: {
            int k;
            block5: {
                if (config != null) {
                    this.config = config;
                }
                k = this.guiTop + this.defaultY + 34;
                if (!resetFields) break block5;
                this.FIELDS.clear();
                this.BUTTONS.clear();
                if (config == null) break block6;
                for (JSGConfigOption option : config.getOptions()) {
                    if (option.type == JSGConfigOptionTypeEnum.SWITCH || option.type == JSGConfigOptionTypeEnum.BOOLEAN) {
                        ModeButton btn = option.createButton(k);
                        if (btn == null) continue;
                        this.BUTTONS.add(btn);
                        continue;
                    }
                    GuiTextField field = option.createField(k);
                    if (field == null) continue;
                    this.FIELDS.add(field);
                }
                break block6;
            }
            for (ModeButton btn : this.BUTTONS) {
                if (btn == null) continue;
                btn.field_146129_i = 29 * (btn.field_146127_k - 100) + k + this.scrolled;
                btn.field_146128_h = this.guiLeft + 6 + this.currentOffsetX + 25;
            }
            for (GuiTextField field : this.FIELDS) {
                if (field == null) continue;
                field.field_146210_g = 29 * (field.func_175206_d() - 100) + k + this.scrolled;
                field.field_146209_f = this.guiLeft + 6 + this.currentOffsetX + 25;
            }
        }
    }

    public static class TabConfigBuilder
    extends Tab.TabBuilder {
        private JSGTileEntityConfig config;

        public TabConfigBuilder setConfig(JSGTileEntityConfig config) {
            this.config = config;
            return this;
        }

        @Override
        public TabConfig build() {
            return new TabConfig(this);
        }
    }
}

