/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.integration.jei.category;

import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import tauri.dev.jsg.block.JSGBlocks;
import tauri.dev.jsg.integration.jei.AbstractJEIRecipe;

public class JEIPCBFabricatorRecipeCategory
implements IRecipeCategory<AbstractJEIRecipe> {
    public static final String UID = "jsg_pcb_fabricator";
    public static final ResourceLocation BACK_TEXTURE = new ResourceLocation("jsg", "textures/gui/container_pcb_fabricator_jei.png");
    public final IDrawable background;
    public final IDrawable icon;
    public final IDrawable progressBar;
    public final IDrawable fluidMeter;

    public JEIPCBFabricatorRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(BACK_TEXTURE, 0, 0, 137, 55);
        this.fluidMeter = helper.createDrawable(BACK_TEXTURE, 176, 32, 16, 54);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((Block)JSGBlocks.MACHINE_PCB_FABRICATOR));
        this.progressBar = helper.createAnimatedDrawable(helper.createDrawable(BACK_TEXTURE, 176, 0, 40, 15), 40, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"tile.jsg.pcb_fabricator_block.name", (Object[])new Object[0]);
    }

    @Nonnull
    public String getModName() {
        return "Just Stargate Mod";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.fluidMeter.draw(minecraft, 64, 0);
        this.progressBar.draw(minecraft, 58, 19);
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull AbstractJEIRecipe recipe, @Nonnull IIngredients ingredients) {
        int i = 0;
        for (int y1 = 0; y1 < 3; ++y1) {
            for (int x1 = 0; x1 < 3; ++x1) {
                recipeLayout.getItemStacks().init(i, true, 18 * x1, 1 + 18 * y1);
                ++i;
            }
        }
        recipeLayout.getItemStacks().init(9, false, 116, 18);
        recipeLayout.getItemStacks().set(ingredients);
        recipeLayout.getFluidStacks().init(10, true, 65, 1, 16, 53, 7000, false, this.fluidMeter);
        recipeLayout.getFluidStacks().set(10, recipe.getSubFluidStack());
    }
}

