/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.item.tools;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHandSide;
import tauri.dev.jsg.item.renderer.ItemRenderHelper;
import tauri.dev.jsg.item.tools.EnergyWeapon;
import tauri.dev.jsg.loader.ElementEnum;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;

public abstract class EnergyWeaponTEISR
extends TileEntityItemStackRenderer {
    private double y = 0.0;
    private double x = 0.0;
    private double z = 0.0;
    private int rot = 0;
    private int R_MAX = 0;
    private int R_MIN = 0;
    private double X_MIN = 0.0;
    private double Y_MIN = 0.0;
    private double Z_MIN = 0.0;
    private double X_MIN2 = 0.0;
    private double Y_MIN2 = 0.0;
    private double X_MAX = 0.0;
    private double Y_MAX = 0.0;
    private double Z_MAX = 0.0;
    private double X_MAX2 = 0.0;
    private double Y_MAX2 = 0.0;
    private double STEP = 1.0;

    protected void setPositions(double xMin, double xMin2, double yMin, double yMin2, double zMin, double xMax, double xMax2, double yMax, double yMax2, double zMax, int rScoped, int rDefault, double step) {
        this.X_MIN = xMin;
        this.Y_MIN = yMin;
        this.Z_MIN = zMin;
        this.X_MIN2 = xMin2;
        this.Y_MIN2 = yMin2;
        this.X_MAX = xMax;
        this.Y_MAX = yMax;
        this.Z_MAX = zMax;
        this.X_MAX2 = xMax2;
        this.Y_MAX2 = yMax2;
        this.R_MAX = rScoped;
        this.R_MIN = rDefault;
        this.STEP = step;
    }

    public void func_179022_a(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof EnergyWeapon)) {
            return;
        }
        EnergyWeapon item = (EnergyWeapon)stack.func_77973_b();
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        ItemCameraTransforms.TransformType transformType = item.getLastTransform();
        GlStateManager.func_179094_E();
        NBTTagCompound compound = stack.func_77978_p();
        boolean isScoped = false;
        if (compound != null) {
            isScoped = compound.func_74767_n("scope");
        }
        if (transformType == ItemCameraTransforms.TransformType.FIXED) {
            this.setFixedTranslate();
        } else {
            boolean mainhand = item.getLastTransform() == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND;
            EnumHandSide handSide = mainhand ? EnumHandSide.RIGHT : EnumHandSide.LEFT;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks;
            float angle = ItemRenderHelper.getMapAngleFromPitch(pitch);
            angle = 1.0f - angle;
            double k = -0.1;
            this.setPos(handSide, isScoped);
            if (handSide != EnumHandSide.RIGHT) {
                k = 0.0;
            }
            GlStateManager.func_179137_b((double)this.x, (double)this.y, (double)this.z);
            this.rotate(this.rot);
            GlStateManager.func_179137_b((double)0.0, (double)(0.3 * (double)angle), (double)(k * (double)angle));
            this.setSize();
        }
        this.getModel().bindTextureAndRender(BiomeOverlayEnum.NORMAL);
        GlStateManager.func_179121_F();
    }

    @Nonnull
    protected abstract ElementEnum getModel();

    protected abstract void setFixedTranslate();

    protected abstract void rotate(int var1);

    protected abstract void setSize();

    protected void setPos(EnumHandSide handSide, boolean isScoped) {
        if (handSide == EnumHandSide.RIGHT) {
            if (!isScoped) {
                this.rot = this.R_MIN;
                if (this.x < this.X_MIN - this.STEP) {
                    this.x += this.STEP;
                }
                if (this.x > this.X_MIN + this.STEP) {
                    this.x -= this.STEP;
                }
                if (this.y < this.Y_MIN - this.STEP) {
                    this.y += this.STEP;
                }
                if (this.y > this.Y_MIN + this.STEP) {
                    this.y -= this.STEP;
                }
                if (this.z < this.Z_MIN - this.STEP) {
                    this.z += this.STEP;
                }
                if (this.z > this.Z_MIN + this.STEP) {
                    this.z -= this.STEP;
                }
            } else {
                this.rot = this.R_MAX;
                if (this.x < this.X_MAX - this.STEP) {
                    this.x += this.STEP;
                }
                if (this.x > this.X_MAX + this.STEP) {
                    this.x -= this.STEP;
                }
                if (this.y < this.Y_MAX - this.STEP) {
                    this.y += this.STEP;
                }
                if (this.y > this.Y_MAX + this.STEP) {
                    this.y -= this.STEP;
                }
                if (this.z < this.Z_MAX - this.STEP) {
                    this.z += this.STEP;
                }
                if (this.z > this.Z_MAX + this.STEP) {
                    this.z -= this.STEP;
                }
            }
        } else if (!isScoped) {
            this.rot = this.R_MIN;
            if (this.x < this.X_MIN2 - this.STEP) {
                this.x += this.STEP;
            }
            if (this.x > this.X_MIN2 + this.STEP) {
                this.x -= this.STEP;
            }
            if (this.y < this.Y_MIN2 - this.STEP) {
                this.y += this.STEP;
            }
            if (this.y > this.Y_MIN2 + this.STEP) {
                this.y -= this.STEP;
            }
            if (this.z < this.Z_MIN - this.STEP) {
                this.z += this.STEP;
            }
            if (this.z > this.Z_MIN + this.STEP) {
                this.z -= this.STEP;
            }
        } else {
            this.rot = this.R_MAX;
            if (this.x < this.X_MAX2 - this.STEP) {
                this.x += this.STEP;
            }
            if (this.x > this.X_MAX2 + this.STEP) {
                this.x -= this.STEP;
            }
            if (this.y < this.Y_MAX2 - this.STEP) {
                this.y += this.STEP;
            }
            if (this.y > this.Y_MAX2 + this.STEP) {
                this.y -= this.STEP;
            }
            if (this.z < this.Z_MAX - this.STEP) {
                this.z += this.STEP;
            }
            if (this.z > this.Z_MAX + this.STEP) {
                this.z -= this.STEP;
            }
        }
    }
}

