/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import tauri.dev.jsg.JSG;

public class FolderLoader {
    public static List<String> getAllFiles(String path, String ... suffixes) throws IOException {
        ArrayList<String> out = new ArrayList<String>();
        String classPath = JSG.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        JSG.debug(String.format("classPath was '%s'.", classPath));
        classPath = classPath.replaceAll("%20", " ");
        JSG.debug(String.format("classPath is  '%s'.", classPath));
        int separatorIndex = classPath.indexOf("!");
        if (separatorIndex != -1) {
            classPath = classPath.substring(5, separatorIndex);
            JarFile jar = new JarFile(classPath);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith(path) || !FolderLoader.endsWith(name, suffixes)) continue;
                out.add(name);
            }
            jar.close();
        } else {
            FolderLoader.getAllFilesDev(path, out, suffixes);
        }
        return out;
    }

    private static boolean endsWith(String in, String ... suffixes) {
        for (String suffix : suffixes) {
            if (!in.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private static void getAllFilesDev(String path, List<String> out, String ... suffixes) throws IOException {
        InputStream stream = JSG.class.getClassLoader().getResourceAsStream(path);
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while (reader.ready()) {
            String name = path + "/" + reader.readLine();
            if (FolderLoader.endsWith(name, suffixes)) {
                out.add(name);
                continue;
            }
            FolderLoader.getAllFilesDev(name, out, suffixes);
        }
        reader.close();
    }
}

