/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.packet.transportrings;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import tauri.dev.jsg.packet.PositionedPacket;
import tauri.dev.jsg.tileentity.transportrings.TransportRingsAbstractTile;
import tauri.dev.jsg.tileentity.transportrings.controller.TRControllerAbstractTile;
import tauri.dev.jsg.transportrings.SymbolTypeTransportRingsEnum;
import tauri.dev.jsg.transportrings.TransportResult;

public class TRControllerActivatedToServer
extends PositionedPacket {
    public int symbol;
    public int symbolType;

    public TRControllerActivatedToServer() {
    }

    public TRControllerActivatedToServer(BlockPos pos, int angleIndex, SymbolTypeTransportRingsEnum symbolType) {
        super(pos);
        int i = angleIndex - 1;
        this.symbolType = symbolType.id;
        this.symbol = Objects.requireNonNull(SymbolTypeTransportRingsEnum.valueOf(this.symbolType).getSymbolByAngleIndex(i)).getId();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.symbol);
        buf.writeInt(this.symbolType);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.symbol = buf.readInt();
        this.symbolType = buf.readInt();
    }

    public static class TRControllerActivatedServerHandler
    implements IMessageHandler<TRControllerActivatedToServer, IMessage> {
        public IMessage onMessage(TRControllerActivatedToServer message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = player.func_71121_q();
            world.func_152344_a(() -> {
                TRControllerAbstractTile controllerTile = (TRControllerAbstractTile)world.func_175625_s(message.pos);
                if (controllerTile != null) {
                    TransportRingsAbstractTile ringsTile = controllerTile.getLinkedRingsTile((World)world);
                    if (ringsTile != null) {
                        TransportResult result = ringsTile.addSymbolToAddressInternal(SymbolTypeTransportRingsEnum.valueOf(message.symbolType).getSymbol(message.symbol), false);
                        result.sendMessageIfFailed((EntityPlayer)player);
                    } else {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.jsg.transportrings_controller_block.not_linked", new Object[0]), true);
                    }
                }
            });
            return null;
        }
    }
}

