/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.power.zpm;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.power.zpm.IEnergyStorageZPM;

public class ZPMItemEnergyStorage
implements IEnergyStorageZPM {
    private final ItemStack stack;
    protected final long maxEnergyStored;

    public ZPMItemEnergyStorage(ItemStack stack, long maxEnergyStored) {
        this.stack = stack;
        this.maxEnergyStored = maxEnergyStored;
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        long energyStored = this.getEnergyStored();
        int energyReceived = (int)Math.min(this.getMaxEnergyStored() - energyStored, (long)Math.min(JSGConfig.ZPM.power.zpmHubMaxEnergyTransfer / 3, maxReceive));
        if (!simulate) {
            this.setEnergyStored(energyStored + (long)energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        if ((long)maxExtract > this.getEnergyStored()) {
            maxExtract = (int)this.getEnergyStored();
        }
        if (!simulate) {
            this.setEnergyStored(this.getEnergyStored() - (long)maxExtract);
        }
        return maxExtract;
    }

    public void setEnergyStored(long energy) {
        this.getOrCreateCompound(this.stack).func_74772_a("longEnergy", energy);
    }

    @Override
    public long getEnergyStored() {
        NBTTagCompound tag = this.getOrCreateCompound(this.stack);
        if (tag.func_74764_b("energy")) {
            return tag.func_74762_e("energy");
        }
        return tag.func_74763_f("longEnergy");
    }

    @Override
    public long getMaxEnergyStored() {
        return this.maxEnergyStored;
    }

    @Override
    public boolean canExtract() {
        return true;
    }

    @Override
    public boolean canReceive() {
        return false;
    }

    private NBTTagCompound getOrCreateCompound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }
}

