/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.machine;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import tauri.dev.jsg.renderer.machine.AbstractMachineRendererState;

public class PCBFabricatorRendererState
extends AbstractMachineRendererState {
    public List<Float> colors = new ArrayList<Float>();

    public PCBFabricatorRendererState() {
    }

    public PCBFabricatorRendererState(long workStateChanged, int machineProgress, boolean isWorking, ItemStack workingOnItemStack, final float[] colors) {
        super(workStateChanged, machineProgress, isWorking, workingOnItemStack);
        this.colors = new ArrayList<Float>(){
            {
                for (float color : colors) {
                    this.add(Float.valueOf(color));
                }
            }
        };
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.colors.size());
        for (float color : this.colors) {
            buf.writeFloat(color);
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        int s = buf.readInt();
        this.colors.clear();
        for (int i = 0; i < s; ++i) {
            this.colors.add(Float.valueOf(buf.readFloat()));
        }
    }
}

