/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.stargate.merging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.config.stargate.StargateSizeEnum;
import tauri.dev.jsg.stargate.EnumMemberVariant;
import tauri.dev.jsg.stargate.merging.StargateAbstractMergeHelper;
import tauri.dev.jsg.tileentity.stargate.StargateClassicMemberTile;
import tauri.dev.jsg.util.FacingHelper;
import tauri.dev.jsg.util.JSGAxisAlignedBB;
import tauri.dev.jsg.util.main.JSGProps;

public abstract class StargateClassicMergeHelper
extends StargateAbstractMergeHelper {
    protected static final JSGAxisAlignedBB BASE_SEARCH_BOX_SMALL = new JSGAxisAlignedBB(-3.0, -7.0, 0.0, 3.0, 0.0, 0.0);
    protected static final JSGAxisAlignedBB BASE_SEARCH_BOX_LARGE = new JSGAxisAlignedBB(-5.0, -9.0, 0.0, 5.0, 0.0, 0.0);
    protected static final JSGAxisAlignedBB BASE_SEARCH_BOX_EXTRA_LARGE = new JSGAxisAlignedBB(-7.0, -13.0, 0.0, 7.0, 0.0, 0.0);
    protected static final List<BlockPos> RING_BLOCKS_SMALL = Arrays.asList(new BlockPos(1, 7, 0), new BlockPos(3, 5, 0), new BlockPos(3, 3, 0), new BlockPos(2, 1, 0), new BlockPos(-2, 1, 0), new BlockPos(-3, 3, 0), new BlockPos(-3, 5, 0), new BlockPos(-1, 7, 0));
    protected static final List<BlockPos> CHEVRON_BLOCKS_SMALL = Arrays.asList(new BlockPos(2, 6, 0), new BlockPos(3, 4, 0), new BlockPos(3, 2, 0), new BlockPos(-3, 2, 0), new BlockPos(-3, 4, 0), new BlockPos(-2, 6, 0), new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 7, 0));
    protected static final List<BlockPos> RING_BLOCKS_LARGE = Arrays.asList(new BlockPos(-1, 0, 0), new BlockPos(-3, 1, 0), new BlockPos(-4, 3, 0), new BlockPos(-5, 4, 0), new BlockPos(-4, 6, 0), new BlockPos(-4, 7, 0), new BlockPos(-2, 9, 0), new BlockPos(-1, 9, 0), new BlockPos(1, 9, 0), new BlockPos(2, 9, 0), new BlockPos(4, 7, 0), new BlockPos(4, 6, 0), new BlockPos(5, 4, 0), new BlockPos(4, 3, 0), new BlockPos(3, 1, 0), new BlockPos(1, 0, 0));
    protected static final List<BlockPos> CHEVRON_BLOCKS_LARGE = Arrays.asList(new BlockPos(3, 8, 0), new BlockPos(5, 5, 0), new BlockPos(4, 2, 0), new BlockPos(-4, 2, 0), new BlockPos(-5, 5, 0), new BlockPos(-3, 8, 0), new BlockPos(2, 0, 0), new BlockPos(-2, 0, 0), new BlockPos(0, 9, 0));
    protected static final List<BlockPos> RING_BLOCKS_EXTRA_LARGE = Arrays.asList(new BlockPos(1, 0, 0), new BlockPos(2, 1, 0), new BlockPos(3, 1, 0), new BlockPos(4, 1, 0), new BlockPos(4, 2, 0), new BlockPos(5, 2, 0), new BlockPos(5, 4, 0), new BlockPos(6, 4, 0), new BlockPos(6, 5, 0), new BlockPos(6, 6, 0), new BlockPos(6, 8, 0), new BlockPos(5, 8, 0), new BlockPos(5, 9, 0), new BlockPos(5, 10, 0), new BlockPos(4, 11, 0), new BlockPos(3, 11, 0), new BlockPos(2, 11, 0), new BlockPos(2, 12, 0), new BlockPos(1, 12, 0), new BlockPos(-1, 12, 0), new BlockPos(-2, 12, 0), new BlockPos(-2, 11, 0), new BlockPos(-3, 11, 0), new BlockPos(-4, 11, 0), new BlockPos(-5, 10, 0), new BlockPos(-5, 9, 0), new BlockPos(-5, 8, 0), new BlockPos(-6, 8, 0), new BlockPos(-6, 6, 0), new BlockPos(-6, 5, 0), new BlockPos(-6, 4, 0), new BlockPos(-5, 4, 0), new BlockPos(-5, 2, 0), new BlockPos(-4, 2, 0), new BlockPos(-4, 1, 0), new BlockPos(-3, 1, 0), new BlockPos(-2, 1, 0), new BlockPos(-1, 0, 0));
    protected static final List<BlockPos> CHEVRON_BLOCKS_EXTRA_LARGE = Arrays.asList(new BlockPos(4, 10, 0), new BlockPos(6, 7, 0), new BlockPos(5, 3, 0), new BlockPos(2, 0, 0), new BlockPos(-4, 10, 0), new BlockPos(-6, 7, 0), new BlockPos(-5, 3, 0), new BlockPos(-2, 0, 0), new BlockPos(0, 12, 0));

    @Override
    @Nonnull
    public List<BlockPos> getRingBlocks() {
        switch (JSGConfig.Stargate.stargateSize) {
            case LARGE: {
                return RING_BLOCKS_LARGE;
            }
            case EXTRA_LARGE: {
                return RING_BLOCKS_EXTRA_LARGE;
            }
        }
        return RING_BLOCKS_SMALL;
    }

    @Override
    @Nonnull
    public List<BlockPos> getChevronBlocks() {
        switch (JSGConfig.Stargate.stargateSize) {
            case LARGE: {
                return CHEVRON_BLOCKS_LARGE;
            }
            case EXTRA_LARGE: {
                return CHEVRON_BLOCKS_EXTRA_LARGE;
            }
        }
        return CHEVRON_BLOCKS_SMALL;
    }

    @Override
    public JSGAxisAlignedBB getBaseSearchBox() {
        switch (JSGConfig.Stargate.stargateSize) {
            case SMALL: 
            case MEDIUM: {
                return BASE_SEARCH_BOX_SMALL;
            }
            case LARGE: {
                return BASE_SEARCH_BOX_LARGE;
            }
            case EXTRA_LARGE: {
                return BASE_SEARCH_BOX_EXTRA_LARGE;
            }
        }
        return null;
    }

    public void convertToPattern(World world, BlockPos basePos, EnumFacing baseFacing, EnumFacing baseFacingVertical, StargateSizeEnum currentStargateSize, StargateSizeEnum targetStargateSize) {
        JSG.debug(basePos + ": Converting Stargate from " + (Object)((Object)currentStargateSize) + " to " + (Object)((Object)targetStargateSize));
        ArrayList<BlockPos> oldPatternBlocks = new ArrayList<BlockPos>();
        switch (currentStargateSize) {
            case SMALL: 
            case MEDIUM: {
                oldPatternBlocks.addAll(RING_BLOCKS_SMALL);
                oldPatternBlocks.addAll(CHEVRON_BLOCKS_SMALL);
                break;
            }
            case LARGE: {
                oldPatternBlocks.addAll(RING_BLOCKS_LARGE);
                oldPatternBlocks.addAll(CHEVRON_BLOCKS_LARGE);
                break;
            }
            case EXTRA_LARGE: {
                oldPatternBlocks.addAll(RING_BLOCKS_EXTRA_LARGE);
                oldPatternBlocks.addAll(CHEVRON_BLOCKS_EXTRA_LARGE);
            }
        }
        for (BlockPos pos : oldPatternBlocks) {
            world.func_175698_g(FacingHelper.rotateBlock(pos, baseFacing, baseFacingVertical).func_177971_a((Vec3i)basePos));
        }
        IBlockState memberState = this.getMemberBlock().func_176223_P().func_177226_a((IProperty)JSGProps.FACING_HORIZONTAL, (Comparable)baseFacing).func_177226_a((IProperty)JSGProps.FACING_VERTICAL, (Comparable)baseFacingVertical).func_177226_a((IProperty)JSGProps.RENDER_BLOCK, (Comparable)Boolean.valueOf(false));
        for (BlockPos pos : this.getRingBlocks()) {
            world.func_175656_a(FacingHelper.rotateBlock(pos, baseFacing, baseFacingVertical).func_177971_a((Vec3i)basePos), memberState.func_177226_a((IProperty)JSGProps.MEMBER_VARIANT, (Comparable)((Object)EnumMemberVariant.RING)));
        }
        for (BlockPos pos : this.getChevronBlocks()) {
            world.func_175656_a(FacingHelper.rotateBlock(pos, baseFacing, baseFacingVertical).func_177971_a((Vec3i)basePos), memberState.func_177226_a((IProperty)JSGProps.MEMBER_VARIANT, (Comparable)((Object)EnumMemberVariant.CHEVRON)));
        }
    }

    @Override
    protected boolean checkMemberBlock(IBlockAccess blockAccess, BlockPos pos, EnumFacing facing, EnumFacing facingVertical, EnumMemberVariant variant) {
        IBlockState state = blockAccess.func_180495_p(pos);
        return this.matchMember(state) && state.func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL) == facing && state.func_177229_b((IProperty)JSGProps.FACING_VERTICAL) == facingVertical && state.func_177229_b((IProperty)JSGProps.MEMBER_VARIANT) == variant;
    }

    @Override
    protected void updateMemberMergeStatus(World world, BlockPos checkPos, BlockPos basePos, EnumFacing baseFacing, EnumFacing baseFacingVertical, boolean shouldBeMerged) {
        IBlockState state = world.func_180495_p(checkPos = FacingHelper.rotateBlock(checkPos, baseFacing, baseFacingVertical).func_177971_a((Vec3i)basePos));
        if (this.matchMember(state)) {
            StargateClassicMemberTile memberTile = (StargateClassicMemberTile)world.func_175625_s(checkPos);
            if (shouldBeMerged && !memberTile.isMerged() || memberTile.isMerged() && memberTile.getBasePos().equals((Object)basePos)) {
                ItemStack camoStack = memberTile.getCamoItemStack();
                if (camoStack != null) {
                    InventoryHelper.func_180173_a((World)world, (double)checkPos.func_177958_n(), (double)checkPos.func_177956_o(), (double)checkPos.func_177952_p(), (ItemStack)camoStack);
                }
                if (memberTile.getCamoState() != null) {
                    memberTile.setCamoState(null);
                }
                memberTile.setBasePos((BlockPos)(shouldBeMerged ? basePos : null));
                world.func_180501_a(checkPos, state.func_177226_a((IProperty)JSGProps.RENDER_BLOCK, (Comparable)Boolean.valueOf(!shouldBeMerged)), 3);
            }
        }
    }

    private void updateMemberBasePos(IBlockAccess blockAccess, BlockPos pos, BlockPos basePos, EnumFacing baseFacing, EnumFacing baseFacingVertical) {
        IBlockState state = blockAccess.func_180495_p(pos);
        if (this.matchMember(state)) {
            StargateClassicMemberTile memberTile = (StargateClassicMemberTile)blockAccess.func_175625_s(pos);
            memberTile.setBasePos(basePos);
        }
    }

    @Override
    public void updateMembersBasePos(IBlockAccess blockAccess, BlockPos basePos, EnumFacing baseFacing, EnumFacing baseFacingVertical) {
        for (BlockPos pos : this.getRingBlocks()) {
            this.updateMemberBasePos(blockAccess, FacingHelper.rotateBlock(pos, baseFacing, baseFacingVertical).func_177971_a((Vec3i)basePos), basePos, baseFacing, baseFacingVertical);
        }
        for (BlockPos pos : this.getChevronBlocks()) {
            this.updateMemberBasePos(blockAccess, FacingHelper.rotateBlock(pos, baseFacing, baseFacingVertical).func_177971_a((Vec3i)basePos), basePos, baseFacing, baseFacingVertical);
        }
    }
}

