/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.tileentity;

import com.google.common.collect.Iterators;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.beamer.BeamerBeam;
import tauri.dev.jsg.beamer.BeamerModeEnum;
import tauri.dev.jsg.beamer.BeamerRendererAction;
import tauri.dev.jsg.beamer.BeamerRoleEnum;
import tauri.dev.jsg.beamer.BeamerStatusEnum;
import tauri.dev.jsg.block.JSGBlocks;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.gui.container.beamer.BeamerContainerGui;
import tauri.dev.jsg.gui.container.beamer.BeamerContainerGuiUpdate;
import tauri.dev.jsg.item.JSGItems;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.StateUpdatePacketToClient;
import tauri.dev.jsg.packet.StateUpdateRequestToServer;
import tauri.dev.jsg.power.stargate.StargateAbstractEnergyStorage;
import tauri.dev.jsg.sound.JSGSoundHelper;
import tauri.dev.jsg.sound.JSGSoundHelperClient;
import tauri.dev.jsg.sound.SoundEventEnum;
import tauri.dev.jsg.sound.SoundPositionedEnum;
import tauri.dev.jsg.stargate.EnumScheduledTask;
import tauri.dev.jsg.stargate.EnumStargateState;
import tauri.dev.jsg.stargate.network.StargatePos;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.state.StateProviderInterface;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.state.beamer.BeamerFluidUpdate;
import tauri.dev.jsg.state.beamer.BeamerRendererActionState;
import tauri.dev.jsg.state.beamer.BeamerRendererState;
import tauri.dev.jsg.state.beamer.BeamerRendererUpdate;
import tauri.dev.jsg.tileentity.stargate.StargateClassicBaseTile;
import tauri.dev.jsg.tileentity.util.ComparatorHelper;
import tauri.dev.jsg.tileentity.util.IUpgradable;
import tauri.dev.jsg.tileentity.util.RedstoneModeEnum;
import tauri.dev.jsg.tileentity.util.ScheduledTask;
import tauri.dev.jsg.tileentity.util.ScheduledTaskExecutorInterface;
import tauri.dev.jsg.util.JSGAxisAlignedBB;
import tauri.dev.jsg.util.LinkingHelper;
import tauri.dev.jsg.util.NBTHelper;
import tauri.dev.jsg.util.main.JSGProps;

@Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="opencomputers")
public class BeamerTile
extends TileEntity
implements ITickable,
IUpgradable,
StateProviderInterface,
ScheduledTaskExecutorInterface,
Environment {
    public static final float BEAMER_BEAM_MAX_RADIUS = 0.1375f;
    private EnumFacing facing;
    private NetworkRegistry.TargetPoint targetPoint;
    private JSGAxisAlignedBB renderBox;
    private JSGAxisAlignedBB renderBoxOffsetted;
    private StargatePos targetGatePos;
    private static final BlockMatcher BEAMER_MATCHER = BlockMatcher.func_177642_a((Block)JSGBlocks.BEAMER_BLOCK);
    private boolean addedToNetwork;
    private int powerTransferredSinceLastSignal;
    private final List<FluidStack> fluidsTransferredSinceLastSignal;
    private final List<ItemStack> itemsTransferredSinceLastSignal;
    private boolean firstCheck;
    private BeamerModeEnum beamerMode;
    private BeamerRoleEnum beamerRole;
    private BeamerStatusEnum beamerStatus;
    private World targetBeamerWorld;
    private BlockPos targetBeamerPos;
    private int comparatorOutput;
    private RedstoneModeEnum redstoneMode;
    private int start;
    private int stop;
    private int inactivity;
    private int timeWithoutItemTransfer;
    private boolean ocLocked;
    private boolean isObstructed;
    private BlockPos baseVect;
    private BlockPos basePos;
    private final ItemStackHandlerBeamer itemStackHandler;
    private Fluid previouslyStoredFluid;
    private FluidTank fluidHandler;
    private final StargateAbstractEnergyStorage energyStorage;
    private int energyStoredLastTick;
    private int energyTransferredLastTick;
    private boolean loopSoundPlaying;
    List<ScheduledTask> scheduledTasks;
    @Nullable
    public Fluid lastFluidTransferred;
    public int beamOffsetFromGateTarget;
    public int beamOffsetFromTargetX;
    public int beamOffsetFromTargetY;
    public int beamOffsetFromTargetZ;
    public float beamRadiusClient;
    private boolean beamRadiusWiden;
    private boolean beamRadiusShrink;
    private final Node node;

    public BeamerTile() {
        this.renderBoxOffsetted = this.renderBox = new JSGAxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.addedToNetwork = false;
        this.powerTransferredSinceLastSignal = 0;
        this.fluidsTransferredSinceLastSignal = new ArrayList<FluidStack>();
        this.itemsTransferredSinceLastSignal = new ArrayList<ItemStack>();
        this.firstCheck = true;
        this.beamerMode = BeamerModeEnum.NONE;
        this.beamerRole = BeamerRoleEnum.TRANSMIT;
        this.beamerStatus = BeamerStatusEnum.OBSTRUCTED;
        this.targetBeamerWorld = null;
        this.targetBeamerPos = null;
        this.redstoneMode = RedstoneModeEnum.AUTO;
        this.start = 10;
        this.stop = 90;
        this.inactivity = 5;
        this.itemStackHandler = new ItemStackHandlerBeamer(5);
        this.previouslyStoredFluid = null;
        this.fluidHandler = new FluidTank(null, JSGConfig.Beamer.container.fluidCapacity){

            protected void onContentsChanged() {
                if (BeamerTile.this.beamerRole == BeamerRoleEnum.TRANSMIT && (this.fluid == null || this.fluid.getFluid() != BeamerTile.this.previouslyStoredFluid)) {
                    Fluid fluidContained = this.fluid != null ? this.fluid.getFluid() : null;
                    BeamerFluidUpdate update = new BeamerFluidUpdate(fluidContained);
                    BeamerTile.this.sendState(StateTypeEnum.BEAMER_FLUID_UPDATE, update);
                    if (BeamerTile.this.targetBeamerWorld != null && BeamerTile.this.targetBeamerPos != null) {
                        BeamerTile targetTile = (BeamerTile)BeamerTile.this.targetBeamerWorld.func_175625_s(BeamerTile.this.targetBeamerPos);
                        targetTile.sendState(StateTypeEnum.BEAMER_FLUID_UPDATE, update);
                    }
                    BeamerTile.this.previouslyStoredFluid = fluidContained;
                }
                BeamerTile.this.func_70296_d();
            }

            public boolean canFill() {
                return BeamerTile.this.beamerRole == BeamerRoleEnum.TRANSMIT;
            }
        };
        this.energyStorage = new StargateAbstractEnergyStorage(JSGConfig.Beamer.container.energyCapacity, JSGConfig.Beamer.container.energyTransfer){

            @Override
            protected void onEnergyChanged() {
                BeamerTile.this.func_70296_d();
            }

            public boolean canReceive() {
                return BeamerTile.this.beamerRole == BeamerRoleEnum.TRANSMIT;
            }
        };
        this.energyStoredLastTick = 0;
        this.energyTransferredLastTick = 0;
        this.scheduledTasks = new ArrayList<ScheduledTask>();
        this.node = JSG.ocWrapper.createNode(this, "beamer");
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public JSGAxisAlignedBB getRenderBoxForDisplay() {
        return this.renderBox;
    }

    public void onLoad() {
        this.updateFacing((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL));
        if (!this.field_145850_b.field_72995_K) {
            this.targetPoint = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 512.0);
        } else {
            JSGPacketHandler.INSTANCE.sendToServer((IMessage)new StateUpdateRequestToServer(this.field_174879_c, StateTypeEnum.RENDERER_STATE));
            JSGPacketHandler.INSTANCE.sendToServer((IMessage)new StateUpdateRequestToServer(this.field_174879_c, StateTypeEnum.RENDERER_UPDATE));
        }
    }

    public void updateFacing(EnumFacing facing) {
        this.facing = facing;
        this.renderBox = new JSGAxisAlignedBB(-0.5, 0.0, -0.5, 0.5, 1.0, JSGConfig.Beamer.mechanics.reach).rotate(facing).offset(0.5, 0.0, 0.5);
        this.renderBoxOffsetted = this.renderBox.offset(this.field_174879_c);
    }

    private BeamerStatusEnum updateBeamerStatus() {
        BeamerTile targetBeamerTile;
        boolean isLaser;
        if (this.beamerMode == BeamerModeEnum.NONE) {
            return BeamerStatusEnum.NO_CRYSTAL;
        }
        if (!this.isLinked()) {
            return BeamerStatusEnum.NOT_LINKED;
        }
        StargateClassicBaseTile gateTile = this.getLinkedGateTile();
        if (!gateTile.getStargateState().engaged()) {
            if (this.targetGatePos != null) {
                this.targetGatePos = null;
                this.func_70296_d();
            }
            return BeamerStatusEnum.CLOSED;
        }
        this.updateTargetBeamerData(this.targetGatePos);
        boolean bl = isLaser = this.getMode() == BeamerModeEnum.LASER;
        if (this.beamerRole == BeamerRoleEnum.DISABLED) {
            return BeamerStatusEnum.BEAMER_DISABLED;
        }
        if (isLaser && this.beamerRole == BeamerRoleEnum.RECEIVE) {
            return BeamerStatusEnum.BEAMER_CANNOT_RECEIVE;
        }
        if (!isLaser) {
            if (this.targetBeamerWorld == null || this.targetBeamerPos == null || !BEAMER_MATCHER.apply(this.targetBeamerWorld.func_180495_p(this.targetBeamerPos))) {
                return BeamerStatusEnum.NO_BEAMER;
            }
            targetBeamerTile = (BeamerTile)this.targetBeamerWorld.func_175625_s(this.targetBeamerPos);
            if (targetBeamerTile == null) {
                return BeamerStatusEnum.NO_BEAMER;
            }
            if (targetBeamerTile.isObstructed) {
                return BeamerStatusEnum.OBSTRUCTED_TARGET;
            }
            if (targetBeamerTile.getRole() == BeamerRoleEnum.DISABLED) {
                return BeamerStatusEnum.BEAMER_DISABLED_TARGET;
            }
            if (targetBeamerTile.getStatus() == BeamerStatusEnum.BEAMER_DISABLED_BY_LOGIC) {
                return BeamerStatusEnum.BEAMER_DISABLED_BY_LOGIC_TARGET;
            }
            if (this.beamerRole == targetBeamerTile.getRole()) {
                if (this.beamerRole == BeamerRoleEnum.TRANSMIT) {
                    return BeamerStatusEnum.TWO_TRANSMITTERS;
                }
                return BeamerStatusEnum.TWO_RECEIVERS;
            }
            if (this.beamerMode.id != targetBeamerTile.getMode().id) {
                return BeamerStatusEnum.MODE_MISMATCH;
            }
        }
        if (this.isObstructed) {
            return BeamerStatusEnum.OBSTRUCTED;
        }
        if (isLaser && !gateTile.getStargateState().initiating() || !isLaser && this.beamerMode != BeamerModeEnum.POWER && (gateTile.getStargateState().initiating() && this.beamerRole != BeamerRoleEnum.TRANSMIT || gateTile.getStargateState() == EnumStargateState.ENGAGED && this.beamerRole != BeamerRoleEnum.RECEIVE)) {
            return BeamerStatusEnum.INCOMING;
        }
        if (isLaser && this.energyStorage.getEnergyStored() < JSGConfig.Beamer.power.laserEnergy) {
            return BeamerStatusEnum.NO_POWER;
        }
        switch (this.redstoneMode) {
            case AUTO: {
                if (this.beamerRole == BeamerRoleEnum.RECEIVE && (this.beamerMode == BeamerModeEnum.POWER || this.beamerMode == BeamerModeEnum.FLUID)) {
                    float level = 0.0f;
                    level = this.beamerMode == BeamerModeEnum.POWER ? (float)this.energyStorage.getEnergyStored() / (float)this.energyStorage.getMaxEnergyStored() : (float)this.fluidHandler.getFluidAmount() / (float)this.fluidHandler.getCapacity();
                    level *= 100.0f;
                    if (this.beamerStatus == BeamerStatusEnum.OK) {
                        if (level > (float)this.stop) {
                            return BeamerStatusEnum.BEAMER_DISABLED_BY_LOGIC;
                        }
                        return BeamerStatusEnum.OK;
                    }
                    if (this.beamerStatus == BeamerStatusEnum.BEAMER_DISABLED_BY_LOGIC) {
                        if (level < (float)this.start) {
                            return BeamerStatusEnum.OK;
                        }
                        return BeamerStatusEnum.BEAMER_DISABLED_BY_LOGIC;
                    }
                }
                if (this.beamerMode != BeamerModeEnum.ITEMS) break;
                if (this.beamerStatus == BeamerStatusEnum.OK) {
                    if (this.timeWithoutItemTransfer > this.inactivity) {
                        return BeamerStatusEnum.BEAMER_DISABLED_BY_LOGIC;
                    }
                    return BeamerStatusEnum.OK;
                }
                if (this.beamerStatus != BeamerStatusEnum.BEAMER_DISABLED_BY_LOGIC) break;
                targetBeamerTile = (BeamerTile)this.targetBeamerWorld.func_175625_s(this.targetBeamerPos);
                for (int i = 1; i < 5; ++i) {
                    if ((this.beamerRole != BeamerRoleEnum.RECEIVE || Objects.requireNonNull(targetBeamerTile).itemStackHandler.getStackInSlot(i).func_190926_b()) && (this.beamerRole != BeamerRoleEnum.TRANSMIT || this.itemStackHandler.getStackInSlot(i).func_190926_b())) continue;
                    return BeamerStatusEnum.OK;
                }
                return BeamerStatusEnum.BEAMER_DISABLED_BY_LOGIC;
            }
            case ON_HIGH: {
                return this.field_145850_b.func_175640_z(this.field_174879_c) ? BeamerStatusEnum.OK : BeamerStatusEnum.BEAMER_DISABLED_BY_LOGIC;
            }
            case ON_LOW: {
                return this.field_145850_b.func_175640_z(this.field_174879_c) ? BeamerStatusEnum.BEAMER_DISABLED_BY_LOGIC : BeamerStatusEnum.OK;
            }
            case IGNORED: {
                return this.ocLocked ? BeamerStatusEnum.BEAMER_DISABLED_BY_LOGIC : BeamerStatusEnum.OK;
            }
        }
        return BeamerStatusEnum.OK;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ScheduledTask.iterate(this.scheduledTasks, this.field_145850_b.func_82737_E());
            if (!this.addedToNetwork) {
                JSG.ocWrapper.joinOrCreateNetwork(this);
                this.addedToNetwork = true;
            }
            BeamerStatusEnum lastBeamerStatus = this.beamerStatus;
            if (this.firstCheck || this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.firstCheck = false;
                int lastComp = this.comparatorOutput;
                this.comparatorOutput = this.updateComparatorOutput();
                if (lastComp != this.comparatorOutput) {
                    this.field_145850_b.func_175666_e(this.field_174879_c, (Block)JSGBlocks.BEAMER_BLOCK);
                }
                if (this.isLinked()) {
                    StargateClassicBaseTile gateTile = this.getLinkedGateTile();
                    if (gateTile != null) {
                        if (gateTile.getStargateState().engaged()) {
                            this.updateObstructed();
                        }
                    } else {
                        this.basePos = null;
                        this.func_70296_d();
                    }
                }
            }
            this.beamerStatus = this.updateBeamerStatus();
            if ((this.beamerStatus == BeamerStatusEnum.OK || this.beamerStatus == BeamerStatusEnum.OBSTRUCTED) && this.beamerMode != BeamerModeEnum.NONE && this.beamerRole != BeamerRoleEnum.DISABLED) {
                BeamerBeam.isSomethingInBeam(this, true, true);
            }
            if (this.beamerStatus == BeamerStatusEnum.OK && this.beamerRole == BeamerRoleEnum.TRANSMIT) {
                BeamerTile targetBeamerTile = (BeamerTile)this.targetBeamerWorld.func_175625_s(this.targetBeamerPos);
                switch (this.beamerMode) {
                    case POWER: {
                        int tx = this.energyStorage.extractEnergy(JSGConfig.Beamer.container.energyTransfer, true);
                        tx = targetBeamerTile.energyStorage.receiveEnergyInternal(tx, false);
                        this.energyStorage.extractEnergy(tx, false);
                        this.powerTransferredSinceLastSignal += tx;
                        break;
                    }
                    case FLUID: {
                        FluidStack fluid = this.fluidHandler.drainInternal(JSGConfig.Beamer.container.fluidTransfer, false);
                        int filled = targetBeamerTile.fluidHandler.fillInternal(fluid, true);
                        this.fluidHandler.drainInternal(filled, true);
                        if (filled <= 0) break;
                        int index = this.fluidsTransferredSinceLastSignal.indexOf(fluid);
                        if (index != -1) {
                            FluidStack fluidStack = this.fluidsTransferredSinceLastSignal.get(index);
                            fluidStack.amount += filled;
                            break;
                        }
                        this.fluidsTransferredSinceLastSignal.add(fluid.copy());
                        break;
                    }
                    case ITEMS: {
                        int toTransfer = JSGConfig.Beamer.container.itemTransfer;
                        for (int i = 1; i < 5; ++i) {
                            ItemStack stack = this.itemStackHandler.extractItem(i, toTransfer, true);
                            if (stack.func_190926_b()) continue;
                            for (int k = 1; k < 5; ++k) {
                                int accepted = stack.func_190916_E() - targetBeamerTile.itemStackHandler.insertItemInternal(k, stack.func_77946_l(), false).func_190916_E();
                                this.itemStackHandler.extractItem(i, accepted, false);
                                if (accepted > 0) {
                                    boolean found = false;
                                    for (ItemStack itemStack : this.itemsTransferredSinceLastSignal) {
                                        if (!itemStack.func_77969_a(stack)) continue;
                                        itemStack.func_190917_f(accepted);
                                        found = true;
                                        break;
                                    }
                                    if (!found) {
                                        ItemStack itemStack = stack.func_77946_l();
                                        itemStack.func_190920_e(accepted);
                                        this.itemsTransferredSinceLastSignal.add(itemStack);
                                    }
                                }
                                this.timeWithoutItemTransfer = 0;
                                stack.func_190918_g(accepted);
                                if (stack.func_190926_b() || (toTransfer -= accepted) == 0) break;
                            }
                            if (toTransfer == 0) break;
                        }
                        if (toTransfer != JSGConfig.Beamer.container.itemTransfer || this.field_145850_b.func_82737_E() % 20L != 0L) break;
                        ++this.timeWithoutItemTransfer;
                        break;
                    }
                    case LASER: {
                        int lx = this.energyStorage.extractEnergy(JSGConfig.Beamer.power.laserEnergy, false);
                        StargateClassicBaseTile gate = (StargateClassicBaseTile)this.targetGatePos.getTileEntity();
                        gate.tryHeatUp(true, true, 0.3, 0.6, 0.0, -1.0, -1.0);
                        this.powerTransferredSinceLastSignal += lx;
                        break;
                    }
                }
                if (this.field_145850_b.func_82737_E() % (long)JSGConfig.Beamer.mechanics.signalIntervalTicks == 0L) {
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    switch (this.beamerMode) {
                        case POWER: {
                            if (this.powerTransferredSinceLastSignal <= 0) break;
                            map.put("power", this.powerTransferredSinceLastSignal);
                            this.sendSignal(null, "beamer_transfers", map);
                            this.powerTransferredSinceLastSignal = 0;
                            break;
                        }
                        case FLUID: {
                            if (this.fluidsTransferredSinceLastSignal.isEmpty()) break;
                            for (FluidStack stack : this.fluidsTransferredSinceLastSignal) {
                                map.put(stack.getLocalizedName(), stack.amount);
                            }
                            this.sendSignal(null, "beamer_transfers", map);
                            this.fluidsTransferredSinceLastSignal.clear();
                            break;
                        }
                        case ITEMS: {
                            if (this.itemsTransferredSinceLastSignal.isEmpty()) break;
                            for (ItemStack stack : this.itemsTransferredSinceLastSignal) {
                                map.put(stack.func_82833_r(), stack.func_190916_E());
                            }
                            this.sendSignal(null, "beamer_transfers", map);
                            this.itemsTransferredSinceLastSignal.clear();
                            break;
                        }
                    }
                    this.func_70296_d();
                }
            }
            if (this.beamerRole == BeamerRoleEnum.RECEIVE) {
                block21: for (EnumFacing side : EnumFacing.values()) {
                    TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
                    if (tileEntity == null) continue;
                    switch (this.beamerMode) {
                        case POWER: {
                            if (!tileEntity.hasCapability(CapabilityEnergy.ENERGY, side.func_176734_d())) continue block21;
                            IEnergyStorage targetEnergyStorage = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d());
                            int tx = this.energyStorage.extractEnergy(JSGConfig.Beamer.container.energyTransfer, true);
                            tx = targetEnergyStorage.receiveEnergy(tx, false);
                            this.energyStorage.extractEnergy(tx, false);
                            continue block21;
                        }
                        case FLUID: {
                            if (!tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())) continue block21;
                            IFluidHandler targetFluidHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
                            FluidStack drained = this.fluidHandler.drain(JSGConfig.Beamer.container.fluidTransfer, false);
                            int filled = targetFluidHandler.fill(drained, true);
                            this.fluidHandler.drain(filled, true);
                            continue block21;
                        }
                        case ITEMS: {
                            if (this.beamerStatus == BeamerStatusEnum.OK && this.field_145850_b.func_82737_E() % 20L == 0L) {
                                ++this.timeWithoutItemTransfer;
                            }
                            if (!tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d())) continue block21;
                            IItemHandler targetItemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d());
                            int toTransfer = JSGConfig.Beamer.container.itemTransfer;
                            for (int i = 1; i < 5; ++i) {
                                ItemStack stack = this.itemStackHandler.extractItem(i, toTransfer, true);
                                if (stack.func_190926_b()) continue;
                                for (int k = 0; k < targetItemHandler.getSlots(); ++k) {
                                    int accepted = stack.func_190916_E() - targetItemHandler.insertItem(k, stack, false).func_190916_E();
                                    this.itemStackHandler.extractItem(i, accepted, false);
                                    if ((toTransfer -= accepted) == 0) break;
                                }
                                if (toTransfer == 0) continue block21;
                            }
                            continue block21;
                        }
                    }
                }
            }
            if (this.beamerMode == BeamerModeEnum.POWER || this.beamerMode == BeamerModeEnum.LASER) {
                this.energyTransferredLastTick = this.energyStorage.getEnergyStored() - this.energyStoredLastTick;
                this.energyStoredLastTick = this.energyStorage.getEnergyStored();
            }
            if (lastBeamerStatus != this.beamerStatus) {
                this.syncToClient();
                if (this.beamerStatus == BeamerStatusEnum.OK) {
                    this.sendSignal(null, "beamer_started", new Object[0]);
                    JSGSoundHelper.playSoundEvent(this.field_145850_b, this.field_174879_c, SoundEventEnum.BEAMER_START);
                    this.addTask(new ScheduledTask(EnumScheduledTask.BEAMER_TOGGLE_SOUND, 12));
                    this.sendRenderingAction(BeamerRendererAction.BEAM_ON);
                } else if (lastBeamerStatus == BeamerStatusEnum.OK) {
                    this.sendSignal(null, "beamer_stopped", new Object[0]);
                    JSGSoundHelper.playSoundEvent(this.field_145850_b, this.field_174879_c, SoundEventEnum.BEAMER_STOP);
                    this.addTask(new ScheduledTask(EnumScheduledTask.BEAMER_TOGGLE_SOUND, 12));
                    this.sendRenderingAction(BeamerRendererAction.BEAM_OFF);
                }
            }
        } else {
            float speed = 0.005f;
            if (this.beamRadiusShrink) {
                if (this.beamRadiusClient > 0.0f) {
                    this.beamRadiusClient -= speed;
                } else {
                    this.beamRadiusShrink = false;
                    this.beamRadiusClient = 0.0f;
                }
            } else if (this.beamRadiusWiden) {
                if (this.beamRadiusClient < 0.1375f) {
                    this.beamRadiusClient += speed;
                } else {
                    this.beamRadiusWiden = false;
                    this.beamRadiusClient = 0.1375f;
                }
            }
        }
    }

    private void syncToClient() {
        this.sendState(StateTypeEnum.RENDERER_STATE, this.getState(StateTypeEnum.RENDERER_STATE));
    }

    private void sendRenderingAction(BeamerRendererAction action) {
        this.sendState(StateTypeEnum.RENDERER_ACTION, new BeamerRendererActionState(action));
    }

    public void updateTargetBeamerData(@Nullable StargatePos targetGatePos) {
        boolean isLaser;
        boolean bl = isLaser = this.getMode() == BeamerModeEnum.LASER;
        if (isLaser) {
            this.targetBeamerWorld = this.field_145850_b;
            this.targetBeamerPos = this.field_174879_c;
            this.func_70296_d();
            return;
        }
        BlockPos remoteBeamerPos = this.findTargetBeamerPos(targetGatePos);
        if (remoteBeamerPos != null) {
            this.targetBeamerWorld = targetGatePos.getWorld();
            this.targetBeamerPos = remoteBeamerPos;
            BeamerTile remoteBeamerTile = (BeamerTile)this.targetBeamerWorld.func_175625_s(this.targetBeamerPos);
            if (remoteBeamerTile == null) {
                return;
            }
            remoteBeamerTile.targetBeamerWorld = this.field_145850_b;
            remoteBeamerTile.targetBeamerPos = this.field_174879_c;
        } else {
            this.targetBeamerWorld = null;
            this.targetBeamerPos = null;
        }
    }

    public void gateEngaged(StargatePos targetGatePos) {
        this.targetGatePos = targetGatePos;
        this.func_70296_d();
        this.updateTargetBeamerData(targetGatePos);
        this.syncToClient();
    }

    public void gateClosed() {
        this.clearTargetBeamerPos();
        this.targetGatePos = null;
        this.func_70296_d();
    }

    @Nullable
    private BlockPos findTargetBeamerPos(StargatePos targetGatePos) {
        if (targetGatePos == null) {
            return null;
        }
        World targetWorld = targetGatePos.getWorld();
        ArrayList<BlockPos> blacklist = new ArrayList<BlockPos>();
        int loop = 0;
        do {
            ++loop;
            BlockPos targetPos = this.getNearest(targetWorld, targetGatePos.gatePos, blacklist);
            if (targetPos == null) break;
            BeamerTile targetBeamer = (BeamerTile)targetWorld.func_175625_s(targetPos);
            if (targetBeamer == null || !targetBeamer.isLinked()) {
                blacklist.add(targetPos);
                continue;
            }
            if (targetBeamer.beamerMode.id != this.beamerMode.id) {
                blacklist.add(targetPos);
                continue;
            }
            if (targetBeamer.beamerMode.id == BeamerModeEnum.NONE.id) {
                blacklist.add(targetPos);
                continue;
            }
            if (targetBeamer.beamerRole.id == this.beamerRole.id) {
                blacklist.add(targetPos);
                continue;
            }
            if (targetBeamer.targetBeamerPos != null && !targetBeamer.targetBeamerPos.equals((Object)this.field_174879_c)) {
                blacklist.add(targetPos);
                continue;
            }
            if (!targetGatePos.gatePos.equals((Object)targetBeamer.basePos)) {
                blacklist.add(targetPos);
                continue;
            }
            return targetPos.func_185334_h();
        } while (loop < 100);
        return null;
    }

    public BlockPos getNearest(World world, BlockPos pos, ArrayList<BlockPos> blacklist) {
        Block[] blocks = new Block[]{JSGBlocks.BEAMER_BLOCK};
        return LinkingHelper.findClosestPos(world, pos, new BlockPos(JSGConfig.Beamer.mechanics.reach, JSGConfig.Beamer.mechanics.reach, JSGConfig.Beamer.mechanics.reach), blocks, blacklist);
    }

    public void clearTargetBeamerPos() {
        BeamerTile targetBeamerTile;
        if (this.targetBeamerPos != null && (targetBeamerTile = (BeamerTile)this.targetBeamerWorld.func_175625_s(this.targetBeamerPos)) != null) {
            targetBeamerTile.targetBeamerPos = null;
        }
    }

    public BeamerModeEnum getMode() {
        return this.beamerMode;
    }

    public BeamerRoleEnum getRole() {
        return this.beamerRole;
    }

    public BeamerStatusEnum getStatus() {
        return this.beamerStatus;
    }

    public int getComparatorOutput() {
        return this.comparatorOutput;
    }

    public RedstoneModeEnum getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneModeEnum redstoneMode) {
        this.redstoneMode = redstoneMode;
        this.ocLocked = false;
        this.func_70296_d();
    }

    public void setStartStop(int start, int stop) {
        this.start = start;
        this.stop = stop;
        this.func_70296_d();
    }

    public int getStart() {
        return this.start;
    }

    public int getStop() {
        return this.stop;
    }

    public void setInactivity(int inactivity) {
        this.inactivity = inactivity;
        this.func_70296_d();
    }

    public int getInactivity() {
        return this.inactivity;
    }

    public boolean isActive() {
        return this.beamerStatus == BeamerStatusEnum.OK;
    }

    public void setNextRole() {
        this.beamerRole = this.beamerRole.next();
        this.func_70296_d();
    }

    public void updateObstructed() {
        if (this.basePos == null) {
            return;
        }
        this.isObstructed = ((StargateClassicBaseTile)Objects.requireNonNull(this.field_145850_b.func_175625_s(this.basePos))).isIrisClosed() || BeamerBeam.isSomethingInBeam(this, false, false);
        this.func_70296_d();
    }

    public int updateComparatorOutput() {
        switch (this.beamerMode) {
            case POWER: {
                return ComparatorHelper.getComparatorLevel((IEnergyStorage)this.energyStorage);
            }
            case FLUID: {
                return ComparatorHelper.getComparatorLevel(this.fluidHandler);
            }
            case ITEMS: {
                return ComparatorHelper.getComparatorLevel((IItemHandler)this.itemStackHandler, 1);
            }
        }
        return 0;
    }

    public boolean isLinked() {
        return this.basePos != null;
    }

    public BlockPos getLinkedGate() {
        return this.basePos;
    }

    public StargateClassicBaseTile getLinkedGateTile() {
        return (StargateClassicBaseTile)this.field_145850_b.func_175625_s(this.basePos);
    }

    public void setLinkedGate(BlockPos basePos, BlockPos baseVect) {
        if (basePos == null || baseVect == null) {
            this.basePos = null;
            this.baseVect = null;
        } else {
            this.basePos = basePos.func_185334_h();
            this.baseVect = baseVect.func_185334_h();
        }
        this.func_70296_d();
    }

    private void updateMode() {
        this.beamerMode = BeamerTile.getModeFromItem(this.itemStackHandler.getStackInSlot(0).func_77973_b());
        this.func_70296_d();
        this.syncToClient();
    }

    @Override
    public Iterator<Integer> getUpgradeSlotsIterator() {
        return Iterators.singletonIterator((Object)0);
    }

    public static BeamerModeEnum getModeFromItem(Item crystal) {
        if (crystal == JSGItems.BEAMER_CRYSTAL_POWER) {
            return BeamerModeEnum.POWER;
        }
        if (crystal == JSGItems.BEAMER_CRYSTAL_FLUID) {
            return BeamerModeEnum.FLUID;
        }
        if (crystal == JSGItems.BEAMER_CRYSTAL_ITEMS) {
            return BeamerModeEnum.ITEMS;
        }
        if (crystal == JSGItems.BEAMER_CRYSTAL_LASER) {
            return BeamerModeEnum.LASER;
        }
        return BeamerModeEnum.NONE;
    }

    public int getEnergyTransferredLastTick() {
        return this.energyTransferredLastTick;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (facing != this.facing) {
            return this.beamerMode == BeamerModeEnum.ITEMS && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || (this.beamerMode == BeamerModeEnum.POWER || this.beamerMode == BeamerModeEnum.LASER) && capability == CapabilityEnergy.ENERGY || this.beamerMode == BeamerModeEnum.FLUID && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != this.facing) {
            if ((this.beamerMode == BeamerModeEnum.ITEMS || facing == null) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemStackHandler);
            }
            if ((this.beamerMode == BeamerModeEnum.POWER || facing == null || this.beamerMode == BeamerModeEnum.LASER) && capability == CapabilityEnergy.ENERGY) {
                return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyStorage);
            }
            if ((this.beamerMode == BeamerModeEnum.FLUID || facing == null) && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidHandler);
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void addTask(ScheduledTask scheduledTask) {
        scheduledTask.setExecutor(this);
        scheduledTask.setTaskCreated(this.field_145850_b.func_82737_E());
        this.scheduledTasks.add(scheduledTask);
        this.func_70296_d();
    }

    @Override
    public void executeTask(EnumScheduledTask scheduledTask, NBTTagCompound customData) {
        if (scheduledTask == EnumScheduledTask.BEAMER_TOGGLE_SOUND) {
            JSGSoundHelper.playPositionedSound(this.field_145850_b, this.field_174879_c, SoundPositionedEnum.BEAMER_LOOP, this.isActive());
            this.loopSoundPlaying ^= true;
            this.func_70296_d();
        }
    }

    protected void sendState(StateTypeEnum type, State state) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.targetPoint != null) {
            JSGPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, type, state), this.targetPoint);
        } else {
            JSG.debug("targetPoint was null trying to send " + (Object)((Object)type) + " from " + this.getClass().getCanonicalName());
        }
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_UPDATE: {
                return new BeamerRendererUpdate(this.beamerStatus);
            }
            case RENDERER_STATE: {
                int distance = 0;
                int d1 = 0;
                int d2 = 0;
                if (this.baseVect != null) {
                    BeamerTile tile;
                    d1 = this.baseVect.func_177952_p();
                    if (d1 < 0) {
                        d1 = -d1;
                    }
                    if (this.targetBeamerWorld != null && this.targetBeamerPos != null && (tile = (BeamerTile)this.targetBeamerWorld.func_175625_s(this.targetBeamerPos)) != null && tile.isLinked() && tile.basePos != null && tile.baseVect != null) {
                        d2 = tile.baseVect.func_177952_p();
                        if (d2 < 0) {
                            d2 = -d2;
                        }
                        EnumFacing.Axis ax1 = ((EnumFacing)this.targetBeamerWorld.func_180495_p(tile.basePos).func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL)).func_176740_k();
                        EnumFacing.Axis ax2 = ((EnumFacing)this.field_145850_b.func_180495_p(this.basePos).func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL)).func_176740_k();
                        int x1 = ax1 == EnumFacing.Axis.Z ? tile.basePos.func_177958_n() - tile.func_174877_v().func_177958_n() : tile.basePos.func_177952_p() - tile.func_174877_v().func_177952_p();
                        int x2 = ax2 == EnumFacing.Axis.Z ? this.basePos.func_177958_n() - this.func_174877_v().func_177958_n() : this.basePos.func_177952_p() - this.func_174877_v().func_177952_p();
                        this.beamOffsetFromTargetX = x1 - x2;
                        int y1 = tile.basePos.func_177956_o() - tile.func_174877_v().func_177956_o();
                        int y2 = this.basePos.func_177956_o() - this.func_174877_v().func_177956_o();
                        this.beamOffsetFromTargetY = y1 - y2;
                        this.func_70296_d();
                    }
                    if (this.beamerMode == BeamerModeEnum.LASER) {
                        EnumFacing.Axis ax2 = ((EnumFacing)this.field_145850_b.func_180495_p(this.basePos).func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL)).func_176740_k();
                        int x1 = 0;
                        int x2 = ax2 == EnumFacing.Axis.Z ? this.basePos.func_177958_n() - this.func_174877_v().func_177958_n() : this.basePos.func_177952_p() - this.func_174877_v().func_177952_p();
                        this.beamOffsetFromTargetX = x1 - x2;
                        int y1 = this.basePos.func_177956_o() - this.getLinkedGateTile().getGateCenterPos().func_177956_o();
                        int y2 = this.basePos.func_177956_o() - this.func_174877_v().func_177956_o();
                        this.beamOffsetFromTargetY = y1 - y2;
                        this.func_70296_d();
                    }
                    distance = d1 + d2;
                    this.beamOffsetFromGateTarget = d2;
                    this.beamOffsetFromTargetZ = distance;
                    this.func_70296_d();
                }
                return new BeamerRendererState(this.beamerMode, this.beamerRole, this.beamerStatus, this.isObstructed, this.beamOffsetFromTargetZ, this.beamOffsetFromGateTarget, this.beamOffsetFromTargetX, this.beamOffsetFromTargetY);
            }
            case GUI_UPDATE: {
                return new BeamerContainerGuiUpdate(this.energyStorage.getEnergyStored(), this.energyTransferredLastTick, this.fluidHandler.getFluid(), this.beamerRole, this.redstoneMode, this.start, this.stop, this.inactivity);
            }
            case BEAMER_FLUID_UPDATE: {
                FluidStack fluidStack = this.fluidHandler.getFluid();
                return new BeamerFluidUpdate(fluidStack != null ? fluidStack.getFluid() : null);
            }
        }
        return null;
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_ACTION: {
                return new BeamerRendererActionState();
            }
            case RENDERER_STATE: {
                return new BeamerRendererState();
            }
            case RENDERER_UPDATE: {
                return new BeamerRendererUpdate();
            }
            case GUI_UPDATE: {
                return new BeamerContainerGuiUpdate();
            }
            case BEAMER_FLUID_UPDATE: {
                return new BeamerFluidUpdate();
            }
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setState(StateTypeEnum stateType, State state) {
        switch (stateType) {
            case RENDERER_STATE: {
                BeamerRendererState rendererState = (BeamerRendererState)state;
                this.beamerMode = rendererState.beamerMode;
                this.beamerRole = rendererState.beamerRole;
                this.beamerStatus = rendererState.beamerStatus;
                this.isObstructed = rendererState.isObstructed;
                this.beamOffsetFromTargetZ = rendererState.beamLength;
                this.beamOffsetFromGateTarget = rendererState.beamLengthTarget;
                this.beamOffsetFromTargetX = rendererState.beamOffsetFromTargetXClient;
                this.beamOffsetFromTargetY = rendererState.beamOffsetFromTargetYClient;
                this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
                break;
            }
            case RENDERER_UPDATE: {
                BeamerRendererUpdate update = (BeamerRendererUpdate)state;
                this.beamRadiusClient = update.beamerStatus == BeamerStatusEnum.OK ? 0.1375f : 0.0f;
                JSGSoundHelperClient.playPositionedSoundClientSide(this.field_174879_c, SoundPositionedEnum.BEAMER_LOOP, update.beamerStatus == BeamerStatusEnum.OK);
                break;
            }
            case RENDERER_ACTION: {
                BeamerRendererActionState rendererAction = (BeamerRendererActionState)state;
                switch (rendererAction.action) {
                    case BEAM_ON: {
                        this.beamRadiusClient = 0.0f;
                        this.beamRadiusWiden = true;
                        this.beamRadiusShrink = false;
                        break;
                    }
                    case BEAM_OFF: {
                        this.beamRadiusClient = 0.1375f;
                        this.beamRadiusWiden = false;
                        this.beamRadiusShrink = true;
                    }
                }
                break;
            }
            case GUI_UPDATE: {
                BeamerContainerGuiUpdate guiUpdate = (BeamerContainerGuiUpdate)state;
                this.energyStorage.setEnergyStored(guiUpdate.energyStored);
                this.energyTransferredLastTick = guiUpdate.transferredLastTick;
                this.fluidHandler.setFluid(guiUpdate.fluidStack);
                this.beamerRole = guiUpdate.beamerRole;
                this.redstoneMode = guiUpdate.mode;
                this.start = guiUpdate.start;
                this.stop = guiUpdate.stop;
                this.inactivity = guiUpdate.inactivity;
                GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
                if (!(screen instanceof BeamerContainerGui)) break;
                ((BeamerContainerGui)screen).updateStartStopInactivity();
                break;
            }
            case BEAMER_FLUID_UPDATE: {
                BeamerFluidUpdate fluidUpdate = (BeamerFluidUpdate)state;
                this.lastFluidTransferred = fluidUpdate.fluidContained;
                JSG.debug("Received beamer fluid update: " + this.lastFluidTransferred);
                break;
            }
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        if (this.baseVect != null && this.basePos != null) {
            compound.func_74772_a("baseVect", this.baseVect.func_177986_g());
            compound.func_74772_a("basePos", this.basePos.func_177986_g());
        }
        compound.func_74782_a("itemStackHandler", (NBTBase)this.itemStackHandler.serializeNBT());
        compound.func_74782_a("energyStorage", (NBTBase)this.energyStorage.serializeNBT());
        NBTTagCompound fluidHandlerCompound = new NBTTagCompound();
        this.fluidHandler.writeToNBT(fluidHandlerCompound);
        compound.func_74782_a("fluidHandler", (NBTBase)fluidHandlerCompound);
        compound.func_74768_a("beamerMode", this.beamerMode.getKey().intValue());
        compound.func_74768_a("beamerRole", this.beamerRole.getKey().intValue());
        compound.func_74768_a("redstoneMode", this.redstoneMode.getKey().intValue());
        compound.func_74768_a("start", this.start);
        compound.func_74768_a("stop", this.stop);
        compound.func_74768_a("inactivity", this.inactivity);
        compound.func_74757_a("ocLocked", this.ocLocked);
        compound.func_74757_a("loopSoundPlaying", this.loopSoundPlaying);
        compound.func_74782_a("scheduledTasks", (NBTBase)ScheduledTask.serializeList(this.scheduledTasks));
        if (this.node != null) {
            NBTTagCompound nodeCompound = new NBTTagCompound();
            this.node.save(nodeCompound);
            compound.func_74782_a("node", (NBTBase)nodeCompound);
        }
        compound.func_74768_a("powerTransferredSinceLastSignal", this.powerTransferredSinceLastSignal);
        compound.func_74782_a("fluidsTransferredSinceLastSignal", (NBTBase)NBTHelper.serializeFluidStackList(this.fluidsTransferredSinceLastSignal));
        compound.func_74782_a("itemsTransferredSinceLastSignal", (NBTBase)NBTHelper.serializeItemStackList(this.itemsTransferredSinceLastSignal));
        if (this.targetGatePos != null) {
            compound.func_74768_a("targetGatePosSymbolType", this.targetGatePos.symbolType.id);
            compound.func_74782_a("targetGatePos", (NBTBase)this.targetGatePos.serializeNBT());
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("baseVect") && compound.func_74764_b("basePos")) {
            this.baseVect = BlockPos.func_177969_a((long)compound.func_74763_f("baseVect"));
            this.basePos = BlockPos.func_177969_a((long)compound.func_74763_f("basePos"));
        }
        this.itemStackHandler.deserializeNBT(compound.func_74775_l("itemStackHandler"));
        this.energyStorage.deserializeNBT(compound.func_74775_l("energyStorage"));
        this.fluidHandler.readFromNBT(compound.func_74775_l("fluidHandler"));
        this.beamerMode = BeamerModeEnum.valueOf(compound.func_74762_e("beamerMode"));
        this.beamerRole = BeamerRoleEnum.valueOf(compound.func_74762_e("beamerRole"));
        this.redstoneMode = RedstoneModeEnum.valueOf(compound.func_74762_e("redstoneMode"));
        this.start = compound.func_74762_e("start");
        this.stop = compound.func_74762_e("stop");
        this.inactivity = compound.func_74762_e("inactivity");
        this.ocLocked = compound.func_74767_n("ocLocked");
        this.loopSoundPlaying = compound.func_74767_n("loopSoundPlaying");
        this.powerTransferredSinceLastSignal = compound.func_74762_e("powerTransferredSinceLastSignal");
        this.fluidsTransferredSinceLastSignal.clear();
        this.itemsTransferredSinceLastSignal.clear();
        NBTHelper.deserializeFluidStackList(compound.func_150295_c("fluidsTransferredSinceLastSignal", 10), this.fluidsTransferredSinceLastSignal);
        NBTHelper.deserializeItemStackList(compound.func_150295_c("itemsTransferredSinceLastSignal", 10), this.itemsTransferredSinceLastSignal);
        if (this.node != null && compound.func_74764_b("node")) {
            this.node.load(compound.func_74775_l("node"));
        }
        ScheduledTask.deserializeList(compound.func_74775_l("scheduledTasks"), this.scheduledTasks, this);
        if (compound.func_74764_b("targetGatePos")) {
            SymbolTypeEnum symbolType = SymbolTypeEnum.valueOf(compound.func_74762_e("targetGatePosSymbolType"));
            this.targetGatePos = new StargatePos(symbolType, compound.func_74775_l("targetGatePos"));
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.renderBoxOffsetted;
    }

    public double func_145833_n() {
        return 65536.0;
    }

    public void onChunkUnload() {
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void func_145843_s() {
        if (this.node != null) {
            this.node.remove();
        }
        super.func_145843_s();
    }

    @Optional.Method(modid="opencomputers")
    public Node node() {
        return this.node;
    }

    @Optional.Method(modid="opencomputers")
    public void onConnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onDisconnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onMessage(Message message) {
    }

    public void sendSignal(Object context, String name, Object ... params) {
        JSG.ocWrapper.sendSignalToReachable(this.node, (Context)context, name, params);
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getJSGVersion(Context context, Arguments args) {
        return new Object[]{"1.12.2-4.11.0.8"};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] isActive(Context context, Arguments args) {
        return new Object[]{this.isActive()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] setActive(Context context, Arguments args) {
        this.ocLocked = !args.checkBoolean(0);
        this.func_70296_d();
        return new Object[0];
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] start(Context context, Arguments args) {
        this.ocLocked = false;
        this.func_70296_d();
        return new Object[0];
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] stop(Context context, Arguments args) {
        this.ocLocked = true;
        this.func_70296_d();
        return new Object[0];
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getBeamerMode(Context context, Arguments args) {
        return new Object[]{this.beamerMode.toString().toLowerCase()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getBeamerRole(Context context, Arguments args) {
        return new Object[]{this.beamerRole.toString().toLowerCase()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] setBeamerRole(Context context, Arguments args) {
        try {
            this.beamerRole = BeamerRoleEnum.valueOf(args.checkString(0).toUpperCase());
            this.func_70296_d();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Wrong Role name");
        }
        return new Object[0];
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getBeamerRedstoneMode(Context context, Arguments args) {
        return new Object[]{this.redstoneMode.toString().toLowerCase()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] setBeamerRedstoneMode(Context context, Arguments args) {
        try {
            this.redstoneMode = RedstoneModeEnum.valueOf(args.checkString(0).toUpperCase());
            this.func_70296_d();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Wrong Mode name");
        }
        return new Object[0];
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] toggleBeamerRole(Context context, Arguments args) {
        switch (this.beamerRole) {
            case RECEIVE: {
                this.beamerRole = BeamerRoleEnum.TRANSMIT;
                return new Object[]{this.beamerRole.toString().toLowerCase()};
            }
            case TRANSMIT: {
                this.beamerRole = BeamerRoleEnum.RECEIVE;
                return new Object[]{this.beamerRole.toString().toLowerCase()};
            }
            case DISABLED: {
                return new Object[]{"err_beamer_disabled"};
            }
        }
        return null;
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getBeamerStatus(Context context, Arguments args) {
        return new Object[]{this.beamerStatus.toString().toLowerCase()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getBufferStored(Context context, Arguments args) {
        switch (this.beamerMode) {
            case POWER: {
                return new Object[]{this.energyStorage.getEnergyStored()};
            }
            case FLUID: {
                return new Object[]{this.fluidHandler.getFluidAmount(), this.fluidHandler.getFluid() != null ? JSG.proxy.localize(this.fluidHandler.getFluid().getFluid().getUnlocalizedName(), new Object[0]) : null};
            }
            case ITEMS: {
                ArrayList<AbstractMap.SimpleEntry<String, Integer>> stackList = new ArrayList<AbstractMap.SimpleEntry<String, Integer>>(4);
                for (int i = 1; i < 5; ++i) {
                    ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                    stackList.add(new AbstractMap.SimpleEntry<String, Integer>(stack.func_82833_r(), stack.func_190916_E()));
                }
                return new Object[]{stackList};
            }
        }
        return new Object[]{"no_mode_set"};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getBufferCapacity(Context context, Arguments args) {
        switch (this.beamerMode) {
            case POWER: {
                return new Object[]{this.energyStorage.getMaxEnergyStored()};
            }
            case FLUID: {
                return new Object[]{this.fluidHandler.getCapacity()};
            }
            case ITEMS: {
                ArrayList<AbstractMap.SimpleEntry<String, Integer>> stackList = new ArrayList<AbstractMap.SimpleEntry<String, Integer>>(4);
                for (int i = 1; i < 5; ++i) {
                    ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                    stackList.add(new AbstractMap.SimpleEntry<String, Integer>(stack.func_82833_r(), stack.func_77976_d()));
                }
                return new Object[]{stackList};
            }
        }
        return new Object[]{"no_mode_set"};
    }

    private class ItemStackHandlerBeamer
    extends ItemStackHandler {
        public ItemStackHandlerBeamer(int slots) {
            super(slots);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            Item item = stack.func_77973_b();
            if (slot == 0) {
                return JSGItems.BEAMER_CRYSTAL_POWER.equals(item) || JSGItems.BEAMER_CRYSTAL_FLUID.equals(item) || JSGItems.BEAMER_CRYSTAL_ITEMS.equals(item) || JSGItems.BEAMER_CRYSTAL_LASER.equals(item);
            }
            return true;
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            if (slot == 0) {
                return 1;
            }
            return super.getStackLimit(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (!((BeamerTile)BeamerTile.this).field_145850_b.field_72995_K && slot == 0) {
                BeamerTile.this.updateMode();
            }
            BeamerTile.this.func_70296_d();
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack stack = super.extractItem(slot, amount, simulate);
            if (!((BeamerTile)BeamerTile.this).field_145850_b.field_72995_K && slot == 0 && !simulate) {
                BeamerTile.this.updateMode();
            }
            return stack;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (BeamerTile.this.beamerRole != BeamerRoleEnum.TRANSMIT && slot != 0) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack insertItemInternal(int slot, ItemStack stack, boolean simulate) {
            BeamerTile.this.timeWithoutItemTransfer = 0;
            return super.insertItem(slot, stack, simulate);
        }
    }
}

