/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.tileentity.energy;

import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import tauri.dev.jsg.capability.CapabilityEnergyZPM;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.StateUpdatePacketToClient;
import tauri.dev.jsg.packet.StateUpdateRequestToServer;
import tauri.dev.jsg.power.zpm.ZPMEnergyStorage;
import tauri.dev.jsg.renderer.zpm.ZPMRenderer;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.state.StateProviderInterface;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.state.energy.CapacitorPowerLevelUpdate;
import tauri.dev.jsg.tileentity.energy.ZPMHubTile;

public class ZPMTile
extends TileEntity
implements ITickable,
ICapabilityProvider,
StateProviderInterface {
    private final ZPMEnergyStorage energyStorage;
    protected long energyStoredLastTick;
    protected long energyTransferedLastTick;
    private NetworkRegistry.TargetPoint targetPoint;
    private int powerLevel;
    private int lastPowerLevel;
    public boolean isCorrupted;

    public ZPMTile() {
        this.energyStorage = new ZPMEnergyStorage((long)JSGConfig.ZPM.power.zpmCapacity, JSGConfig.ZPM.power.zpmHubMaxEnergyTransfer / 3){

            @Override
            protected void onEnergyChanged() {
                ZPMTile.this.func_70296_d();
            }
        };
        this.energyStoredLastTick = 0L;
        this.energyTransferedLastTick = 0L;
        this.isCorrupted = false;
    }

    public NetworkRegistry.TargetPoint getTargetPoint() {
        return this.targetPoint;
    }

    public int getPowerLevel() {
        return this.powerLevel;
    }

    public ZPMEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            this.targetPoint = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 512.0);
        } else {
            JSGPacketHandler.INSTANCE.sendToServer((IMessage)new StateUpdateRequestToServer(this.field_174879_c, StateTypeEnum.RENDERER_UPDATE));
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.powerLevel = ZPMHubTile.getZPMPowerLevel(this.getEnergyStorage().getEnergyStored(), this.getEnergyStorage().getMaxEnergyStored());
            if (this.powerLevel != this.lastPowerLevel) {
                JSGPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.RENDERER_UPDATE, this.getState(StateTypeEnum.RENDERER_UPDATE)), this.targetPoint);
                this.lastPowerLevel = this.powerLevel;
            }
            this.energyTransferedLastTick = this.getEnergyStorage().getEnergyStored() - this.energyStoredLastTick;
            this.energyStoredLastTick = this.getEnergyStorage().getEnergyStored();
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("energyStorage", (NBTBase)this.getEnergyStorage().serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.getEnergyStorage().deserializeNBT(compound.func_74775_l("energyStorage"));
        super.func_145839_a(compound);
    }

    public long getEnergyTransferedLastTick() {
        return this.energyTransferedLastTick;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return facing == null && capability == CapabilityEnergyZPM.ENERGY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (facing == null && capability == CapabilityEnergyZPM.ENERGY) {
            return (T)CapabilityEnergyZPM.ENERGY.cast((Object)this.getEnergyStorage());
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        if (stateType == StateTypeEnum.RENDERER_UPDATE) {
            return new CapacitorPowerLevelUpdate(this.powerLevel);
        }
        return null;
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        if (stateType == StateTypeEnum.RENDERER_UPDATE) {
            return new CapacitorPowerLevelUpdate();
        }
        return null;
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        if (stateType == StateTypeEnum.RENDERER_UPDATE) {
            this.powerLevel = ((CapacitorPowerLevelUpdate)state).powerLevel;
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    public ZPMRenderer.ZPMModelType getType() {
        if (this.isCorrupted) {
            return ZPMRenderer.ZPMModelType.EXPLOSIVE;
        }
        return ZPMRenderer.ZPMModelType.NORMAL;
    }
}

