/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.tileentity.props;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.block.JSGBlocks;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.config.ingame.ITileConfig;
import tauri.dev.jsg.config.ingame.ITileConfigEntry;
import tauri.dev.jsg.config.ingame.JSGConfigEnumEntry;
import tauri.dev.jsg.config.ingame.JSGConfigOption;
import tauri.dev.jsg.config.ingame.JSGConfigOptionTypeEnum;
import tauri.dev.jsg.config.ingame.JSGTileEntityConfig;
import tauri.dev.jsg.gui.container.countdown.CountDownContainerGuiUpdate;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.StateUpdatePacketToClient;
import tauri.dev.jsg.packet.StateUpdateRequestToServer;
import tauri.dev.jsg.renderer.props.DestinyCountDownRendererState;
import tauri.dev.jsg.sound.JSGSoundHelper;
import tauri.dev.jsg.sound.SoundEventEnum;
import tauri.dev.jsg.stargate.EnumStargateState;
import tauri.dev.jsg.stargate.NearbyGate;
import tauri.dev.jsg.stargate.StargateClosedReasonEnum;
import tauri.dev.jsg.stargate.network.StargateAddress;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.state.StateProviderInterface;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.tileentity.stargate.StargateUniverseBaseTile;
import tauri.dev.jsg.tileentity.util.PreparableInterface;
import tauri.dev.jsg.util.ILinkable;
import tauri.dev.jsg.util.LinkingHelper;

@Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="opencomputers")
public class DestinyCountDownTile
extends TileEntity
implements ICapabilityProvider,
ITickable,
Environment,
StateProviderInterface,
ILinkable,
PreparableInterface,
ITileConfig {
    public long countdownTo = -1L;
    private long countStart = -1L;
    private boolean gateOpenedThisRound = false;
    private boolean addedToNetwork = false;
    protected NetworkRegistry.TargetPoint targetPoint;
    public DestinyCountDownRendererState rendererState = new DestinyCountDownRendererState();
    private boolean isClientUpdated = false;
    private BlockPos gatePos;
    private int linkId = -1;
    protected JSGTileEntityConfig config = new JSGTileEntityConfig();
    private final Node node = JSG.ocWrapper.createNode(this, "countdown");

    public long getCountdownTicks() {
        if (this.countdownTo == -1L) {
            return 0L;
        }
        return this.countdownTo - this.field_145850_b.func_82737_E();
    }

    public void setCountDown(long countToTime) {
        this.countdownTo = countToTime;
        this.countStart = this.field_145850_b.func_82737_E();
        this.gateOpenedThisRound = false;
        this.func_70296_d();
        if (this.getCountdownTicks() > 0L) {
            this.playSound(EnumCountDownEventType.START);
            this.sendSignal(null, "countdown_start", this.getCountdownTicks());
        }
        this.sendState(StateTypeEnum.RENDERER_UPDATE, this.getState(StateTypeEnum.RENDERER_UPDATE));
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            this.targetPoint = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 512.0);
            this.func_70296_d();
            this.updateLinkStatus();
            this.sendState(StateTypeEnum.RENDERER_UPDATE, this.getState(StateTypeEnum.RENDERER_UPDATE));
        } else {
            this.isClientUpdated = false;
            this.func_70296_d();
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            NearbyGate found;
            EnumStargateState state;
            StargateUniverseBaseTile gate;
            long i;
            this.initConfig();
            if (!this.addedToNetwork) {
                this.addedToNetwork = true;
                JSG.ocWrapper.joinOrCreateNetwork(this);
            }
            if (this.targetPoint == null) {
                this.targetPoint = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 512.0);
                this.func_70296_d();
            }
            if ((i = this.getCountdownTicks()) < -(20L * (long)JSGConfig.General.countdownConfig.zeroDelay)) {
                this.countdownTo = -1L;
                this.func_70296_d();
                this.sendSignal(null, "countdown_reset", i);
                this.sendState(StateTypeEnum.RENDERER_UPDATE, this.getState(StateTypeEnum.RENDERER_UPDATE));
            }
            if (this.getConfig().getOption(ConfigOptions.ENABLE_GATE_OPENING.id).getBooleanValue() && !this.gateOpenedThisRound && i > 1300L && this.field_145850_b.func_82737_E() - this.countStart > 20L * (long)JSGConfig.General.countdownConfig.dialStartDelay && this.field_145850_b.func_82737_E() % 40L == 0L && this.isLinked() && (gate = this.getLinkedGate(this.field_145850_b)) != null && (state = gate.getStargateState()).idle() && gate.isMerged() && (found = gate.getRandomNearbyGate()) != null) {
                StargateAddress foundAddress = found.address;
                int symbols = found.symbolsNeeded - 1;
                if (foundAddress != null) {
                    gate.dialAddress(foundAddress, symbols);
                    this.gateOpenedThisRound = true;
                    this.func_70296_d();
                }
            }
            if (this.countdownTo != -1L) {
                if (i == 0L) {
                    this.playSound(EnumCountDownEventType.ZERO);
                    this.sendSignal(null, "countdown_zero", 0);
                    this.gateOpenedThisRound = false;
                    this.func_70296_d();
                    if (this.getConfig().getOption(ConfigOptions.ENABLE_GATE_CLOSING.id).getBooleanValue() && this.isLinked() && (gate = this.getLinkedGate(this.field_145850_b)) != null) {
                        state = gate.getStargateState();
                        if (state.unstable() || state.incoming() || state.engaged()) {
                            gate.attemptClose(StargateClosedReasonEnum.AUTOCLOSE);
                        } else if (!state.idle()) {
                            gate.abortDialingSequence();
                        }
                    }
                }
                if (i == 1200L) {
                    this.playSound(EnumCountDownEventType.ONE_MINUTE);
                    this.sendSignal(null, "countdown_one_minute", this.getCountdownTicks());
                } else if (i == 200L) {
                    this.sendSignal(null, "countdown_ten_seconds", this.getCountdownTicks());
                } else if (i % 1200L == 0L) {
                    this.sendSignal(null, "countdown_minute_pass", this.getCountdownTicks());
                }
            }
        } else if (!this.isClientUpdated && this.getCountdownTicks() <= 0L) {
            this.isClientUpdated = true;
            this.func_70296_d();
            JSGPacketHandler.INSTANCE.sendToServer((IMessage)new StateUpdateRequestToServer(this.field_174879_c, StateTypeEnum.RENDERER_UPDATE));
        }
    }

    public void playSound(EnumCountDownEventType type) {
        switch (type) {
            case START: {
                JSGSoundHelper.playSoundEvent(this.field_145850_b, this.field_174879_c, SoundEventEnum.DESTINY_COUNTDOWN_START);
                break;
            }
            case ZERO: {
                JSGSoundHelper.playSoundEvent(this.field_145850_b, this.field_174879_c, SoundEventEnum.DESTINY_COUNTDOWN_STOP);
                break;
            }
            case ONE_MINUTE: {
                JSGSoundHelper.playSoundEvent(this.field_145850_b, this.field_174879_c, SoundEventEnum.DESTINY_COUNTDOWN_ONE_MINUTE);
                break;
            }
        }
    }

    protected void sendState(StateTypeEnum type, State state) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.targetPoint != null) {
            JSGPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, type, state), this.targetPoint);
        } else {
            JSG.debug("targetPoint was null trying to send " + (Object)((Object)type) + " from " + this.getClass().getCanonicalName());
        }
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_UPDATE: {
                return new DestinyCountDownRendererState(this.countdownTo, this.getConfig());
            }
            case GUI_STATE: 
            case GUI_UPDATE: {
                return new CountDownContainerGuiUpdate(this.getConfig());
            }
        }
        return null;
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_UPDATE: {
                return new DestinyCountDownRendererState();
            }
            case GUI_STATE: 
            case GUI_UPDATE: {
                return new CountDownContainerGuiUpdate();
            }
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setState(StateTypeEnum stateType, State state) {
        switch (stateType) {
            case RENDERER_UPDATE: {
                this.rendererState = (DestinyCountDownRendererState)state;
                this.countdownTo = this.rendererState.countdownTo;
                this.config = this.rendererState.config;
                break;
            }
            case GUI_STATE: 
            case GUI_UPDATE: {
                CountDownContainerGuiUpdate guiState = (CountDownContainerGuiUpdate)state;
                this.config = guiState.config;
                break;
            }
        }
        this.func_70296_d();
    }

    public DestinyCountDownRendererState getRendererState() {
        return this.rendererState;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        compound.func_74772_a("countdown", this.countdownTo);
        compound.func_74757_a("gateOpenedThisRound", this.gateOpenedThisRound);
        if (this.isLinked()) {
            compound.func_74772_a("linkedGate", this.gatePos.func_177986_g());
            compound.func_74768_a("linkId", this.linkId);
        }
        if (this.node != null) {
            NBTTagCompound nodeCompound = new NBTTagCompound();
            this.node.save(nodeCompound);
            compound.func_74782_a("node", (NBTBase)nodeCompound);
        }
        compound.func_74782_a("config", (NBTBase)this.config.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        this.countdownTo = compound.func_74763_f("countdown");
        this.gateOpenedThisRound = compound.func_74767_n("gateOpenedThisRound");
        if (compound.func_74764_b("linkedGate")) {
            this.gatePos = BlockPos.func_177969_a((long)compound.func_74763_f("linkedGate"));
        }
        if (compound.func_74764_b("linkId")) {
            this.linkId = compound.func_74762_e("linkId");
        }
        if (this.node != null && compound.func_74764_b("node")) {
            this.node.load(compound.func_74775_l("node"));
        }
        this.config.deserializeNBT(compound.func_74775_l("config"));
        this.func_70296_d();
        super.func_145839_a(compound);
    }

    @Override
    public boolean canLinkTo() {
        return !this.isLinked() && this.getConfig().getOption(ConfigOptions.ENABLE_GATE_LINK.id).getBooleanValue();
    }

    @Nullable
    public StargateUniverseBaseTile getLinkedGate(World world) {
        if (this.gatePos == null) {
            return null;
        }
        return (StargateUniverseBaseTile)world.func_175625_s(this.gatePos);
    }

    public boolean isLinked() {
        return this.gatePos != null && this.getConfig().getOption(ConfigOptions.ENABLE_GATE_LINK.id).getBooleanValue() && this.field_145850_b.func_175625_s(this.gatePos) instanceof StargateUniverseBaseTile;
    }

    public void setLinkedGate(BlockPos dhdPos, int linkId) {
        if (dhdPos != null && !this.getConfig().getOption(ConfigOptions.ENABLE_GATE_LINK.id).getBooleanValue()) {
            return;
        }
        this.gatePos = dhdPos;
        this.linkId = linkId;
        this.func_70296_d();
    }

    public void updateLinkStatus() {
        StargateUniverseBaseTile stargateUniverseBaseTile;
        BlockPos closestUnlinked = LinkingHelper.findClosestUnlinked(this.field_145850_b, this.field_174879_c, LinkingHelper.getDhdRange(), JSGBlocks.STARGATE_UNIVERSE_BASE_BLOCK, this.getLinkId());
        int linkId = LinkingHelper.getLinkId();
        if (closestUnlinked != null && (stargateUniverseBaseTile = (StargateUniverseBaseTile)this.field_145850_b.func_175625_s(closestUnlinked)) != null) {
            if (!this.getConfig().getOption(ConfigOptions.ENABLE_GATE_LINK.id).getBooleanValue()) {
                this.setLinkedGate(null, -1);
                stargateUniverseBaseTile.setLinkedCountdown(null, -1);
                return;
            }
            stargateUniverseBaseTile.setLinkedCountdown(this.field_174879_c, linkId);
            this.setLinkedGate(closestUnlinked, linkId);
            this.func_70296_d();
        }
        if (!this.getConfig().getOption(ConfigOptions.ENABLE_GATE_LINK.id).getBooleanValue()) {
            this.setLinkedGate(null, -1);
        }
    }

    @Override
    public boolean prepare(ICommandSender sender, ICommand command) {
        this.setLinkedGate(null, -1);
        return true;
    }

    @Override
    public int getLinkId() {
        return this.linkId;
    }

    @Override
    public JSGTileEntityConfig getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(JSGTileEntityConfig config) {
        for (JSGConfigOption o : config.getOptions()) {
            this.config.getOption(o.id).setValue(o.getStringValue());
        }
        this.func_70296_d();
        this.updateLinkStatus();
    }

    @Override
    public void initConfig() {
        JSGTileEntityConfig.initConfig(this.getConfig(), ConfigOptions.values());
    }

    public void onChunkUnload() {
        if (this.node != null) {
            this.node.remove();
        }
        super.onChunkUnload();
    }

    public void func_145843_s() {
        if (this.node != null) {
            this.node.remove();
        }
        super.func_145843_s();
    }

    @Optional.Method(modid="opencomputers")
    public Node node() {
        return this.node;
    }

    @Optional.Method(modid="opencomputers")
    public void onConnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onDisconnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onMessage(Message message) {
    }

    public void sendSignal(Object context, String name, Object ... params) {
        JSG.ocWrapper.sendSignalToReachable(this.node, (Context)context, name, params);
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getJSGVersion(Context context, Arguments args) {
        return new Object[]{"1.12.2-4.11.0.8"};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function(long) -- set countdown to a time in ticks")
    public Object[] setCountdown(Context context, Arguments args) {
        if (!args.isInteger(0)) {
            return new Object[]{false, "Please, insert a number as first argument!"};
        }
        long time = args.checkInteger(0);
        this.setCountDown(this.field_145850_b.func_82737_E() + time);
        return new Object[]{true, "Countdown set to " + time + " ticks!"};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(getter=true)
    public Object[] remainingTicks(Context context, Arguments args) {
        return new Object[]{this.getCountdownTicks()};
    }

    public static enum ConfigOptions implements ITileConfigEntry
    {
        ENABLE_GATE_LINK(0, "enableGateLink", JSGConfigOptionTypeEnum.BOOLEAN, "true", "Enable linking to a universe gate?"),
        ENABLE_GATE_OPENING(1, "enableGateOpening", JSGConfigOptionTypeEnum.BOOLEAN, "true", "Enable opening linked gate after countdown set?", "This option needs enabled \"enableGateLink\" option!"),
        ENABLE_GATE_CLOSING(2, "enableGateClosing", JSGConfigOptionTypeEnum.BOOLEAN, "true", "Enable closing linked gate after countdown reach zero?", "This option needs enabled \"enableGateLink\" option!"),
        SWITCH_TO_CLOCK(3, "switchToClock", JSGConfigOptionTypeEnum.BOOLEAN, "false", "Switch countdown to clock when its turned off");

        public final int id;
        public final String label;
        public final String[] comment;
        public final JSGConfigOptionTypeEnum type;
        public final String defaultValue;
        public List<JSGConfigEnumEntry> possibleValues;
        public final int minInt;
        public final int maxInt;

        private ConfigOptions(int optionId, String label, JSGConfigOptionTypeEnum type, String defaultValue, String ... comment) {
            this(optionId, label, type, defaultValue, -1, -1, comment);
        }

        private ConfigOptions(int optionId, String label, JSGConfigOptionTypeEnum type, String defaultValue, int minInt, int maxInt, String ... comment) {
            this.id = optionId;
            this.label = label;
            this.type = type;
            this.defaultValue = defaultValue;
            this.minInt = minInt;
            this.maxInt = maxInt;
            this.comment = comment;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public String[] getComment() {
            return this.comment;
        }

        @Override
        public JSGConfigOptionTypeEnum getType() {
            return this.type;
        }

        @Override
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public List<JSGConfigEnumEntry> getPossibleValues() {
            return this.possibleValues;
        }

        @Override
        public int getMin() {
            return this.minInt;
        }

        @Override
        public int getMax() {
            return this.maxInt;
        }
    }

    public static enum EnumCountDownEventType {
        START,
        ONE_MINUTE,
        ZERO;

    }
}

