/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public class FacingHelper {
    private static final Map<EnumFacing, Rotation> ROTATION_MAP = new HashMap<EnumFacing, Rotation>();

    public static int toInt(EnumFacing f) {
        if (f == null) {
            return 0;
        }
        switch (f) {
            case NORTH: {
                return 1;
            }
            case WEST: {
                return 2;
            }
            case EAST: {
                return 3;
            }
            case UP: {
                return 4;
            }
            case DOWN: {
                return 5;
            }
        }
        return 0;
    }

    public static EnumFacing fromInt(int i) {
        switch (i) {
            case 1: {
                return EnumFacing.NORTH;
            }
            case 2: {
                return EnumFacing.WEST;
            }
            case 3: {
                return EnumFacing.EAST;
            }
            case 4: {
                return EnumFacing.UP;
            }
            case 5: {
                return EnumFacing.DOWN;
            }
        }
        return EnumFacing.SOUTH;
    }

    public static Rotation getRotation(EnumFacing facing) {
        return ROTATION_MAP.get(facing);
    }

    public static int getIntRotation(EnumFacing facing, boolean inverted) {
        switch (facing) {
            case EAST: 
            case DOWN: {
                return inverted ? 90 : 270;
            }
            case SOUTH: {
                return !inverted ? 180 : 0;
            }
            case WEST: 
            case UP: {
                return !inverted ? 90 : 270;
            }
        }
        return inverted ? 180 : 0;
    }

    public static EnumFacing getVerticalFacingFromPitch(float pitch) {
        if (pitch < -45.0f) {
            return EnumFacing.DOWN;
        }
        if (pitch > 45.0f) {
            return EnumFacing.UP;
        }
        return EnumFacing.SOUTH;
    }

    public static BlockPos rotateBlock(BlockPos pos, EnumFacing horizontalFacing, EnumFacing verticalFacing) {
        BlockPos newPos = pos;
        switch (verticalFacing) {
            case UP: {
                newPos = new BlockPos(pos.func_177958_n(), pos.func_177952_p(), -pos.func_177956_o());
                break;
            }
            case DOWN: {
                newPos = new BlockPos(pos.func_177958_n(), -pos.func_177952_p(), pos.func_177956_o());
                break;
            }
        }
        switch (horizontalFacing) {
            default: {
                break;
            }
            case WEST: {
                return new BlockPos(-newPos.func_177952_p(), newPos.func_177956_o(), newPos.func_177958_n());
            }
            case NORTH: {
                return new BlockPos(-newPos.func_177958_n(), newPos.func_177956_o(), -newPos.func_177952_p());
            }
            case EAST: {
                return new BlockPos(newPos.func_177952_p(), newPos.func_177956_o(), -newPos.func_177958_n());
            }
        }
        return newPos;
    }

    static {
        block6: for (EnumFacing facing : EnumFacing.field_176754_o) {
            switch (facing) {
                case SOUTH: {
                    ROTATION_MAP.put(facing, Rotation.NONE);
                    continue block6;
                }
                case WEST: {
                    ROTATION_MAP.put(facing, Rotation.CLOCKWISE_90);
                    continue block6;
                }
                case NORTH: {
                    ROTATION_MAP.put(facing, Rotation.CLOCKWISE_180);
                    continue block6;
                }
                case EAST: {
                    ROTATION_MAP.put(facing, Rotation.COUNTERCLOCKWISE_90);
                    continue block6;
                }
            }
        }
    }
}

