/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.util.math;

public class TemperatureHelper {
    public static Kelvins asKelvins(double n) {
        return new Kelvins(n);
    }

    public static Celsius asCelsius(double n) {
        return new Celsius(n);
    }

    public static Fahrenheits asFahrenheits(double n) {
        return new Fahrenheits(n);
    }

    public static class Fahrenheits {
        public final double n;

        private Fahrenheits(double n) {
            this.n = n;
        }

        public double toCelsius() {
            return (this.n - 32.0) / 1.8;
        }

        public double toKelvins() {
            return this.toCelsius() + 273.15;
        }
    }

    public static class Celsius {
        public final double n;

        private Celsius(double n) {
            this.n = n;
        }

        public double toFahrenheits() {
            return this.n * 1.8 + 32.0;
        }

        public double toKelvins() {
            return this.n + 273.15;
        }
    }

    public static class Kelvins {
        public final double n;

        private Kelvins(double n) {
            this.n = n;
        }

        public double toFahrenheits() {
            return this.toCelsius() * 1.8 + 32.0;
        }

        public double toCelsius() {
            return this.n - 273.15;
        }
    }

    public static enum EnumTemperatureUnit {
        KELVIN(0, "K"),
        CELSIUS(1, "\u00b0C"),
        FAHRENHEITS(2, "\u00b0F");

        public final int id;
        public final String displayUnit;

        private EnumTemperatureUnit(int id, String displayUnit) {
            this.id = id;
            this.displayUnit = displayUnit;
        }

        public double getTemperature(Kelvins temperature) {
            switch (this) {
                default: {
                    return temperature.n;
                }
                case CELSIUS: {
                    return temperature.toCelsius();
                }
                case FAHRENHEITS: 
            }
            return temperature.toFahrenheits();
        }

        public String getTemperatureToDisplay(Kelvins temperature, int decimals) {
            double temp = this.getTemperature(temperature);
            return String.format("%." + decimals + "f", temp) + this.displayUnit;
        }
    }
}

