/*
 * Decompiled with CFR 0.152.
 */
package appeng.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.IPart;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.me.SlotME;
import appeng.container.ContainerOpenContext;
import appeng.container.guisync.GuiSync;
import appeng.container.guisync.SyncData;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.SlotCraftingMatrix;
import appeng.container.slot.SlotCraftingTerm;
import appeng.container.slot.SlotDisabled;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotInaccessible;
import appeng.container.slot.SlotPlayerHotBar;
import appeng.container.slot.SlotPlayerInv;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.core.sync.packets.PacketTargetItemStack;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.InventoryAction;
import appeng.me.helpers.PlayerSource;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.WrapperCursorItemHandler;
import appeng.util.item.AEItemStack;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;

public abstract class AEBaseContainer
extends Container {
    private final InventoryPlayer invPlayer;
    private final IActionSource mySrc;
    private final HashSet<Integer> locked = new HashSet();
    private final TileEntity tileEntity;
    private final IPart part;
    private final IGuiItemObject obj;
    private final HashMap<Integer, SyncData> syncData = new HashMap();
    private boolean isContainerValid = true;
    private String customName;
    private ContainerOpenContext openContext;
    private IMEInventoryHandler<IAEItemStack> cellInv;
    private IEnergySource powerSrc;
    private boolean sentCustomName;
    private int ticksSinceCheck = 900;
    private IAEItemStack clientRequestedTargetItem = null;

    public AEBaseContainer(InventoryPlayer ip, TileEntity myTile, IPart myPart) {
        this(ip, myTile, myPart, null);
    }

    public AEBaseContainer(InventoryPlayer ip, TileEntity myTile, IPart myPart, IGuiItemObject gio) {
        this.invPlayer = ip;
        this.tileEntity = myTile;
        this.part = myPart;
        this.obj = gio;
        this.mySrc = new PlayerSource(ip.field_70458_d, this.getActionHost());
        this.prepareSync();
    }

    protected IActionHost getActionHost() {
        if (this.obj instanceof IActionHost) {
            return (IActionHost)((Object)this.obj);
        }
        if (this.tileEntity instanceof IActionHost) {
            return (IActionHost)this.tileEntity;
        }
        if (this.part instanceof IActionHost) {
            return (IActionHost)((Object)this.part);
        }
        return null;
    }

    private void prepareSync() {
        for (Field f : ((Object)((Object)this)).getClass().getFields()) {
            if (!f.isAnnotationPresent(GuiSync.class)) continue;
            GuiSync annotation = f.getAnnotation(GuiSync.class);
            if (this.syncData.containsKey(annotation.value())) {
                AELog.warn("Channel already in use: " + annotation.value() + " for " + f.getName(), new Object[0]);
                continue;
            }
            this.syncData.put(annotation.value(), new SyncData(this, f, annotation));
        }
    }

    public AEBaseContainer(InventoryPlayer ip, Object anchor) {
        this.invPlayer = ip;
        this.tileEntity = anchor instanceof TileEntity ? (TileEntity)anchor : null;
        this.part = anchor instanceof IPart ? (IPart)anchor : null;
        IGuiItemObject iGuiItemObject = this.obj = anchor instanceof IGuiItemObject ? (IGuiItemObject)anchor : null;
        if (this.tileEntity == null && this.part == null && this.obj == null) {
            throw new IllegalArgumentException("Must have a valid anchor, instead " + anchor + " in " + ip);
        }
        this.mySrc = new PlayerSource(ip.field_70458_d, this.getActionHost());
        this.prepareSync();
    }

    public IAEItemStack getTargetStack() {
        return this.clientRequestedTargetItem;
    }

    public void setTargetStack(IAEItemStack stack) {
        if (Platform.isClient()) {
            if (stack == null && this.clientRequestedTargetItem == null) {
                return;
            }
            if (stack != null && stack.isSameType(this.clientRequestedTargetItem)) {
                return;
            }
            NetworkHandler.instance().sendToServer(new PacketTargetItemStack((AEItemStack)stack));
        }
        this.clientRequestedTargetItem = stack == null ? null : stack.copy();
    }

    public IActionSource getActionSource() {
        return this.mySrc;
    }

    public void verifyPermissions(SecurityPermissions security, boolean requirePower) {
        if (Platform.isClient()) {
            return;
        }
        ++this.ticksSinceCheck;
        if (this.ticksSinceCheck < 20) {
            return;
        }
        this.ticksSinceCheck = 0;
        this.setValidContainer(this.isValidContainer() && this.hasAccess(security, requirePower));
    }

    protected boolean hasAccess(SecurityPermissions perm, boolean requirePower) {
        IGrid g;
        IGridNode gn;
        IActionHost host = this.getActionHost();
        if (host != null && (gn = host.getActionableNode()) != null && (g = gn.getGrid()) != null) {
            IEnergyGrid eg;
            if (requirePower && !(eg = (IEnergyGrid)g.getCache(IEnergyGrid.class)).isNetworkPowered()) {
                return false;
            }
            ISecurityGrid sg = (ISecurityGrid)g.getCache(ISecurityGrid.class);
            if (sg.hasPermission(this.getInventoryPlayer().field_70458_d, perm)) {
                return true;
            }
        }
        return false;
    }

    public void lockPlayerInventorySlot(int idx) {
        this.locked.add(idx);
    }

    public Object getTarget() {
        if (this.tileEntity != null) {
            return this.tileEntity;
        }
        if (this.part != null) {
            return this.part;
        }
        if (this.obj != null) {
            return this.obj;
        }
        return null;
    }

    public InventoryPlayer getPlayerInv() {
        return this.getInventoryPlayer();
    }

    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    public final void updateFullProgressBar(int idx, long value) {
        if (this.syncData.containsKey(idx)) {
            this.syncData.get(idx).update(value);
            return;
        }
        this.func_75137_b(idx, (int)value);
    }

    public void stringSync(int idx, String value) {
        if (this.syncData.containsKey(idx)) {
            this.syncData.get(idx).update(value);
        }
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer, int offsetX, int offsetY) {
        int i;
        PlayerInvWrapper ih = new PlayerInvWrapper(inventoryPlayer);
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.locked.contains(j + i * 9 + 9)) {
                    this.func_75146_a(new SlotDisabled((IItemHandler)ih, j + i * 9 + 9, 8 + j * 18 + offsetX, offsetY + i * 18));
                    continue;
                }
                this.func_75146_a(new SlotPlayerInv((IItemHandler)ih, j + i * 9 + 9, 8 + j * 18 + offsetX, offsetY + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (this.locked.contains(i)) {
                this.func_75146_a(new SlotDisabled((IItemHandler)ih, i, 8 + i * 18 + offsetX, 58 + offsetY));
                continue;
            }
            this.func_75146_a(new SlotPlayerHotBar((IItemHandler)ih, i, 8 + i * 18 + offsetX, 58 + offsetY));
        }
    }

    protected Slot func_75146_a(Slot newSlot) {
        if (newSlot instanceof AppEngSlot) {
            AppEngSlot s = (AppEngSlot)newSlot;
            s.setContainer(this);
            return super.func_75146_a(newSlot);
        }
        throw new IllegalArgumentException("Invalid Slot [" + newSlot + "] for AE Container instead of AppEngSlot.");
    }

    public void func_75142_b() {
        this.sendCustomName();
        if (Platform.isServer()) {
            if (this.tileEntity != null && this.tileEntity.func_145831_w().func_175625_s(this.tileEntity.func_174877_v()) != this.tileEntity) {
                this.setValidContainer(false);
            }
            for (IContainerListener listener : this.field_75149_d) {
                for (SyncData sd : this.syncData.values()) {
                    sd.tick(listener);
                }
            }
        }
        super.func_75142_b();
    }

    public ItemStack func_82846_b(EntityPlayer p, int idx) {
        if (Platform.isClient()) {
            return ItemStack.field_190927_a;
        }
        AppEngSlot clickSlot = (AppEngSlot)((Object)this.field_75151_b.get(idx));
        if (clickSlot instanceof SlotDisabled || clickSlot instanceof SlotInaccessible) {
            return ItemStack.field_190927_a;
        }
        if (clickSlot != null && clickSlot.func_75216_d()) {
            AppEngSlot cs;
            ItemStack tis = clickSlot.func_75211_c();
            if (tis.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            ArrayList<AppEngSlot> selectedSlots = new ArrayList<AppEngSlot>();
            if (clickSlot.isPlayerSide()) {
                if (!(tis = this.transferStackToContainer(tis)).func_190926_b()) {
                    for (Object e : this.field_75151_b) {
                        cs = (AppEngSlot)((Object)e);
                        if (cs.isPlayerSide() || cs instanceof SlotFake || cs instanceof SlotCraftingMatrix || !cs.func_75214_a(tis)) continue;
                        selectedSlots.add(cs);
                    }
                }
            } else {
                tis = tis.func_77946_l();
                for (Object e : this.field_75151_b) {
                    cs = (AppEngSlot)((Object)e);
                    if (!cs.isPlayerSide() || cs instanceof SlotFake || cs instanceof SlotCraftingMatrix || !cs.func_75214_a(tis)) continue;
                    selectedSlots.add(cs);
                }
            }
            if (selectedSlots.isEmpty() && clickSlot.isPlayerSide() && !tis.func_190926_b()) {
                for (Object e : this.field_75151_b) {
                    cs = (AppEngSlot)((Object)e);
                    ItemStack destination = cs.func_75211_c();
                    if (cs.isPlayerSide() || !(cs instanceof SlotFake)) continue;
                    if (Platform.itemComparisons().isSameItem(destination, tis)) break;
                    if (!destination.func_190926_b()) continue;
                    cs.func_75215_d(tis.func_77946_l());
                    this.updateSlot(cs);
                    break;
                }
            }
            if (!tis.func_190926_b()) {
                int placeAble;
                for (Slot slot : selectedSlots) {
                    if (slot instanceof SlotDisabled || slot instanceof SlotME || !slot.func_75214_a(tis) || !slot.func_75216_d()) continue;
                    ItemStack t = slot.func_75211_c().func_77946_l();
                    if (!Platform.itemComparisons().isSameItem(tis, t)) continue;
                    int maxSize = t.func_77976_d();
                    if (maxSize > slot.func_75219_a()) {
                        maxSize = slot.func_75219_a();
                    }
                    placeAble = maxSize - t.func_190916_E();
                    if (tis.func_190916_E() < placeAble) {
                        placeAble = tis.func_190916_E();
                    }
                    t.func_190920_e(t.func_190916_E() + placeAble);
                    tis.func_190920_e(tis.func_190916_E() - placeAble);
                    slot.func_75215_d(t);
                    if (tis.func_190916_E() <= 0) {
                        clickSlot.func_75215_d(ItemStack.field_190927_a);
                        slot.func_75218_e();
                        this.updateSlot(clickSlot);
                        this.updateSlot(slot);
                        return ItemStack.field_190927_a;
                    }
                    this.updateSlot(slot);
                }
                for (Slot slot : selectedSlots) {
                    ItemStack tmp;
                    if (slot instanceof SlotDisabled || slot instanceof SlotME || !slot.func_75214_a(tis)) continue;
                    if (slot.func_75216_d()) {
                        ItemStack t = slot.func_75211_c().func_77946_l();
                        if (!Platform.itemComparisons().isSameItem(t, tis)) continue;
                        int maxSize = t.func_77976_d();
                        if (slot.func_75219_a() < maxSize) {
                            maxSize = slot.func_75219_a();
                        }
                        placeAble = maxSize - t.func_190916_E();
                        if (tis.func_190916_E() < placeAble) {
                            placeAble = tis.func_190916_E();
                        }
                        t.func_190920_e(t.func_190916_E() + placeAble);
                        tis.func_190920_e(tis.func_190916_E() - placeAble);
                        slot.func_75215_d(t);
                        if (tis.func_190916_E() <= 0) {
                            clickSlot.func_75215_d(ItemStack.field_190927_a);
                            slot.func_75218_e();
                            this.updateSlot(clickSlot);
                            this.updateSlot(slot);
                            return ItemStack.field_190927_a;
                        }
                        this.updateSlot(slot);
                        continue;
                    }
                    int maxSize = tis.func_77976_d();
                    if (maxSize > slot.func_75219_a()) {
                        maxSize = slot.func_75219_a();
                    }
                    if ((tmp = tis.func_77946_l()).func_190916_E() > maxSize) {
                        tmp.func_190920_e(maxSize);
                    }
                    tis.func_190920_e(tis.func_190916_E() - tmp.func_190916_E());
                    slot.func_75215_d(tmp);
                    if (tis.func_190916_E() <= 0) {
                        clickSlot.func_75215_d(ItemStack.field_190927_a);
                        slot.func_75218_e();
                        this.updateSlot(clickSlot);
                        this.updateSlot(slot);
                        return ItemStack.field_190927_a;
                    }
                    this.updateSlot(slot);
                }
            }
            clickSlot.func_75215_d(!tis.func_190926_b() ? tis : ItemStack.field_190927_a);
        }
        this.updateSlot(clickSlot);
        return ItemStack.field_190927_a;
    }

    public final void func_75137_b(int idx, int value) {
        if (this.syncData.containsKey(idx)) {
            this.syncData.get(idx).update(value);
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        if (this.isValidContainer()) {
            if (this.tileEntity instanceof IInventory) {
                return ((IInventory)this.tileEntity).func_70300_a(entityplayer);
            }
            return true;
        }
        return false;
    }

    public boolean func_94531_b(Slot s) {
        return ((AppEngSlot)s).isDraggable();
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        if (slot >= 0 && slot < this.field_75151_b.size()) {
            Slot s = this.func_75139_a(slot);
            if (s instanceof SlotCraftingTerm) {
                switch (action) {
                    case CRAFT_SHIFT: 
                    case CRAFT_ITEM: 
                    case CRAFT_STACK: {
                        ((SlotCraftingTerm)s).doClick(action, (EntityPlayer)player);
                        this.updateHeld(player);
                    }
                }
            }
            if (s instanceof SlotFake) {
                ItemStack hand = player.field_71071_by.func_70445_o();
                switch (action) {
                    case PICKUP_OR_SET_DOWN: {
                        if (hand.func_190926_b()) {
                            s.func_75215_d(ItemStack.field_190927_a);
                            break;
                        }
                        s.func_75215_d(hand.func_77946_l());
                        break;
                    }
                    case PLACE_SINGLE: {
                        if (hand.func_190926_b()) break;
                        Object is = hand.func_77946_l();
                        is.func_190920_e(1);
                        s.func_75215_d((ItemStack)is);
                        break;
                    }
                    case SPLIT_OR_PLACE_SINGLE: {
                        Object is = s.func_75211_c();
                        if (!is.func_190926_b()) {
                            if (hand.func_190926_b()) {
                                is.func_190920_e(Math.max(1, is.func_190916_E() - 1));
                            } else if (hand.func_77969_a((ItemStack)is)) {
                                is.func_190920_e(Math.min(is.func_77976_d(), is.func_190916_E() + 1));
                            } else {
                                is = hand.func_77946_l();
                                is.func_190920_e(1);
                            }
                            s.func_75215_d((ItemStack)is);
                            break;
                        }
                        if (hand.func_190926_b()) break;
                        is = hand.func_77946_l();
                        is.func_190920_e(1);
                        s.func_75215_d((ItemStack)is);
                        break;
                    }
                }
            }
            if (action == InventoryAction.MOVE_REGION) {
                ArrayList<Slot> from = new ArrayList<Slot>();
                for (Object j : this.field_75151_b) {
                    if (!(j instanceof Slot) || j.getClass() != s.getClass() || j instanceof SlotCraftingTerm) continue;
                    from.add((Slot)j);
                }
                for (Slot fr : from) {
                    this.func_82846_b((EntityPlayer)player, fr.field_75222_d);
                }
            }
            return;
        }
        IAEItemStack slotItem = this.clientRequestedTargetItem;
        switch (action) {
            case SHIFT_CLICK: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (slotItem == null) break;
                IAEItemStack ais = slotItem.copy();
                ItemStack myItem = ais.createItemStack();
                ais.setStackSize(myItem.func_77976_d());
                InventoryAdaptor adp = InventoryAdaptor.getAdaptor((EntityPlayer)player);
                myItem.func_190920_e((int)ais.getStackSize());
                myItem = adp.simulateAdd(myItem);
                if (!myItem.func_190926_b()) {
                    ais.setStackSize(ais.getStackSize() - (long)myItem.func_190916_E());
                }
                if ((ais = Platform.poweredExtraction(this.getPowerSource(), this.getCellInventory(), ais, this.getActionSource())) == null) break;
                adp.addItems(ais.createItemStack());
                break;
            }
            case ROLL_DOWN: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                boolean releaseQty = true;
                ItemStack isg = player.field_71071_by.func_70445_o();
                if (isg.func_190926_b()) break;
                IAEItemStack ais = (IAEItemStack)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(isg);
                ais.setStackSize(1L);
                IAEItemStack extracted = ais.copy();
                ais = Platform.poweredInsert(this.getPowerSource(), this.getCellInventory(), ais, this.getActionSource());
                if (ais != null) break;
                AdaptorItemHandler ia = new AdaptorItemHandler((IItemHandler)new WrapperCursorItemHandler(player.field_71071_by));
                ItemStack fail = ((InventoryAdaptor)ia).removeItems(1, extracted.getDefinition(), null);
                if (fail.func_190926_b()) {
                    this.getCellInventory().extractItems(extracted, Actionable.MODULATE, this.getActionSource());
                }
                this.updateHeld(player);
                break;
            }
            case ROLL_UP: 
            case PICKUP_SINGLE: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (slotItem == null) break;
                int liftQty = 1;
                ItemStack item = player.field_71071_by.func_70445_o();
                if (!item.func_190926_b()) {
                    if (item.func_190916_E() >= item.func_77976_d()) {
                        liftQty = 0;
                    }
                    if (!Platform.itemComparisons().isSameItem(slotItem.getDefinition(), item)) {
                        liftQty = 0;
                    }
                }
                if (liftQty <= 0) break;
                IAEItemStack ais = slotItem.copy();
                ais.setStackSize(1L);
                ais = Platform.poweredExtraction(this.getPowerSource(), this.getCellInventory(), ais, this.getActionSource());
                if (ais == null) break;
                AdaptorItemHandler ia = new AdaptorItemHandler((IItemHandler)new WrapperCursorItemHandler(player.field_71071_by));
                ItemStack fail = ((InventoryAdaptor)ia).addItems(ais.createItemStack());
                if (!fail.func_190926_b()) {
                    this.getCellInventory().injectItems(ais, Actionable.MODULATE, this.getActionSource());
                }
                this.updateHeld(player);
                break;
            }
            case PICKUP_OR_SET_DOWN: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (player.field_71071_by.func_70445_o().func_190926_b()) {
                    if (slotItem == null) break;
                    IAEItemStack ais = slotItem.copy();
                    ais.setStackSize(ais.getDefinition().func_77976_d());
                    ais = Platform.poweredExtraction(this.getPowerSource(), this.getCellInventory(), ais, this.getActionSource());
                    if (ais != null) {
                        player.field_71071_by.func_70437_b(ais.createItemStack());
                    } else {
                        player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                    }
                    this.updateHeld(player);
                    break;
                }
                IAEItemStack ais = (IAEItemStack)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(player.field_71071_by.func_70445_o());
                ais = Platform.poweredInsert(this.getPowerSource(), this.getCellInventory(), ais, this.getActionSource());
                if (ais != null) {
                    player.field_71071_by.func_70437_b(ais.createItemStack());
                } else {
                    player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                }
                this.updateHeld(player);
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (player.field_71071_by.func_70445_o().func_190926_b()) {
                    if (slotItem == null) break;
                    IAEItemStack ais = slotItem.copy();
                    long maxSize = ais.getDefinition().func_77976_d();
                    ais.setStackSize(maxSize);
                    ais = this.getCellInventory().extractItems(ais, Actionable.SIMULATE, this.getActionSource());
                    if (ais != null) {
                        long stackSize = Math.min(maxSize, ais.getStackSize());
                        ais.setStackSize(stackSize + 1L >> 1);
                        ais = Platform.poweredExtraction(this.getPowerSource(), this.getCellInventory(), ais, this.getActionSource());
                    }
                    if (ais != null) {
                        player.field_71071_by.func_70437_b(ais.createItemStack());
                    } else {
                        player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                    }
                    this.updateHeld(player);
                    break;
                }
                IAEItemStack ais = (IAEItemStack)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(player.field_71071_by.func_70445_o());
                ais.setStackSize(1L);
                ais = Platform.poweredInsert(this.getPowerSource(), this.getCellInventory(), ais, this.getActionSource());
                if (ais != null) break;
                ItemStack is = player.field_71071_by.func_70445_o();
                is.func_190920_e(is.func_190916_E() - 1);
                if (is.func_190916_E() <= 0) {
                    player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                }
                this.updateHeld(player);
                break;
            }
            case CREATIVE_DUPLICATE: {
                if (!player.field_71075_bZ.field_75098_d || slotItem == null) break;
                ItemStack is = slotItem.createItemStack();
                is.func_190920_e(is.func_77976_d());
                player.field_71071_by.func_70437_b(is);
                this.updateHeld(player);
                break;
            }
            case MOVE_REGION: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (slotItem == null) break;
                int playerInv = 36;
                for (int slotNum = 0; slotNum < 36; ++slotNum) {
                    IAEItemStack ais = slotItem.copy();
                    ItemStack myItem = ais.createItemStack();
                    ais.setStackSize(myItem.func_77976_d());
                    InventoryAdaptor adp = InventoryAdaptor.getAdaptor((EntityPlayer)player);
                    myItem.func_190920_e((int)ais.getStackSize());
                    myItem = adp.simulateAdd(myItem);
                    if (!myItem.func_190926_b()) {
                        ais.setStackSize(ais.getStackSize() - (long)myItem.func_190916_E());
                    }
                    if ((ais = Platform.poweredExtraction(this.getPowerSource(), this.getCellInventory(), ais, this.getActionSource())) == null) {
                        return;
                    }
                    adp.addItems(ais.createItemStack());
                }
                break;
            }
        }
    }

    protected void updateHeld(EntityPlayerMP p) {
        if (Platform.isServer()) {
            try {
                NetworkHandler.instance().sendTo(new PacketInventoryAction(InventoryAction.UPDATE_HAND, 0, AEItemStack.fromItemStack(p.field_71071_by.func_70445_o())), p);
            }
            catch (IOException e) {
                AELog.debug(e);
            }
        }
    }

    protected ItemStack transferStackToContainer(ItemStack input) {
        return this.shiftStoreItem(input);
    }

    private ItemStack shiftStoreItem(ItemStack input) {
        if (this.getPowerSource() == null || this.getCellInventory() == null) {
            return input;
        }
        IAEItemStack ais = Platform.poweredInsert(this.getPowerSource(), this.getCellInventory(), AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(input), this.getActionSource());
        if (ais == null) {
            return ItemStack.field_190927_a;
        }
        return ais.createItemStack();
    }

    private void updateSlot(Slot clickSlot) {
        this.func_75142_b();
    }

    private void sendCustomName() {
        if (!this.sentCustomName) {
            this.sentCustomName = true;
            if (Platform.isServer()) {
                ICustomNameObject name = null;
                if (this.part instanceof ICustomNameObject) {
                    name = (ICustomNameObject)((Object)this.part);
                }
                if (this.tileEntity instanceof ICustomNameObject) {
                    name = (ICustomNameObject)this.tileEntity;
                }
                if (this.obj instanceof ICustomNameObject) {
                    name = (ICustomNameObject)((Object)this.obj);
                }
                if (this instanceof ICustomNameObject) {
                    name = (ICustomNameObject)((Object)this);
                }
                if (name != null) {
                    if (name.hasCustomInventoryName()) {
                        this.setCustomName(name.getCustomInventoryName());
                    }
                    if (this.getCustomName() != null) {
                        try {
                            NetworkHandler.instance().sendTo(new PacketValueConfig("CustomName", this.getCustomName()), (EntityPlayerMP)this.getInventoryPlayer().field_70458_d);
                        }
                        catch (IOException e) {
                            AELog.debug(e);
                        }
                    }
                }
            }
        }
    }

    public void swapSlotContents(int slotA, int slotB) {
        ItemStack testB;
        Slot a = this.func_75139_a(slotA);
        Slot b = this.func_75139_a(slotB);
        if (a == null || b == null) {
            return;
        }
        ItemStack isA = a.func_75211_c();
        ItemStack isB = b.func_75211_c();
        if (isA.func_190926_b() && isB.func_190926_b()) {
            return;
        }
        if (!isA.func_190926_b() && !a.func_82869_a(this.getInventoryPlayer().field_70458_d)) {
            return;
        }
        if (!isB.func_190926_b() && !b.func_82869_a(this.getInventoryPlayer().field_70458_d)) {
            return;
        }
        if (!isB.func_190926_b() && !a.func_75214_a(isB)) {
            return;
        }
        if (!isA.func_190926_b() && !b.func_75214_a(isA)) {
            return;
        }
        ItemStack testA = isB.func_190926_b() ? ItemStack.field_190927_a : isB.func_77946_l();
        ItemStack itemStack = testB = isA.func_190926_b() ? ItemStack.field_190927_a : isA.func_77946_l();
        if (!testA.func_190926_b() && testA.func_190916_E() > a.func_75219_a()) {
            if (!testB.func_190926_b()) {
                return;
            }
            int totalA = testA.func_190916_E();
            testA.func_190920_e(a.func_75219_a());
            testB = testA.func_77946_l();
            testB.func_190920_e(totalA - testA.func_190916_E());
        }
        if (!testB.func_190926_b() && testB.func_190916_E() > b.func_75219_a()) {
            if (!testA.func_190926_b()) {
                return;
            }
            int totalB = testB.func_190916_E();
            testB.func_190920_e(b.func_75219_a());
            testA = testB.func_77946_l();
            testA.func_190920_e(totalB - testA.func_190916_E());
        }
        a.func_75215_d(testA);
        b.func_75215_d(testB);
    }

    public void onUpdate(String field, Object oldValue, Object newValue) {
    }

    public void onSlotChange(Slot s) {
    }

    public boolean isValidForSlot(Slot s, ItemStack i) {
        return true;
    }

    public IMEInventoryHandler<IAEItemStack> getCellInventory() {
        return this.cellInv;
    }

    public void setCellInventory(IMEInventoryHandler<IAEItemStack> cellInv) {
        this.cellInv = cellInv;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public InventoryPlayer getInventoryPlayer() {
        return this.invPlayer;
    }

    public boolean isValidContainer() {
        return this.isContainerValid;
    }

    public void setValidContainer(boolean isContainerValid) {
        this.isContainerValid = isContainerValid;
    }

    public ContainerOpenContext getOpenContext() {
        return this.openContext;
    }

    public void setOpenContext(ContainerOpenContext openContext) {
        this.openContext = openContext;
    }

    public IEnergySource getPowerSource() {
        return this.powerSrc;
    }

    public void setPowerSource(IEnergySource powerSrc) {
        this.powerSrc = powerSrc;
    }
}

