/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.jarrelocator;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import me.lucko.jarrelocator.RelocatingClassVisitor;
import me.lucko.jarrelocator.RelocatingRemapper;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

final class JarRelocatorTask {
    private final RelocatingRemapper remapper;
    private final JarOutputStream jarOut;
    private final JarFile jarIn;
    private final Set<String> resources = new HashSet<String>();

    JarRelocatorTask(RelocatingRemapper remapper, JarOutputStream jarOut, JarFile jarIn) {
        this.remapper = remapper;
        this.jarOut = jarOut;
        this.jarIn = jarIn;
    }

    void processEntries() throws IOException {
        Enumeration<JarEntry> entries = this.jarIn.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.getName().equals("META-INF/INDEX.LIST") || entry.isDirectory()) continue;
            InputStream entryIn = this.jarIn.getInputStream(entry);
            Throwable throwable = null;
            try {
                this.processEntry(entry, entryIn);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (entryIn == null) continue;
                if (throwable != null) {
                    try {
                        entryIn.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                entryIn.close();
            }
        }
    }

    private void processEntry(JarEntry entry, InputStream entryIn) throws IOException {
        String name = entry.getName();
        String mappedName = this.remapper.map(name);
        this.processDirectory(mappedName, true);
        if (name.endsWith(".class")) {
            this.processClass(name, entryIn);
        } else if (!this.resources.contains(mappedName)) {
            this.processResource(mappedName, entryIn, entry.getTime());
        }
    }

    private void processDirectory(String name, boolean parentsOnly) throws IOException {
        String parentDirectory;
        int index = name.lastIndexOf(47);
        if (index != -1 && !this.resources.contains(parentDirectory = name.substring(0, index))) {
            this.processDirectory(parentDirectory, false);
        }
        if (parentsOnly) {
            return;
        }
        JarEntry entry = new JarEntry(name + "/");
        this.jarOut.putNextEntry(entry);
        this.resources.add(name);
    }

    private void processResource(String name, InputStream entryIn, long lastModified) throws IOException {
        JarEntry jarEntry = new JarEntry(name);
        jarEntry.setTime(lastModified);
        this.jarOut.putNextEntry(jarEntry);
        JarRelocatorTask.copy(entryIn, this.jarOut);
        this.resources.add(name);
    }

    private void processClass(String name, InputStream entryIn) throws IOException {
        ClassReader classReader = new ClassReader(entryIn);
        ClassWriter classWriter = new ClassWriter(0);
        RelocatingClassVisitor classVisitor = new RelocatingClassVisitor(classWriter, this.remapper, name);
        try {
            classReader.accept((ClassVisitor)classVisitor, 8);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error processing class " + name, e);
        }
        byte[] renamedClass = classWriter.toByteArray();
        String mappedName = this.remapper.map(name.substring(0, name.indexOf(46)));
        this.jarOut.putNextEntry(new JarEntry(mappedName + ".class"));
        this.jarOut.write(renamedClass);
    }

    private static void copy(InputStream from, OutputStream to) throws IOException {
        int n;
        byte[] buf = new byte[8192];
        while ((n = from.read(buf)) != -1) {
            to.write(buf, 0, n);
        }
    }
}

