/*
 * Decompiled with CFR 0.152.
 */
package nc.block.item.energy;

import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import javax.annotation.Nullable;
import nc.block.item.NCItemBlock;
import nc.item.energy.ElectricItemManager;
import nc.item.energy.IChargableItem;
import nc.item.energy.ItemEnergyCapabilityProvider;
import nc.tile.internal.energy.EnergyConnection;
import nc.util.InfoHelper;
import nc.util.Lang;
import nc.util.NCMath;
import nc.util.UnitHelper;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="ic2")})
public class ItemBlockEnergy
extends NCItemBlock
implements ISpecialElectricItem,
IChargableItem {
    private final long capacity;
    private final int maxTransfer;
    private final EnergyConnection energyConnection;
    private final int energyTier;

    public ItemBlockEnergy(Block block, long capacity, int energyTier, EnergyConnection connection, String ... tooltip) {
        this(block, capacity, NCMath.toInt(capacity), energyTier, connection, tooltip);
    }

    public ItemBlockEnergy(Block block, long capacity, int maxTransfer, int energyTier, EnergyConnection connection, String ... tooltip) {
        super(block, tooltip);
        this.capacity = capacity;
        this.maxTransfer = maxTransfer;
        this.energyConnection = connection;
        this.energyTier = energyTier;
    }

    @Optional.Method(modid="ic2")
    public IElectricItemManager getManager(ItemStack itemStack) {
        return ElectricItemManager.getElectricItemManager(this);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        InfoHelper.infoLine(tooltip, TextFormatting.LIGHT_PURPLE, Lang.localise("info.nuclearcraft.item_energy.energy_stored") + " " + UnitHelper.prefix(this.getEnergyStored(stack), this.getMaxEnergyStored(stack), 5, "RF"));
        InfoHelper.infoLine(tooltip, TextFormatting.WHITE, Lang.localise("info.nuclearcraft.item_energy.power_tier") + " " + this.getEnergyTier(stack));
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        NBTTagCompound nbt = IChargableItem.getEnergyStorageNBT(stack);
        return nbt != null && nbt.func_74763_f("energy") > 0L;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - MathHelper.func_151237_a((double)((double)this.getEnergyStored(stack) / (double)this.capacity), (double)0.0, (double)1.0);
    }

    @Override
    public long getMaxEnergyStored(ItemStack stack) {
        return this.capacity;
    }

    @Override
    public int getMaxTransfer(ItemStack stack) {
        return this.maxTransfer;
    }

    @Override
    public boolean canReceive(ItemStack stack) {
        return this.energyConnection.canReceive();
    }

    @Override
    public boolean canExtract(ItemStack stack) {
        return this.energyConnection.canExtract();
    }

    @Override
    public EnergyConnection getEnergyConnection(ItemStack stack) {
        return this.energyConnection;
    }

    @Override
    public int getEnergyTier(ItemStack stack) {
        return this.energyTier;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ItemEnergyCapabilityProvider(stack, this.capacity, this.maxTransfer, this.getEnergyStored(stack), this.energyConnection, this.energyTier);
    }
}

