/*
 * Decompiled with CFR 0.152.
 */
package nc.item.energy;

import gregtech.api.capability.GregtechCapabilities;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.item.energy.IChargableItem;
import nc.item.energy.ItemEnergyWrapper;
import nc.item.energy.ItemEnergyWrapperGT;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.energy.EnergyStorage;
import nc.util.NCMath;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;

public class ItemEnergyCapabilityProvider
implements ICapabilityProvider {
    private ItemStack stack;
    private EnergyStorage storage;
    private ItemEnergyWrapper wrapper;
    private ItemEnergyWrapperGT wrapperGT;
    private final int energyTier;

    public ItemEnergyCapabilityProvider(final ItemStack stack, long capacity, final int maxTransfer, long energy, final EnergyConnection energyConnection, int energyTier) {
        this.stack = stack;
        this.storage = new EnergyStorage(capacity, maxTransfer, energy){

            @Override
            public long getEnergyStoredLong() {
                NBTTagCompound nbt = IChargableItem.getEnergyStorageNBT(stack);
                if (nbt == null) {
                    return 0L;
                }
                return Math.min(nbt.func_74763_f("energy"), nbt.func_74763_f("capacity"));
            }

            @Override
            public long getMaxEnergyStoredLong() {
                NBTTagCompound nbt = IChargableItem.getEnergyStorageNBT(stack);
                if (nbt == null) {
                    return 0L;
                }
                return nbt.func_74763_f("capacity");
            }

            @Override
            public int getMaxTransfer() {
                return maxTransfer;
            }

            @Override
            public void setEnergyStored(long newEnergy) {
                NBTTagCompound nbt = IChargableItem.getEnergyStorageNBT(stack);
                if (nbt != null && nbt.func_74764_b("energy")) {
                    nbt.func_74772_a("energy", newEnergy);
                }
            }

            @Override
            public void changeEnergyStored(long changeEnergy) {
                NBTTagCompound nbt = IChargableItem.getEnergyStorageNBT(stack);
                if (nbt != null && nbt.func_74764_b("energy")) {
                    nbt.func_74772_a("energy", NCMath.clamp(nbt.func_74763_f("energy") + changeEnergy / (long)stack.func_190916_E(), 0L, this.getMaxEnergyStored()));
                }
            }

            @Override
            public void setStorageCapacity(long newCapacity) {
                NBTTagCompound nbt = IChargableItem.getEnergyStorageNBT(stack);
                if (nbt != null && nbt.func_74764_b("capacity")) {
                    nbt.func_74772_a("capacity", newCapacity);
                }
            }

            @Override
            public void setMaxTransfer(int newMaxTransfer) {
            }

            @Override
            public boolean canReceive() {
                return energyConnection.canReceive();
            }

            @Override
            public boolean canExtract() {
                return energyConnection.canExtract();
            }

            @Override
            public int receiveEnergy(int maxReceive, boolean simulate) {
                if (!this.canReceive()) {
                    return 0;
                }
                NBTTagCompound nbt = IChargableItem.getEnergyStorageNBT(stack);
                if (nbt == null || !nbt.func_74764_b("energy")) {
                    return 0;
                }
                int energyReceived = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), Math.min(this.getMaxTransfer(), maxReceive));
                if (!simulate) {
                    nbt.func_74772_a("energy", (long)(this.getEnergyStored() + energyReceived / stack.func_190916_E()));
                }
                return energyReceived;
            }

            @Override
            public int extractEnergy(int maxExtract, boolean simulate) {
                if (!this.canExtract()) {
                    return 0;
                }
                NBTTagCompound nbt = IChargableItem.getEnergyStorageNBT(stack);
                if (nbt == null || !nbt.func_74764_b("energy")) {
                    return 0;
                }
                int energyExtracted = Math.min(this.getEnergyStored(), Math.min(this.getMaxTransfer(), maxExtract));
                if (!simulate) {
                    nbt.func_74772_a("energy", (long)(this.getEnergyStored() - energyExtracted / stack.func_190916_E()));
                }
                return energyExtracted;
            }
        };
        this.energyTier = energyTier;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            if (this.wrapper == null) {
                this.wrapper = new ItemEnergyWrapper(this.storage);
            }
            return true;
        }
        if (ModCheck.gregtechLoaded() && NCConfig.enable_gtce_eu && capability == GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM) {
            if (this.wrapperGT == null) {
                this.wrapperGT = new ItemEnergyWrapperGT(this.stack, this.storage, this.energyTier);
            }
            return true;
        }
        return false;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            if (this.wrapper == null) {
                this.wrapper = new ItemEnergyWrapper(this.storage);
            }
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.wrapper);
        }
        if (ModCheck.gregtechLoaded() && NCConfig.enable_gtce_eu && capability == GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM) {
            if (this.wrapperGT == null) {
                this.wrapperGT = new ItemEnergyWrapperGT(this.stack, this.storage, this.energyTier);
            }
            return (T)GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM.cast((Object)this.wrapperGT);
        }
        return null;
    }
}

