/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.block;

import javax.annotation.Nullable;
import nc.block.BlockMeta;
import nc.enumm.IBlockMetaEnum;
import nc.multiblock.Multiblock;
import nc.multiblock.MultiblockValidationError;
import nc.multiblock.tile.ITileMultiblockPart;
import nc.render.BlockHighlightTracker;
import nc.tile.fluid.ITileFluid;
import nc.util.BlockHelper;
import nc.util.Lang;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;

public abstract class BlockMultiblockMetaPart<T extends Enum<T> & IBlockMetaEnum>
extends BlockMeta<T>
implements ITileEntityProvider {
    public BlockMultiblockMetaPart(Class<T> enumm, PropertyEnum<T> property, Material material, CreativeTabs tab) {
        super(enumm, property, material);
        this.field_149758_A = true;
        this.func_149647_a(tab);
        this.canSustainPlant = false;
        this.canCreatureSpawn = false;
    }

    protected boolean rightClickOnPart(World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing facing) {
        return this.rightClickOnPart(world, pos, player, hand, facing, false);
    }

    protected boolean rightClickOnPart(World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing facing, boolean prioritiseGui) {
        ITileFluid tileFluid;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ITileFluid && FluidUtil.getFluidHandler((ItemStack)player.func_184586_b(hand)) != null && BlockHelper.accessTanks(player, hand, facing, tileFluid = (ITileFluid)tile)) {
            return true;
        }
        if (!world.field_72995_K && player.func_184586_b(hand).func_190926_b() && tile instanceof ITileMultiblockPart) {
            Object controller = ((ITileMultiblockPart)tile).getMultiblock();
            if (controller != null) {
                MultiblockValidationError e = ((Multiblock)controller).getLastError();
                if (e != null) {
                    e = e.updatedError(world);
                    player.func_145747_a(e.getChatMessage());
                    if (e.getErrorPos() != null) {
                        BlockHighlightTracker.sendPacket((EntityPlayerMP)player, e.getErrorPos(), 5000L);
                    }
                    return true;
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("nuclearcraft.multiblock_validation.no_controller")));
                return true;
            }
        }
        return prioritiseGui;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!keepInventory) {
            TileEntity tileentity = world.func_175625_s(pos);
            IInventory inv = null;
            if (tileentity instanceof IInventory) {
                inv = (IInventory)tileentity;
            }
            if (inv != null) {
                this.dropItems(world, pos, inv);
                world.func_175666_e(pos, (Block)this);
            }
        }
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        world.func_175698_g(pos);
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }
}

