/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import nc.config.NCConfig;
import nc.init.NCBlocks;
import nc.multiblock.PlacementRule;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.salt.tile.TileSaltFissionHeater;
import nc.multiblock.fission.salt.tile.TileSaltFissionVessel;
import nc.multiblock.fission.solid.tile.TileSolidFissionCell;
import nc.multiblock.fission.solid.tile.TileSolidFissionSink;
import nc.multiblock.fission.tile.IFissionComponent;
import nc.multiblock.fission.tile.IFissionPart;
import nc.multiblock.fission.tile.TileFissionConductor;
import nc.multiblock.fission.tile.TileFissionIrradiator;
import nc.multiblock.fission.tile.TileFissionPart;
import nc.multiblock.fission.tile.TileFissionShield;
import nc.recipe.NCRecipes;
import nc.recipe.RecipeHelper;
import nc.util.StringHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public abstract class FissionPlacement {
    public static final List<PlacementRule.RuleParser<FissionReactor, IFissionPart>> RULE_PARSER_LIST = new LinkedList<PlacementRule.RuleParser<FissionReactor, IFissionPart>>();
    public static final Object2ObjectMap<String, String> RULE_MAP_RAW = new Object2ObjectArrayMap();
    public static final Object2ObjectMap<String, PlacementRule<FissionReactor, IFissionPart>> RULE_MAP = new PlacementRule.PlacementMap();
    public static final List<PlacementRule.TooltipBuilder<FissionReactor, IFissionPart>> TOOLTIP_BUILDER_LIST = new LinkedList<PlacementRule.TooltipBuilder<FissionReactor, IFissionPart>>();
    public static PlacementRule.RecipeHandler recipe_handler;
    public static final Object2ObjectMap<String, String> TOOLTIP_MAP;

    public static void preInit() {
        RULE_PARSER_LIST.add(new DefaultRuleParser());
        TOOLTIP_BUILDER_LIST.add(new DefaultTooltipBuilder());
    }

    public static void init() {
        recipe_handler = new RecipeHandler();
        RULE_MAP.put((Object)"", new PlacementRule.Or(new ArrayList()));
        FissionPlacement.addRule("water_sink", NCConfig.fission_sink_rule[0], new ItemStack(NCBlocks.solid_fission_sink, 1, 0));
        FissionPlacement.addRule("iron_sink", NCConfig.fission_sink_rule[1], new ItemStack(NCBlocks.solid_fission_sink, 1, 1));
        FissionPlacement.addRule("redstone_sink", NCConfig.fission_sink_rule[2], new ItemStack(NCBlocks.solid_fission_sink, 1, 2));
        FissionPlacement.addRule("quartz_sink", NCConfig.fission_sink_rule[3], new ItemStack(NCBlocks.solid_fission_sink, 1, 3));
        FissionPlacement.addRule("obsidian_sink", NCConfig.fission_sink_rule[4], new ItemStack(NCBlocks.solid_fission_sink, 1, 4));
        FissionPlacement.addRule("nether_brick_sink", NCConfig.fission_sink_rule[5], new ItemStack(NCBlocks.solid_fission_sink, 1, 5));
        FissionPlacement.addRule("glowstone_sink", NCConfig.fission_sink_rule[6], new ItemStack(NCBlocks.solid_fission_sink, 1, 6));
        FissionPlacement.addRule("lapis_sink", NCConfig.fission_sink_rule[7], new ItemStack(NCBlocks.solid_fission_sink, 1, 7));
        FissionPlacement.addRule("gold_sink", NCConfig.fission_sink_rule[8], new ItemStack(NCBlocks.solid_fission_sink, 1, 8));
        FissionPlacement.addRule("prismarine_sink", NCConfig.fission_sink_rule[9], new ItemStack(NCBlocks.solid_fission_sink, 1, 9));
        FissionPlacement.addRule("slime_sink", NCConfig.fission_sink_rule[10], new ItemStack(NCBlocks.solid_fission_sink, 1, 10));
        FissionPlacement.addRule("end_stone_sink", NCConfig.fission_sink_rule[11], new ItemStack(NCBlocks.solid_fission_sink, 1, 11));
        FissionPlacement.addRule("purpur_sink", NCConfig.fission_sink_rule[12], new ItemStack(NCBlocks.solid_fission_sink, 1, 12));
        FissionPlacement.addRule("diamond_sink", NCConfig.fission_sink_rule[13], new ItemStack(NCBlocks.solid_fission_sink, 1, 13));
        FissionPlacement.addRule("emerald_sink", NCConfig.fission_sink_rule[14], new ItemStack(NCBlocks.solid_fission_sink, 1, 14));
        FissionPlacement.addRule("copper_sink", NCConfig.fission_sink_rule[15], new ItemStack(NCBlocks.solid_fission_sink, 1, 15));
        FissionPlacement.addRule("tin_sink", NCConfig.fission_sink_rule[16], new ItemStack(NCBlocks.solid_fission_sink2, 1, 0));
        FissionPlacement.addRule("lead_sink", NCConfig.fission_sink_rule[17], new ItemStack(NCBlocks.solid_fission_sink2, 1, 1));
        FissionPlacement.addRule("boron_sink", NCConfig.fission_sink_rule[18], new ItemStack(NCBlocks.solid_fission_sink2, 1, 2));
        FissionPlacement.addRule("lithium_sink", NCConfig.fission_sink_rule[19], new ItemStack(NCBlocks.solid_fission_sink2, 1, 3));
        FissionPlacement.addRule("magnesium_sink", NCConfig.fission_sink_rule[20], new ItemStack(NCBlocks.solid_fission_sink2, 1, 4));
        FissionPlacement.addRule("manganese_sink", NCConfig.fission_sink_rule[21], new ItemStack(NCBlocks.solid_fission_sink2, 1, 5));
        FissionPlacement.addRule("aluminum_sink", NCConfig.fission_sink_rule[22], new ItemStack(NCBlocks.solid_fission_sink2, 1, 6));
        FissionPlacement.addRule("silver_sink", NCConfig.fission_sink_rule[23], new ItemStack(NCBlocks.solid_fission_sink2, 1, 7));
        FissionPlacement.addRule("fluorite_sink", NCConfig.fission_sink_rule[24], new ItemStack(NCBlocks.solid_fission_sink2, 1, 8));
        FissionPlacement.addRule("villiaumite_sink", NCConfig.fission_sink_rule[25], new ItemStack(NCBlocks.solid_fission_sink2, 1, 9));
        FissionPlacement.addRule("carobbiite_sink", NCConfig.fission_sink_rule[26], new ItemStack(NCBlocks.solid_fission_sink2, 1, 10));
        FissionPlacement.addRule("arsenic_sink", NCConfig.fission_sink_rule[27], new ItemStack(NCBlocks.solid_fission_sink2, 1, 11));
        FissionPlacement.addRule("liquid_nitrogen_sink", NCConfig.fission_sink_rule[28], new ItemStack(NCBlocks.solid_fission_sink2, 1, 12));
        FissionPlacement.addRule("liquid_helium_sink", NCConfig.fission_sink_rule[29], new ItemStack(NCBlocks.solid_fission_sink2, 1, 13));
        FissionPlacement.addRule("enderium_sink", NCConfig.fission_sink_rule[30], new ItemStack(NCBlocks.solid_fission_sink2, 1, 14));
        FissionPlacement.addRule("cryotheum_sink", NCConfig.fission_sink_rule[31], new ItemStack(NCBlocks.solid_fission_sink2, 1, 15));
        FissionPlacement.addRule("standard_heater", NCConfig.fission_heater_rule[0], new ItemStack(NCBlocks.salt_fission_heater, 1, 0));
        FissionPlacement.addRule("iron_heater", NCConfig.fission_heater_rule[1], new ItemStack(NCBlocks.salt_fission_heater, 1, 1));
        FissionPlacement.addRule("redstone_heater", NCConfig.fission_heater_rule[2], new ItemStack(NCBlocks.salt_fission_heater, 1, 2));
        FissionPlacement.addRule("quartz_heater", NCConfig.fission_heater_rule[3], new ItemStack(NCBlocks.salt_fission_heater, 1, 3));
        FissionPlacement.addRule("obsidian_heater", NCConfig.fission_heater_rule[4], new ItemStack(NCBlocks.salt_fission_heater, 1, 4));
        FissionPlacement.addRule("nether_brick_heater", NCConfig.fission_heater_rule[5], new ItemStack(NCBlocks.salt_fission_heater, 1, 5));
        FissionPlacement.addRule("glowstone_heater", NCConfig.fission_heater_rule[6], new ItemStack(NCBlocks.salt_fission_heater, 1, 6));
        FissionPlacement.addRule("lapis_heater", NCConfig.fission_heater_rule[7], new ItemStack(NCBlocks.salt_fission_heater, 1, 7));
        FissionPlacement.addRule("gold_heater", NCConfig.fission_heater_rule[8], new ItemStack(NCBlocks.salt_fission_heater, 1, 8));
        FissionPlacement.addRule("prismarine_heater", NCConfig.fission_heater_rule[9], new ItemStack(NCBlocks.salt_fission_heater, 1, 9));
        FissionPlacement.addRule("slime_heater", NCConfig.fission_heater_rule[10], new ItemStack(NCBlocks.salt_fission_heater, 1, 10));
        FissionPlacement.addRule("end_stone_heater", NCConfig.fission_heater_rule[11], new ItemStack(NCBlocks.salt_fission_heater, 1, 11));
        FissionPlacement.addRule("purpur_heater", NCConfig.fission_heater_rule[12], new ItemStack(NCBlocks.salt_fission_heater, 1, 12));
        FissionPlacement.addRule("diamond_heater", NCConfig.fission_heater_rule[13], new ItemStack(NCBlocks.salt_fission_heater, 1, 13));
        FissionPlacement.addRule("emerald_heater", NCConfig.fission_heater_rule[14], new ItemStack(NCBlocks.salt_fission_heater, 1, 14));
        FissionPlacement.addRule("copper_heater", NCConfig.fission_heater_rule[15], new ItemStack(NCBlocks.salt_fission_heater, 1, 15));
        FissionPlacement.addRule("tin_heater", NCConfig.fission_heater_rule[16], new ItemStack(NCBlocks.salt_fission_heater2, 1, 0));
        FissionPlacement.addRule("lead_heater", NCConfig.fission_heater_rule[17], new ItemStack(NCBlocks.salt_fission_heater2, 1, 1));
        FissionPlacement.addRule("boron_heater", NCConfig.fission_heater_rule[18], new ItemStack(NCBlocks.salt_fission_heater2, 1, 2));
        FissionPlacement.addRule("lithium_heater", NCConfig.fission_heater_rule[19], new ItemStack(NCBlocks.salt_fission_heater2, 1, 3));
        FissionPlacement.addRule("magnesium_heater", NCConfig.fission_heater_rule[20], new ItemStack(NCBlocks.salt_fission_heater2, 1, 4));
        FissionPlacement.addRule("manganese_heater", NCConfig.fission_heater_rule[21], new ItemStack(NCBlocks.salt_fission_heater2, 1, 5));
        FissionPlacement.addRule("aluminum_heater", NCConfig.fission_heater_rule[22], new ItemStack(NCBlocks.salt_fission_heater2, 1, 6));
        FissionPlacement.addRule("silver_heater", NCConfig.fission_heater_rule[23], new ItemStack(NCBlocks.salt_fission_heater2, 1, 7));
        FissionPlacement.addRule("fluorite_heater", NCConfig.fission_heater_rule[24], new ItemStack(NCBlocks.salt_fission_heater2, 1, 8));
        FissionPlacement.addRule("villiaumite_heater", NCConfig.fission_heater_rule[25], new ItemStack(NCBlocks.salt_fission_heater2, 1, 9));
        FissionPlacement.addRule("carobbiite_heater", NCConfig.fission_heater_rule[26], new ItemStack(NCBlocks.salt_fission_heater2, 1, 10));
        FissionPlacement.addRule("arsenic_heater", NCConfig.fission_heater_rule[27], new ItemStack(NCBlocks.salt_fission_heater2, 1, 11));
        FissionPlacement.addRule("liquid_nitrogen_heater", NCConfig.fission_heater_rule[28], new ItemStack(NCBlocks.salt_fission_heater2, 1, 12));
        FissionPlacement.addRule("liquid_helium_heater", NCConfig.fission_heater_rule[29], new ItemStack(NCBlocks.salt_fission_heater2, 1, 13));
        FissionPlacement.addRule("enderium_heater", NCConfig.fission_heater_rule[30], new ItemStack(NCBlocks.salt_fission_heater2, 1, 14));
        FissionPlacement.addRule("cryotheum_heater", NCConfig.fission_heater_rule[31], new ItemStack(NCBlocks.salt_fission_heater2, 1, 15));
    }

    public static void addRule(String id, String rule, Object ... blocks) {
        RULE_MAP_RAW.put((Object)id, (Object)rule);
        RULE_MAP.put((Object)id, FissionPlacement.parse(rule));
        for (Object block : blocks) {
            recipe_handler.addRecipe(block, id);
        }
    }

    public static void postInit() {
        for (Object2ObjectMap.Entry entry : RULE_MAP.object2ObjectEntrySet()) {
            for (PlacementRule.TooltipBuilder<FissionReactor, IFissionPart> builder : TOOLTIP_BUILDER_LIST) {
                String tooltip = builder.buildTooltip((PlacementRule)entry.getValue());
                if (tooltip == null) continue;
                TOOLTIP_MAP.put(entry.getKey(), (Object)tooltip);
            }
        }
    }

    public static PlacementRule<FissionReactor, IFissionPart> parse(String string) {
        return PlacementRule.parse(string, RULE_PARSER_LIST);
    }

    public static boolean isCasing(FissionReactor reactor, BlockPos pos) {
        TileEntity tile = reactor.WORLD.func_175625_s(pos);
        return tile instanceof TileFissionPart && ((TileFissionPart)tile).getPartPositionType().isGoodForWall();
    }

    public static boolean isConductor(FissionReactor reactor, BlockPos pos) {
        return reactor.getPartMap(TileFissionConductor.class).get(pos.func_177986_g()) != null;
    }

    public static boolean isActiveModerator(FissionReactor reactor, BlockPos pos) {
        IFissionComponent component = (IFissionComponent)reactor.getPartMap(IFissionComponent.class).get(pos.func_177986_g());
        return component != null && component.isActiveModerator() || reactor.activeModeratorCache.contains(pos.func_177986_g()) && RecipeHelper.blockRecipe(NCRecipes.fission_moderator, reactor.WORLD, pos) != null;
    }

    public static boolean isActiveReflector(FissionReactor reactor, BlockPos pos) {
        return reactor.activeReflectorCache.contains(pos.func_177986_g()) && RecipeHelper.blockRecipe(NCRecipes.fission_reflector, reactor.WORLD, pos) != null;
    }

    public static boolean isFunctionalIrradiator(FissionReactor reactor, BlockPos pos) {
        TileFissionIrradiator irradiator = (TileFissionIrradiator)reactor.getPartMap(TileFissionIrradiator.class).get(pos.func_177986_g());
        return irradiator != null && irradiator.isFunctional();
    }

    public static boolean isFunctionalShield(FissionReactor reactor, BlockPos pos) {
        TileFissionShield shield = (TileFissionShield)reactor.getPartMap(TileFissionShield.class).get(pos.func_177986_g());
        return shield != null && shield.isFunctional();
    }

    public static boolean isFunctionalCell(FissionReactor reactor, BlockPos pos) {
        TileSolidFissionCell cell = (TileSolidFissionCell)reactor.getPartMap(TileSolidFissionCell.class).get(pos.func_177986_g());
        return cell != null && cell.isFunctional();
    }

    public static boolean isValidSink(FissionReactor reactor, BlockPos pos, String sinkType) {
        TileSolidFissionSink sink = (TileSolidFissionSink)reactor.getPartMap(TileSolidFissionSink.class).get(pos.func_177986_g());
        return sink != null && sink.isFunctional() && (sinkType.equals("any") || sink.sinkType.equals(sinkType));
    }

    public static boolean isFunctionalVessel(FissionReactor reactor, BlockPos pos) {
        TileSaltFissionVessel vessel = (TileSaltFissionVessel)reactor.getPartMap(TileSaltFissionVessel.class).get(pos.func_177986_g());
        return vessel != null && vessel.isFunctional();
    }

    public static boolean isValidHeater(FissionReactor reactor, BlockPos pos, String heaterType) {
        TileSaltFissionHeater heater = (TileSaltFissionHeater)reactor.getPartMap(TileSaltFissionHeater.class).get(pos.func_177986_g());
        return heater != null && heater.isFunctional() && (heaterType.equals("any") || heater.heaterType.equals(heaterType));
    }

    static {
        TOOLTIP_MAP = new Object2ObjectOpenHashMap();
    }

    public static class RecipeHandler
    extends PlacementRule.RecipeHandler {
        public RecipeHandler() {
            super("fission");
        }
    }

    public static class DefaultTooltipBuilder
    extends PlacementRule.DefaultTooltipBuilder<FissionReactor, IFissionPart> {
    }

    public static class AdjacentHeater
    extends Adjacent {
        protected final String heaterType;

        public AdjacentHeater(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType, String heaterType) {
            super(heaterType + "_heater", amount, countType, adjType);
            this.heaterType = heaterType;
        }

        @Override
        public void checkIsRuleAllowed(String ruleID) {
            super.checkIsRuleAllowed(ruleID);
            if (this.countType != PlacementRule.CountType.AT_LEAST && this.heaterType.equals("any")) {
                throw new IllegalArgumentException((this.countType == PlacementRule.CountType.EXACTLY ? "Exact 'any heater'" : "'At most n of any heater'") + " placement rule with ID \"" + ruleID + "\" is disallowed due to potential ambiguity during rule checks!");
            }
        }

        @Override
        public boolean satisfied(IFissionPart part, EnumFacing dir) {
            return FissionPlacement.isValidHeater((FissionReactor)part.getMultiblock(), part.getTilePos().func_177972_a(dir), this.heaterType);
        }
    }

    public static class AdjacentVessel
    extends Adjacent {
        public AdjacentVessel(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType) {
            super("vessel", amount, countType, adjType);
        }

        @Override
        public boolean satisfied(IFissionPart part, EnumFacing dir) {
            return FissionPlacement.isFunctionalVessel((FissionReactor)part.getMultiblock(), part.getTilePos().func_177972_a(dir));
        }
    }

    public static class AdjacentSink
    extends Adjacent {
        protected final String sinkType;

        public AdjacentSink(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType, String sinkType) {
            super(sinkType + "_sink", amount, countType, adjType);
            this.sinkType = sinkType;
        }

        @Override
        public void checkIsRuleAllowed(String ruleID) {
            super.checkIsRuleAllowed(ruleID);
            if (this.countType != PlacementRule.CountType.AT_LEAST && this.sinkType.equals("any")) {
                throw new IllegalArgumentException((this.countType == PlacementRule.CountType.EXACTLY ? "Exact 'any sink'" : "'At most n of any sink'") + " placement rule with ID \"" + ruleID + "\" is disallowed due to potential ambiguity during rule checks!");
            }
        }

        @Override
        public boolean satisfied(IFissionPart part, EnumFacing dir) {
            return FissionPlacement.isValidSink((FissionReactor)part.getMultiblock(), part.getTilePos().func_177972_a(dir), this.sinkType);
        }
    }

    public static class AdjacentCell
    extends Adjacent {
        public AdjacentCell(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType) {
            super("cell", amount, countType, adjType);
        }

        @Override
        public boolean satisfied(IFissionPart part, EnumFacing dir) {
            return FissionPlacement.isFunctionalCell((FissionReactor)part.getMultiblock(), part.getTilePos().func_177972_a(dir));
        }
    }

    public static class AdjacentShield
    extends Adjacent {
        public AdjacentShield(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType) {
            super("shield", amount, countType, adjType);
        }

        @Override
        public boolean satisfied(IFissionPart part, EnumFacing dir) {
            return FissionPlacement.isFunctionalShield((FissionReactor)part.getMultiblock(), part.getTilePos().func_177972_a(dir));
        }
    }

    public static class AdjacentIrradiator
    extends Adjacent {
        public AdjacentIrradiator(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType) {
            super("irradiator", amount, countType, adjType);
        }

        @Override
        public boolean satisfied(IFissionPart part, EnumFacing dir) {
            return FissionPlacement.isFunctionalIrradiator((FissionReactor)part.getMultiblock(), part.getTilePos().func_177972_a(dir));
        }
    }

    public static class AdjacentReflector
    extends Adjacent {
        public AdjacentReflector(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType) {
            super("reflector", amount, countType, adjType);
        }

        @Override
        public boolean satisfied(IFissionPart part, EnumFacing dir) {
            return FissionPlacement.isActiveReflector((FissionReactor)part.getMultiblock(), part.getTilePos().func_177972_a(dir));
        }
    }

    public static class AdjacentModerator
    extends Adjacent {
        public AdjacentModerator(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType) {
            super("moderator", amount, countType, adjType);
        }

        @Override
        public boolean satisfied(IFissionPart part, EnumFacing dir) {
            return FissionPlacement.isActiveModerator((FissionReactor)part.getMultiblock(), part.getTilePos().func_177972_a(dir));
        }
    }

    public static class AdjacentConductor
    extends Adjacent {
        public AdjacentConductor(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType) {
            super("conductor", amount, countType, adjType);
        }

        @Override
        public boolean satisfied(IFissionPart part, EnumFacing dir) {
            return FissionPlacement.isConductor((FissionReactor)part.getMultiblock(), part.getTilePos().func_177972_a(dir));
        }
    }

    public static class AdjacentCasing
    extends Adjacent {
        public AdjacentCasing(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType) {
            super("reactor_casing", amount, countType, adjType);
        }

        @Override
        public boolean satisfied(IFissionPart part, EnumFacing dir) {
            return FissionPlacement.isCasing((FissionReactor)part.getMultiblock(), part.getTilePos().func_177972_a(dir));
        }
    }

    public static abstract class Adjacent
    extends PlacementRule.Adjacent<FissionReactor, IFissionPart> {
        public Adjacent(String dependency, int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType) {
            super(dependency, amount, countType, adjType);
        }
    }

    public static class DefaultRuleParser
    extends PlacementRule.DefaultRuleParser<FissionReactor, IFissionPart> {
        @Override
        @Nullable
        protected PlacementRule<FissionReactor, IFissionPart> partialParse(String s) {
            PlacementRule.AdjacencyType adjType;
            PlacementRule.CountType countType;
            s = s.toLowerCase(Locale.ROOT);
            s = s.replaceAll("at exactly one vertex", "vertex");
            boolean exact = s.contains("exact");
            boolean atMost = s.contains("at most");
            boolean axial = s.contains("axial");
            boolean vertex = s.contains("vertex");
            boolean edge = s.contains("edge");
            if (exact && atMost || axial && vertex) {
                return null;
            }
            s = s.replaceAll("at least", "");
            s = s.replaceAll("exactly", "");
            s = s.replaceAll("exact", "");
            s = s.replaceAll("at most", "");
            s = s.replaceAll("axially", "");
            s = s.replaceAll("axial", "");
            s = s.replaceAll("at one vertex", "");
            s = s.replaceAll("at a vertex", "");
            s = s.replaceAll("at vertex", "");
            s = s.replaceAll("vertex", "");
            s = s.replaceAll("at one edge", "");
            s = s.replaceAll("at an edge", "");
            s = s.replaceAll("at edge", "");
            s = s.replaceAll("along one edge", "");
            s = s.replaceAll("along an edge", "");
            s = s.replaceAll("along edge", "");
            s = s.replaceAll("edge", "");
            int amount = -1;
            String rule = null;
            String type = null;
            String[] split = s.split(Pattern.quote(" "));
            for (int i = 0; i < split.length; ++i) {
                if (StringHelper.NUMBER_S2I_MAP.containsKey((Object)split[i])) {
                    amount = StringHelper.NUMBER_S2I_MAP.getInt((Object)split[i]);
                    continue;
                }
                if (rule != null) continue;
                if (split[i].contains("wall") || split[i].contains("casing")) {
                    rule = "casing";
                    continue;
                }
                if (split[i].contains("conductor")) {
                    rule = "conductor";
                    continue;
                }
                if (split[i].contains("moderator")) {
                    rule = "moderator";
                    continue;
                }
                if (split[i].contains("reflector")) {
                    rule = "reflector";
                    continue;
                }
                if (split[i].contains("irradiator")) {
                    rule = "irradiator";
                    continue;
                }
                if (split[i].contains("shield")) {
                    rule = "shield";
                    continue;
                }
                if (split[i].contains("cell")) {
                    rule = "cell";
                    continue;
                }
                if (split[i].contains("sink")) {
                    rule = "sink";
                    if (i > 0) {
                        type = split[i - 1];
                        continue;
                    }
                    return null;
                }
                if (split[i].contains("vessel")) {
                    rule = "vessel";
                    continue;
                }
                if (!split[i].contains("heater")) continue;
                rule = "heater";
                if (i > 0) {
                    type = split[i - 1];
                    continue;
                }
                return null;
            }
            if (amount < 0 || rule == null) {
                return null;
            }
            PlacementRule.CountType countType2 = exact ? PlacementRule.CountType.EXACTLY : (countType = atMost ? PlacementRule.CountType.AT_MOST : PlacementRule.CountType.AT_LEAST);
            PlacementRule.AdjacencyType adjacencyType = axial ? PlacementRule.AdjacencyType.AXIAL : (vertex ? PlacementRule.AdjacencyType.VERTEX : (adjType = edge ? PlacementRule.AdjacencyType.EDGE : PlacementRule.AdjacencyType.STANDARD));
            if (rule.equals("casing")) {
                return new AdjacentCasing(amount, countType, adjType);
            }
            if (rule.equals("conductor")) {
                return new AdjacentConductor(amount, countType, adjType);
            }
            if (rule.equals("moderator")) {
                return new AdjacentModerator(amount, countType, adjType);
            }
            if (rule.equals("reflector")) {
                return new AdjacentReflector(amount, countType, adjType);
            }
            if (rule.equals("irradiator")) {
                return new AdjacentIrradiator(amount, countType, adjType);
            }
            if (rule.equals("shield")) {
                return new AdjacentShield(amount, countType, adjType);
            }
            if (rule.equals("cell")) {
                return new AdjacentCell(amount, countType, adjType);
            }
            if (rule.equals("sink")) {
                return new AdjacentSink(amount, countType, adjType, type);
            }
            if (rule.equals("vessel")) {
                return new AdjacentVessel(amount, countType, adjType);
            }
            if (rule.equals("heater")) {
                return new AdjacentHeater(amount, countType, adjType, type);
            }
            return null;
        }
    }
}

