/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.turbine.tile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.block.property.BlockProperties;
import nc.config.NCConfig;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.turbine.Turbine;
import nc.multiblock.turbine.tile.TileTurbinePart;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.FluidTileWrapper;
import nc.tile.internal.fluid.GasTileWrapper;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankOutputSetting;
import nc.tile.internal.fluid.TankSorption;
import nc.tile.passive.ITilePassive;
import nc.util.CapabilityHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileTurbineOutlet
extends TileTurbinePart
implements ITickable,
ITileFluid {
    @Nonnull
    private final List<Tank> backupTanks = Lists.newArrayList((Object[])new Tank[]{new Tank(1, new ArrayList<String>())});
    @Nonnull
    private FluidConnection[] fluidConnections = ITileFluid.fluidConnectionAll(TankSorption.OUT);
    @Nonnull
    private final FluidTileWrapper[] fluidSides = ITileFluid.getDefaultFluidSides(this);
    @Nonnull
    private final GasTileWrapper gasWrapper = new GasTileWrapper(this);
    protected int outletCount;

    public TileTurbineOutlet() {
        super(CuboidalPartPositionType.WALL);
    }

    @Override
    public void onMachineAssembled(Turbine controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
        if (!this.func_145831_w().field_72995_K && this.getPartPosition().getFacing() != null) {
            this.func_145831_w().func_180501_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a(BlockProperties.AXIS_ALL, (Comparable)this.getPartPosition().getFacing().func_176740_k()), 2);
        }
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.outletCount == 0) {
                this.pushFluid();
            }
            this.tickOutlet();
        }
    }

    public void tickOutlet() {
        ++this.outletCount;
        this.outletCount %= NCConfig.machine_update_rate / 4;
    }

    @Override
    @Nonnull
    public List<Tank> getTanks() {
        if (!this.isMultiblockAssembled()) {
            return this.backupTanks;
        }
        return ((Turbine)this.getMultiblock()).tanks.subList(1, 2);
    }

    @Override
    @Nonnull
    public FluidConnection[] getFluidConnections() {
        return this.fluidConnections;
    }

    @Override
    public void setFluidConnections(@Nonnull FluidConnection[] connections) {
        this.fluidConnections = connections;
    }

    @Override
    @Nonnull
    public FluidTileWrapper[] getFluidSides() {
        return this.fluidSides;
    }

    @Override
    @Nonnull
    public GasTileWrapper getGasWrapper() {
        return this.gasWrapper;
    }

    @Override
    public void pushFluidToSide(@Nonnull EnumFacing side) {
        if (!this.getTankSorption(side, 0).canDrain() || this.getTanks().get(0).getFluid() == null) {
            return;
        }
        TileEntity tile = this.getTileWorld().func_175625_s(this.getTilePos().func_177972_a(side));
        if (tile == null || tile instanceof TileTurbineOutlet) {
            return;
        }
        if (tile instanceof ITilePassive && !((ITilePassive)tile).canPushFluidsTo()) {
            return;
        }
        IFluidHandler adjStorage = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
        if (adjStorage == null || this.getTanks().get(0).getFluid() == null) {
            return;
        }
        this.getTanks().get(0).drain(adjStorage.fill(this.getTanks().get(0).drain(this.getTanks().get(0).getCapacity(), false), true), true);
    }

    @Override
    public boolean getInputTanksSeparated() {
        return false;
    }

    @Override
    public void setInputTanksSeparated(boolean separated) {
    }

    @Override
    public boolean getVoidUnusableFluidInput(int tankNumber) {
        return false;
    }

    @Override
    public void setVoidUnusableFluidInput(int tankNumber, boolean voidUnusableFluidInput) {
    }

    @Override
    public TankOutputSetting getTankOutputSetting(int tankNumber) {
        return TankOutputSetting.DEFAULT;
    }

    @Override
    public void setTankOutputSetting(int tankNumber, TankOutputSetting setting) {
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeFluidConnections(nbt);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readFluidConnections(nbt);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || ModCheck.mekanismLoaded() && NCConfig.enable_mek_gas && capability == CapabilityHelper.GAS_HANDLER_CAPABILITY) {
            return !this.getTanks().isEmpty() && this.hasFluidSideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.getFluidSide(this.nonNullSide(side)));
            }
            return null;
        }
        if (ModCheck.mekanismLoaded() && capability == CapabilityHelper.GAS_HANDLER_CAPABILITY) {
            if (NCConfig.enable_mek_gas && !this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
                return (T)CapabilityHelper.GAS_HANDLER_CAPABILITY.cast((Object)this.getGasWrapper());
            }
            return null;
        }
        return super.getCapability(capability, side);
    }
}

