/*
 * Decompiled with CFR 0.152.
 */
package nc.network.tile;

import io.netty.buffer.ByteBuf;
import java.util.List;
import nc.network.tile.TileUpdatePacket;
import nc.tile.ITileGui;
import nc.tile.internal.fluid.Tank;
import net.minecraft.util.math.BlockPos;

public class ProcessorUpdatePacket
extends TileUpdatePacket {
    public boolean isProcessing;
    public double time;
    public int energyStored;
    public double baseProcessTime;
    public double baseProcessPower;
    public List<Tank.TankInfo> tanksInfo;

    public ProcessorUpdatePacket() {
    }

    public ProcessorUpdatePacket(BlockPos pos, boolean isProcessing, double time, int energyStored, double baseProcessTime, double baseProcessPower, List<Tank> tanks) {
        this.pos = pos;
        this.isProcessing = isProcessing;
        this.time = time;
        this.energyStored = energyStored;
        this.baseProcessTime = baseProcessTime;
        this.baseProcessPower = baseProcessPower;
        this.tanksInfo = Tank.TankInfo.infoList(tanks);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.isProcessing = buf.readBoolean();
        this.time = buf.readDouble();
        this.energyStored = buf.readInt();
        this.baseProcessTime = buf.readDouble();
        this.baseProcessPower = buf.readDouble();
        byte numberOfTanks = buf.readByte();
        this.tanksInfo = Tank.TankInfo.readBuf(buf, numberOfTanks);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeBoolean(this.isProcessing);
        buf.writeDouble(this.time);
        buf.writeInt(this.energyStored);
        buf.writeDouble(this.baseProcessTime);
        buf.writeDouble(this.baseProcessPower);
        buf.writeByte(this.tanksInfo.size());
        for (Tank.TankInfo info : this.tanksInfo) {
            info.writeBuf(buf);
        }
    }

    public static class Handler
    extends TileUpdatePacket.Handler<ProcessorUpdatePacket, ITileGui<ProcessorUpdatePacket>> {
        @Override
        protected void onTileUpdatePacket(ProcessorUpdatePacket message, ITileGui<ProcessorUpdatePacket> processor) {
            processor.onTileUpdatePacket(message);
        }
    }
}

